/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.KeyCredentialAuditEventType;
import com.prosysopc.ua.types.opcua.server.AuditUpdateMethodEventTypeNode;
import com.prosysopc.ua.types.opcua.server.KeyCredentialAuditEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18011")
public abstract class KeyCredentialAuditEventTypeNodeBase
extends AuditUpdateMethodEventTypeNode
implements KeyCredentialAuditEventType {
    private static GeneratedNodeInitializer<KeyCredentialAuditEventTypeNode> Kl;

    protected KeyCredentialAuditEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<KeyCredentialAuditEventTypeNode> generatedNodeInitializer = KeyCredentialAuditEventTypeNodeBase.getKeyCredentialAuditEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((KeyCredentialAuditEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<KeyCredentialAuditEventTypeNode> getKeyCredentialAuditEventTypeNodeInitializer() {
        return Kl;
    }

    public static void setKeyCredentialAuditEventTypeNodeInitializer(GeneratedNodeInitializer<KeyCredentialAuditEventTypeNode> generatedNodeInitializer) {
        Kl = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getResourceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResourceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getResourceUri() {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ResourceUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setResourceUri(String string) {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResourceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ResourceUri failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

