/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.TsnFailureCode;
import com.prosysopc.ua.stack.core.TsnListenerStatus;
import com.prosysopc.ua.stack.core.TsnTalkerStatus;
import com.prosysopc.ua.types.opcua.IIeeeBaseTsnStatusStreamType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IIeeeBaseTsnStatusStreamTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24183")
public abstract class IIeeeBaseTsnStatusStreamTypeNodeBase
extends BaseInterfaceTypeNode
implements IIeeeBaseTsnStatusStreamType {
    private static GeneratedNodeInitializer<IIeeeBaseTsnStatusStreamTypeNode> JQ;

    protected IIeeeBaseTsnStatusStreamTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getListenerStatusNode());
        this.callAfterCreateIfExists(this.getFailureCodeNode());
        this.callAfterCreateIfExists(this.getFailureSystemIdentifierNode());
        this.callAfterCreateIfExists(this.getTalkerStatusNode());
        GeneratedNodeInitializer<IIeeeBaseTsnStatusStreamTypeNode> generatedNodeInitializer = IIeeeBaseTsnStatusStreamTypeNodeBase.getIIeeeBaseTsnStatusStreamTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IIeeeBaseTsnStatusStreamTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IIeeeBaseTsnStatusStreamTypeNode> getIIeeeBaseTsnStatusStreamTypeNodeInitializer() {
        return JQ;
    }

    public static void setIIeeeBaseTsnStatusStreamTypeNodeInitializer(GeneratedNodeInitializer<IIeeeBaseTsnStatusStreamTypeNode> generatedNodeInitializer) {
        JQ = generatedNodeInitializer;
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getListenerStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ListenerStatus");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public TsnListenerStatus getListenerStatus() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getListenerStatusNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (TsnListenerStatus)variant.asEnum(TsnListenerStatus.class);
    }

    @Override
    @Optional
    public void setListenerStatus(TsnListenerStatus tsnListenerStatus) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getListenerStatusNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ListenerStatus failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(tsnListenerStatus);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ListenerStatus failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getFailureCodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FailureCode");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public TsnFailureCode getFailureCode() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getFailureCodeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node FailureCode does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (TsnFailureCode)variant.asEnum(TsnFailureCode.class);
    }

    @Override
    @Mandatory
    public void setFailureCode(TsnFailureCode tsnFailureCode) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getFailureCodeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting FailureCode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(tsnFailureCode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting FailureCode failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getFailureSystemIdentifierNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FailureSystemIdentifier");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte[][] getFailureSystemIdentifier() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getFailureSystemIdentifierNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node FailureSystemIdentifier does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedByte[][])object;
    }

    @Override
    @Mandatory
    public void setFailureSystemIdentifier(UnsignedByte[][] unsignedByteArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getFailureSystemIdentifierNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting FailureSystemIdentifier failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedByteArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting FailureSystemIdentifier failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getTalkerStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TalkerStatus");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public TsnTalkerStatus getTalkerStatus() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTalkerStatusNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (TsnTalkerStatus)variant.asEnum(TsnTalkerStatus.class);
    }

    @Override
    @Optional
    public void setTalkerStatus(TsnTalkerStatus tsnTalkerStatus) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTalkerStatusNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TalkerStatus failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(tsnTalkerStatus);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TalkerStatus failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

