/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.SimpleAttributeOperand;
import com.prosysopc.ua.types.opcua.HistoricalEventConfigurationType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.HistoricalEventConfigurationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32621")
public abstract class HistoricalEventConfigurationTypeNodeBase
extends BaseObjectTypeNode
implements HistoricalEventConfigurationType {
    private static GeneratedNodeInitializer<HistoricalEventConfigurationTypeNode> JJ;

    protected HistoricalEventConfigurationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getEventTypesNode());
        GeneratedNodeInitializer<HistoricalEventConfigurationTypeNode> generatedNodeInitializer = HistoricalEventConfigurationTypeNodeBase.getHistoricalEventConfigurationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((HistoricalEventConfigurationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<HistoricalEventConfigurationTypeNode> getHistoricalEventConfigurationTypeNodeInitializer() {
        return JJ;
    }

    public static void setHistoricalEventConfigurationTypeNodeInitializer(GeneratedNodeInitializer<HistoricalEventConfigurationTypeNode> generatedNodeInitializer) {
        JJ = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getStartOfArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfArchive() {
        UaProperty uaProperty = this.getStartOfArchiveNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfArchive(DateTime dateTime) {
        UaProperty uaProperty = this.getStartOfArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfArchive failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartOfArchive failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getStartOfOnlineArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfOnlineArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfOnlineArchive() {
        UaProperty uaProperty = this.getStartOfOnlineArchiveNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfOnlineArchive(DateTime dateTime) {
        UaProperty uaProperty = this.getStartOfOnlineArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfOnlineArchive failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartOfOnlineArchive failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSortByEventFieldsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SortByEventFields");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public SimpleAttributeOperand[] getSortByEventFields() {
        UaProperty uaProperty = this.getSortByEventFieldsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (SimpleAttributeOperand[])object;
    }

    @Override
    @Optional
    public void setSortByEventFields(SimpleAttributeOperand[] simpleAttributeOperandArray) {
        UaProperty uaProperty = this.getSortByEventFieldsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SortByEventFields failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(simpleAttributeOperandArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SortByEventFields failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public FolderTypeNode getEventTypesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventTypes");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

