/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.FileTypeOpenMode;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionListener;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.server.FileTypeNodeBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11575")
public class FileTypeNode
extends FileTypeNodeBase {
    private static AtomicLong Jo = new AtomicLong(0L);
    private static Logger logger = LoggerFactory.getLogger(FileTypeNode.class);
    private File file;
    private Map<Session, Map<Long, RandomAccessFile>> Jp = null;
    private final SessionListener Jq = new SessionListener(){

        @Override
        public void onSessionActivated(Session session) {
        }

        @Override
        public void onSessionChanged(Session session) {
        }

        @Override
        public void onSessionClosed(Session session) {
            FileTypeNode.this.closeHandles(session);
        }
    };
    private boolean writing;

    private static Long eGq() {
        return Jo.incrementAndGet();
    }

    protected FileTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        this.initNodeVersion();
        try {
            this.updateOpenCount();
            this.setCurrentWritable(false);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
        super.afterCreate();
    }

    public synchronized void close(Session session, Long l2) throws StatusException {
        Map<Long, RandomAccessFile> map = this.b(session, false);
        if (map == null || map.isEmpty()) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        RandomAccessFile randomAccessFile = map.remove(l2);
        if (randomAccessFile == null) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        if (map.isEmpty()) {
            this.Jp.remove(session);
            if (this.Jp.isEmpty()) {
                this.Jp = null;
            }
            session.removeSessionListener(this.Jq);
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writing = false;
        this.updateOpenCount();
        this.updateFileSize();
    }

    public synchronized void closeHandles(Session session) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Long object : this.Jp.get(session).keySet()) {
            hashSet.add(object);
        }
        boolean bl = true;
        for (Long l2 : hashSet) {
            try {
                this.close(session, l2);
                logger.debug("Session " + session.getSessionName() + ", FileHandle " + l2 + " closed");
            }
            catch (StatusException statusException) {
                logger.error("Failed to close Session " + session.getSessionName() + ", FileHandle " + l2, statusException);
                bl = false;
            }
        }
        if (bl) {
            logger.debug("All FileHandles of Session " + session.getSessionName() + " closed");
        }
    }

    public synchronized int getCurrentOpenCount() {
        int n2 = 0;
        if (this.Jp != null) {
            for (Map<Long, RandomAccessFile> map : this.Jp.values()) {
                n2 += map.size();
            }
        }
        return n2;
    }

    public synchronized long getCurrentPosition(Session session, Long l2) throws StatusException {
        RandomAccessFile randomAccessFile = this.getRandomAccessFile(session, l2);
        try {
            return randomAccessFile.getFilePointer();
        }
        catch (IOException iOException) {
            throw new StatusException(StatusCodes.Bad_UnexpectedError);
        }
    }

    public synchronized long getCurrentSize() throws StatusException {
        this.checkFileExists();
        return this.file.length();
    }

    public synchronized DateTime getCurrentTimestamp() throws StatusException {
        this.checkFileExists();
        return DateTime.fromMillis(this.file.lastModified());
    }

    public synchronized File getFile() {
        return this.file;
    }

    public DateTime getTimestamp() throws StatusException {
        return this.getSizeNode().getValue().getSourceTimestamp();
    }

    public synchronized boolean isCurrentWritable() {
        return Boolean.TRUE.equals(this.isWritable());
    }

    public synchronized boolean isWriting() {
        return this.writing;
    }

    public synchronized Long open(Session session, Set<FileTypeOpenMode> set) throws StatusException {
        String string;
        if (logger.isDebugEnabled()) {
            logger.debug("open: mode=" + Arrays.toString(set.toArray()));
        }
        boolean bl = set.contains((Object)FileTypeOpenMode.Write);
        if (this.isWriting() || bl && this.getCurrentOpenCount() > 0) {
            throw new StatusException(bl ? StatusCodes.Bad_NotWritable : StatusCodes.Bad_NotReadable, new DiagnosticInfo("File already open.", null, null, null, null, null, null));
        }
        if (bl && !this.isCurrentWritable()) {
            throw new StatusException(StatusCodes.Bad_NotWritable, new DiagnosticInfo("File not Writable", null, null, null, null, null, null));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("open: " + this.file.getPath() + " file.exists=" + this.file.exists());
        }
        String string2 = string = bl ? "rw" : "r";
        if (set.contains((Object)FileTypeOpenMode.EraseExisting) && this.file.exists()) {
            this.file.delete();
        }
        try {
            if (this.file.exists()) {
                logger.debug("open: file.canWrite=" + this.file.canWrite());
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, string);
            if (set.contains((Object)FileTypeOpenMode.Append)) {
                try {
                    randomAccessFile.seek(randomAccessFile.length());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Map<Long, RandomAccessFile> map = this.b(session, true);
            Long l2 = FileTypeNode.eGq();
            map.put(l2, randomAccessFile);
            this.writing = bl;
            this.updateOpenCount();
            return l2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new StatusException(StatusCodes.Bad_NotFound);
        }
    }

    public synchronized byte[] read(Session session, Long l2, int n2) throws StatusException {
        RandomAccessFile randomAccessFile = this.getRandomAccessFile(session, l2);
        try {
            if ((long)n2 > randomAccessFile.length() - randomAccessFile.getFilePointer()) {
                n2 = (int)(randomAccessFile.length() - randomAccessFile.getFilePointer());
            }
            byte[] byArray = new byte[n2];
            randomAccessFile.read(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            throw new StatusException(StatusCodes.Bad_UnexpectedError);
        }
    }

    public synchronized void setCurrentPosition(Session session, Long l2, long l3) throws StatusException {
        RandomAccessFile randomAccessFile = this.getRandomAccessFile(session, l2);
        try {
            randomAccessFile.seek(Math.min(randomAccessFile.length(), l3));
        }
        catch (IOException iOException) {
            throw new StatusException(StatusCodes.Bad_UnexpectedError);
        }
    }

    public synchronized void setCurrentWritable(boolean bl) throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("setWritable: " + bl);
        }
        if (bl && this.file.exists() && !this.file.setWritable(bl)) {
            throw new StatusException("Cannot set the file Writable, file=" + this.file, StatusCodes.Bad_NotWritable);
        }
        this.setWritable(bl);
    }

    public synchronized void setFile(File file) {
        this.file = file;
        this.updateFileSize();
        if (logger.isDebugEnabled()) {
            logger.debug("setFile: " + file.getPath() + " canWrite=" + file.canWrite());
        }
    }

    public void setSize(UnsignedLong unsignedLong, StatusCode statusCode, DateTime dateTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("setSize(" + unsignedLong + ", " + statusCode + ", " + dateTime);
        }
        try {
            this.getSizeNode().setValue(new DataValue(new Variant(unsignedLong), statusCode, dateTime, DateTime.currentTime()));
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    public void updateFileSize() {
        StatusCode statusCode;
        DateTime dateTime;
        if (logger.isDebugEnabled()) {
            logger.debug("updateFileSize");
        }
        UnsignedLong unsignedLong = null;
        try {
            unsignedLong = UnsignedLong.valueOf(this.getCurrentSize());
            dateTime = this.getCurrentTimestamp();
            statusCode = StatusCode.GOOD;
        }
        catch (StatusException statusException) {
            statusCode = statusException.getStatusCode();
            dateTime = DateTime.MIN_VALUE;
        }
        this.setSize(unsignedLong, statusCode, dateTime);
    }

    public synchronized void write(Session session, Long l2, byte[] byArray) throws StatusException {
        RandomAccessFile randomAccessFile = this.getRandomAccessFile(session, l2);
        try {
            randomAccessFile.write(byArray);
        }
        catch (IOException iOException) {
            throw new StatusException(StatusCodes.Bad_NotWritable, (Throwable)iOException);
        }
    }

    private synchronized Map<Long, RandomAccessFile> b(Session session, boolean bl) {
        Map<Long, RandomAccessFile> map;
        if (this.Jp == null) {
            if (bl) {
                this.Jp = new HashMap<Session, Map<Long, RandomAccessFile>>();
            } else {
                return null;
            }
        }
        if ((map = this.Jp.get(session)) == null) {
            map = new HashMap<Long, RandomAccessFile>();
            this.Jp.put(session, map);
            session.addSessionListener(this.Jq);
        }
        return map;
    }

    protected void checkFileExists() throws StatusException {
        if (this.file == null || !this.file.exists()) {
            throw new StatusException(StatusCodes.Bad_NotFound);
        }
    }

    protected RandomAccessFile getRandomAccessFile(Session session, Long l2) throws StatusException {
        RandomAccessFile randomAccessFile;
        Map<Long, RandomAccessFile> map = this.b(session, false);
        RandomAccessFile randomAccessFile2 = randomAccessFile = map == null ? null : map.get(l2);
        if (randomAccessFile == null) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        return randomAccessFile;
    }

    @Override
    protected void onClose(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        this.close(serviceContext.getSession(), unsignedInteger.longValue());
    }

    @Override
    protected UnsignedLong onGetPosition(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        return UnsignedLong.valueOf(this.getCurrentPosition(serviceContext.getSession(), unsignedInteger.longValue()));
    }

    @Override
    protected UnsignedInteger onOpen(ServiceContext serviceContext, UnsignedByte unsignedByte) throws StatusException {
        if (unsignedByte.byteValue() > 15) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("onOpen: " + this.getFile());
        }
        Session session = serviceContext.getSession();
        EnumSet<FileTypeOpenMode> enumSet = FileTypeOpenMode.getSet(unsignedByte);
        UnsignedInteger unsignedInteger = UnsignedInteger.valueOf(this.open(session, enumSet));
        if (logger.isDebugEnabled()) {
            logger.debug("onOpen: fileHandle=" + unsignedInteger);
        }
        return unsignedInteger;
    }

    @Override
    protected ByteString onRead(ServiceContext serviceContext, UnsignedInteger unsignedInteger, Integer n2) throws StatusException {
        return ByteString.valueOf(this.read(serviceContext.getSession(), unsignedInteger.longValue(), n2));
    }

    @Override
    protected void onSetPosition(ServiceContext serviceContext, UnsignedInteger unsignedInteger, UnsignedLong unsignedLong) throws StatusException {
        this.setCurrentPosition(serviceContext.getSession(), unsignedInteger.longValue(), unsignedLong.longValue());
    }

    @Override
    protected void onWrite(ServiceContext serviceContext, UnsignedInteger unsignedInteger, ByteString byteString) throws StatusException {
        this.write(serviceContext.getSession(), unsignedInteger.longValue(), ByteString.asByteArray(byteString));
    }

    protected void updateOpenCount() throws StatusException {
        this.setOpenCount(UnsignedShort.valueOf(this.getCurrentOpenCount()));
    }
}

