/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ExclusiveLimitAlarmType;
import com.prosysopc.ua.types.opcua.server.ExclusiveLimitAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.ExclusiveLimitStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.LimitAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=9341")
public abstract class ExclusiveLimitAlarmTypeNodeBase
extends LimitAlarmTypeNode
implements ExclusiveLimitAlarmType {
    private static GeneratedNodeInitializer<ExclusiveLimitAlarmTypeNode> IY;

    protected ExclusiveLimitAlarmTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getActiveStateNode());
        this.callAfterCreateIfExists(this.getLimitStateNode());
        GeneratedNodeInitializer<ExclusiveLimitAlarmTypeNode> generatedNodeInitializer = ExclusiveLimitAlarmTypeNodeBase.getExclusiveLimitAlarmTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ExclusiveLimitAlarmTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ExclusiveLimitAlarmTypeNode> getExclusiveLimitAlarmTypeNodeInitializer() {
        return IY;
    }

    public static void setExclusiveLimitAlarmTypeNodeInitializer(GeneratedNodeInitializer<ExclusiveLimitAlarmTypeNode> generatedNodeInitializer) {
        IY = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getActiveStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActiveState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getActiveState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getActiveStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ActiveState does not exist");
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setActiveState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getActiveStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting ActiveState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActiveState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ExclusiveLimitStateMachineTypeNode getLimitStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LimitState");
        return (ExclusiveLimitStateMachineTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

