/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.TimeZoneDataType;
import com.prosysopc.ua.types.opcua.BaseEventType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2041")
public abstract class BaseEventTypeNodeBase
extends BaseObjectTypeNode
implements BaseEventType {
    private static GeneratedNodeInitializer<BaseEventTypeNode> Hz;

    protected BaseEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<BaseEventTypeNode> generatedNodeInitializer = BaseEventTypeNodeBase.getBaseEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((BaseEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<BaseEventTypeNode> getBaseEventTypeNodeInitializer() {
        return Hz;
    }

    public static void setBaseEventTypeNodeInitializer(GeneratedNodeInitializer<BaseEventTypeNode> generatedNodeInitializer) {
        Hz = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getEventTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getEventType() {
        UaProperty uaProperty = this.getEventTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EventType does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setEventType(NodeId nodeId) {
        UaProperty uaProperty = this.getEventTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EventType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EventType failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getConditionClassNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getConditionClassName() {
        UaProperty uaProperty = this.getConditionClassNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setConditionClassName(LocalizedText localizedText) {
        UaProperty uaProperty = this.getConditionClassNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionClassName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getReceiveTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReceiveTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getReceiveTime() {
        UaProperty uaProperty = this.getReceiveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ReceiveTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setReceiveTime(DateTime dateTime) {
        UaProperty uaProperty = this.getReceiveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ReceiveTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ReceiveTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSourceNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSourceName() {
        UaProperty uaProperty = this.getSourceNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SourceName does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSourceName(String string) {
        UaProperty uaProperty = this.getSourceNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SourceName failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getLocalTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocalTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public TimeZoneDataType getLocalTime() {
        UaProperty uaProperty = this.getLocalTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (TimeZoneDataType)object;
    }

    @Override
    @Optional
    public void setLocalTime(TimeZoneDataType timeZoneDataType) {
        UaProperty uaProperty = this.getLocalTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LocalTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(timeZoneDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LocalTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getEventIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getEventId() {
        UaProperty uaProperty = this.getEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EventId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setEventId(ByteString byteString) {
        UaProperty uaProperty = this.getEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EventId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EventId failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getConditionClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public NodeId getConditionClassId() {
        UaProperty uaProperty = this.getConditionClassIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Optional
    public void setConditionClassId(NodeId nodeId) {
        UaProperty uaProperty = this.getConditionClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionClassId failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getConditionSubClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionSubClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public NodeId[] getConditionSubClassId() {
        UaProperty uaProperty = this.getConditionSubClassIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Optional
    public void setConditionSubClassId(NodeId[] nodeIdArray) {
        UaProperty uaProperty = this.getConditionSubClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionSubClassId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeIdArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionSubClassId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMessageNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Message");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getMessage() {
        UaProperty uaProperty = this.getMessageNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Message does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setMessage(LocalizedText localizedText) {
        UaProperty uaProperty = this.getMessageNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Message failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Message failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getConditionSubClassNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionSubClassName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText[] getConditionSubClassName() {
        UaProperty uaProperty = this.getConditionSubClassNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Optional
    public void setConditionSubClassName(LocalizedText[] localizedTextArray) {
        UaProperty uaProperty = this.getConditionSubClassNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionSubClassName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedTextArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionSubClassName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSeverityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Severity");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getSeverity() {
        UaProperty uaProperty = this.getSeverityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Severity does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setSeverity(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getSeverityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Severity failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Severity failed unexpectedly", statusException);
        }
    }

    public void setSeverity(int n2) {
        this.setSeverity(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Time");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getTime() {
        UaProperty uaProperty = this.getTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Time does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setTime(DateTime dateTime) {
        UaProperty uaProperty = this.getTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Time failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Time failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSourceNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSourceNode() {
        UaProperty uaProperty = this.getSourceNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SourceNode does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSourceNode(NodeId nodeId) {
        UaProperty uaProperty = this.getSourceNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SourceNode failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

