/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditEventType;
import com.prosysopc.ua.types.opcua.server.AuditEventTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2052")
public abstract class AuditEventTypeNodeBase
extends BaseEventTypeNode
implements AuditEventType {
    private static GeneratedNodeInitializer<AuditEventTypeNode> GX;

    protected AuditEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditEventTypeNode> generatedNodeInitializer = AuditEventTypeNodeBase.getAuditEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditEventTypeNode> getAuditEventTypeNodeInitializer() {
        return GX;
    }

    public static void setAuditEventTypeNodeInitializer(GeneratedNodeInitializer<AuditEventTypeNode> generatedNodeInitializer) {
        GX = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getClientAuditEntryIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientAuditEntryId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientAuditEntryId() {
        UaProperty uaProperty = this.getClientAuditEntryIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ClientAuditEntryId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientAuditEntryId(String string) {
        UaProperty uaProperty = this.getClientAuditEntryIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientAuditEntryId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientAuditEntryId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isStatus() {
        UaProperty uaProperty = this.getStatusNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Status does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setStatus(Boolean bl) {
        UaProperty uaProperty = this.getStatusNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Status failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Status failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getServerIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getServerId() {
        UaProperty uaProperty = this.getServerIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServerId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setServerId(String string) {
        UaProperty uaProperty = this.getServerIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClientUserIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientUserId() {
        UaProperty uaProperty = this.getClientUserIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ClientUserId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientUserId(String string) {
        UaProperty uaProperty = this.getClientUserIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientUserId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientUserId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getActionTimeStampNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActionTimeStamp");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getActionTimeStamp() {
        UaProperty uaProperty = this.getActionTimeStampNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ActionTimeStamp does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setActionTimeStamp(DateTime dateTime) {
        UaProperty uaProperty = this.getActionTimeStampNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ActionTimeStamp failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActionTimeStamp failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

