/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditCreateSessionEventType;
import com.prosysopc.ua.types.opcua.server.AuditCreateSessionEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditSessionEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2071")
public abstract class AuditCreateSessionEventTypeNodeBase
extends AuditSessionEventTypeNode
implements AuditCreateSessionEventType {
    private static GeneratedNodeInitializer<AuditCreateSessionEventTypeNode> GU;

    protected AuditCreateSessionEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditCreateSessionEventTypeNode> generatedNodeInitializer = AuditCreateSessionEventTypeNodeBase.getAuditCreateSessionEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditCreateSessionEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditCreateSessionEventTypeNode> getAuditCreateSessionEventTypeNodeInitializer() {
        return GU;
    }

    public static void setAuditCreateSessionEventTypeNodeInitializer(GeneratedNodeInitializer<AuditCreateSessionEventTypeNode> generatedNodeInitializer) {
        GU = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getRevisedSessionTimeoutNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RevisedSessionTimeout");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getRevisedSessionTimeout() {
        UaProperty uaProperty = this.getRevisedSessionTimeoutNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RevisedSessionTimeout does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setRevisedSessionTimeout(Double d2) {
        UaProperty uaProperty = this.getRevisedSessionTimeoutNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RevisedSessionTimeout failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RevisedSessionTimeout failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClientCertificateThumbprintNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificateThumbprint");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientCertificateThumbprint() {
        UaProperty uaProperty = this.getClientCertificateThumbprintNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ClientCertificateThumbprint does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientCertificateThumbprint(String string) {
        UaProperty uaProperty = this.getClientCertificateThumbprintNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientCertificateThumbprint failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientCertificateThumbprint failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClientCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getClientCertificate() {
        UaProperty uaProperty = this.getClientCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ClientCertificate does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setClientCertificate(ByteString byteString) {
        UaProperty uaProperty = this.getClientCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientCertificate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientCertificate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSecureChannelIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecureChannelId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecureChannelId() {
        UaProperty uaProperty = this.getSecureChannelIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SecureChannelId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecureChannelId(String string) {
        UaProperty uaProperty = this.getSecureChannelIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecureChannelId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecureChannelId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

