/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditClientEventType;
import com.prosysopc.ua.types.opcua.server.AuditClientEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=23606")
public abstract class AuditClientEventTypeNodeBase
extends AuditEventTypeNode
implements AuditClientEventType {
    private static GeneratedNodeInitializer<AuditClientEventTypeNode> GH;

    protected AuditClientEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditClientEventTypeNode> generatedNodeInitializer = AuditClientEventTypeNodeBase.getAuditClientEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditClientEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditClientEventTypeNode> getAuditClientEventTypeNodeInitializer() {
        return GH;
    }

    public static void setAuditClientEventTypeNodeInitializer(GeneratedNodeInitializer<AuditClientEventTypeNode> generatedNodeInitializer) {
        GH = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getServerUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getServerUri() {
        UaProperty uaProperty = this.getServerUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServerUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setServerUri(String string) {
        UaProperty uaProperty = this.getServerUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerUri failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

