/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AliasNameDataType;
import com.prosysopc.ua.types.opcua.AliasNameCategoryType;
import com.prosysopc.ua.types.opcua.server.AliasNameCategoryTypeFindAliasMethod;
import com.prosysopc.ua.types.opcua.server.AliasNameCategoryTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=23456")
public abstract class AliasNameCategoryTypeNodeBase
extends FolderTypeNode
implements AliasNameCategoryType {
    private static GeneratedNodeInitializer<AliasNameCategoryTypeNode> Gj;
    private static AliasNameCategoryTypeFindAliasMethod Gk;

    protected AliasNameCategoryTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AliasNameCategoryTypeNode> generatedNodeInitializer = AliasNameCategoryTypeNodeBase.getAliasNameCategoryTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AliasNameCategoryTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AliasNameCategoryTypeNode> getAliasNameCategoryTypeNodeInitializer() {
        return Gj;
    }

    public static void setAliasNameCategoryTypeNodeInitializer(GeneratedNodeInitializer<AliasNameCategoryTypeNode> generatedNodeInitializer) {
        Gj = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getLastChangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastChange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getLastChange() {
        UaProperty uaProperty = this.getLastChangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setLastChange(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getLastChangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastChange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastChange failed unexpectedly", statusException);
        }
    }

    public void setLastChange(long l2) {
        this.setLastChange(UnsignedInteger.valueOf(l2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "FindAlias"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (String)variantArray[0].getValue(), (NodeId)variantArray[1].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getFindAliasNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FindAlias");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract AliasNameDataType[] onFindAlias(ServiceContext var1, String var2, NodeId var3) throws StatusException;

    @Override
    public AliasNameDataType[] findAlias(String string, NodeId nodeId) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, nodeId);
    }

    private AliasNameDataType[] a(ServiceContext serviceContext, String string, NodeId nodeId) throws StatusException {
        AliasNameCategoryTypeFindAliasMethod aliasNameCategoryTypeFindAliasMethod = AliasNameCategoryTypeNodeBase.getFindAliasMethodImplementation();
        if (aliasNameCategoryTypeFindAliasMethod != null) {
            return aliasNameCategoryTypeFindAliasMethod.findAlias(serviceContext, (AliasNameCategoryTypeNode)this, string, nodeId);
        }
        return this.onFindAlias(serviceContext, string, nodeId);
    }

    public static AliasNameCategoryTypeFindAliasMethod getFindAliasMethodImplementation() {
        return Gk;
    }

    public static void setFindAliasMethodImplementation(AliasNameCategoryTypeFindAliasMethod aliasNameCategoryTypeFindAliasMethod) {
        Gk = aliasNameCategoryTypeFindAliasMethod;
    }
}

