/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.types.opcua.AlarmStateVariableType;
import com.prosysopc.ua.types.opcua.server.AlarmStateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32244")
public abstract class AlarmStateVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements AlarmStateVariableType {
    private static GeneratedNodeInitializer<AlarmStateVariableTypeNode> Gh;

    protected AlarmStateVariableTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AlarmStateVariableTypeNode> generatedNodeInitializer = AlarmStateVariableTypeNodeBase.getAlarmStateVariableTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AlarmStateVariableTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AlarmStateVariableTypeNode> getAlarmStateVariableTypeNodeInitializer() {
        return Gh;
    }

    public static void setAlarmStateVariableTypeNodeInitializer(GeneratedNodeInitializer<AlarmStateVariableTypeNode> generatedNodeInitializer) {
        Gh = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getUnconfirmedCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnconfirmedCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getUnconfirmedCount() {
        UaProperty uaProperty = this.getUnconfirmedCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UnconfirmedCount does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setUnconfirmedCount(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getUnconfirmedCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UnconfirmedCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnconfirmedCount failed unexpectedly", statusException);
        }
    }

    public void setUnconfirmedCount(long l2) {
        this.setUnconfirmedCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getActiveCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActiveCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getActiveCount() {
        UaProperty uaProperty = this.getActiveCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ActiveCount does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setActiveCount(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getActiveCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ActiveCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActiveCount failed unexpectedly", statusException);
        }
    }

    public void setActiveCount(long l2) {
        this.setActiveCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getFilterNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Filter");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ContentFilter getFilter() {
        UaProperty uaProperty = this.getFilterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Filter does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ContentFilter)object;
    }

    @Override
    @Mandatory
    public void setFilter(ContentFilter contentFilter) {
        UaProperty uaProperty = this.getFilterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Filter failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(contentFilter);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Filter failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getUnacknowledgedCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnacknowledgedCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getUnacknowledgedCount() {
        UaProperty uaProperty = this.getUnacknowledgedCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UnacknowledgedCount does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setUnacknowledgedCount(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getUnacknowledgedCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UnacknowledgedCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnacknowledgedCount failed unexpectedly", statusException);
        }
    }

    public void setUnacknowledgedCount(long l2) {
        this.setUnacknowledgedCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getHighestUnackSeverityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighestUnackSeverity");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getHighestUnackSeverity() {
        UaProperty uaProperty = this.getHighestUnackSeverityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node HighestUnackSeverity does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setHighestUnackSeverity(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getHighestUnackSeverityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HighestUnackSeverity failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighestUnackSeverity failed unexpectedly", statusException);
        }
    }

    public void setHighestUnackSeverity(int n2) {
        this.setHighestUnackSeverity(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getHighestActiveSeverityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighestActiveSeverity");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getHighestActiveSeverity() {
        UaProperty uaProperty = this.getHighestActiveSeverityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node HighestActiveSeverity does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setHighestActiveSeverity(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getHighestActiveSeverityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HighestActiveSeverity failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HighestActiveSeverity failed unexpectedly", statusException);
        }
    }

    public void setHighestActiveSeverity(int n2) {
        this.setHighestActiveSeverity(UnsignedShort.valueOf(n2));
    }
}

