/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.TransitionVariableType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2762")
public abstract class TransitionVariableTypeImplBase
extends BaseDataVariableTypeImpl
implements TransitionVariableType {
    protected TransitionVariableTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Number");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getNumber() {
        UaProperty uaProperty = this.getNumberNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setNumber(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Number failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getEffectiveTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EffectiveTransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getEffectiveTransitionTime() {
        UaProperty uaProperty = this.getEffectiveTransitionTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setEffectiveTransitionTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getEffectiveTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EffectiveTransitionTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Optional
    public UaProperty getTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getTransitionTime() {
        UaProperty uaProperty = this.getTransitionTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setTransitionTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransitionTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getId() {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setId(Object object) throws StatusException {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Id failed, the Optional node does not exist)");
        }
        uaProperty.setValue(object);
    }

    @Override
    @Optional
    public UaProperty getNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Name");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public QualifiedName getName() {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (QualifiedName)object;
    }

    @Override
    @Optional
    public void setName(QualifiedName qualifiedName) throws StatusException {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Name failed, the Optional node does not exist)");
        }
        uaProperty.setValue(qualifiedName);
    }
}

