/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.SessionSecurityDiagnosticsType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2244")
public abstract class SessionSecurityDiagnosticsTypeImplBase
extends BaseDataVariableTypeImpl
implements SessionSecurityDiagnosticsType {
    protected SessionSecurityDiagnosticsTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getClientUserIdOfSessionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserIdOfSession");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientUserIdOfSession() {
        BaseDataVariableType baseDataVariableType = this.getClientUserIdOfSessionNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientUserIdOfSession(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getClientUserIdOfSessionNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ClientUserIdOfSession failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getTransportProtocolNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportProtocol");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getTransportProtocol() {
        BaseDataVariableType baseDataVariableType = this.getTransportProtocolNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setTransportProtocol(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getTransportProtocolNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting TransportProtocol failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getEncodingNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Encoding");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getEncoding() {
        BaseDataVariableType baseDataVariableType = this.getEncodingNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setEncoding(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getEncodingNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting Encoding failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public MessageSecurityMode getSecurityMode() {
        BaseDataVariableType baseDataVariableType = this.getSecurityModeNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Variant variant = baseDataVariableType.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Mandatory
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSecurityModeNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SecurityMode failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(messageSecurityMode);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        BaseDataVariableType baseDataVariableType = this.getSessionIdNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSessionIdNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SessionId failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(nodeId);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getClientUserIdHistoryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserIdHistory");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getClientUserIdHistory() {
        BaseDataVariableType baseDataVariableType = this.getClientUserIdHistoryNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setClientUserIdHistory(String[] stringArray) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getClientUserIdHistoryNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ClientUserIdHistory failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(stringArray);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getClientCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificate");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getClientCertificate() {
        BaseDataVariableType baseDataVariableType = this.getClientCertificateNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setClientCertificate(ByteString byteString) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getClientCertificateNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ClientCertificate failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(byteString);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getAuthenticationMechanismNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AuthenticationMechanism");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getAuthenticationMechanism() {
        BaseDataVariableType baseDataVariableType = this.getAuthenticationMechanismNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setAuthenticationMechanism(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getAuthenticationMechanismNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting AuthenticationMechanism failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityPolicyUri() {
        BaseDataVariableType baseDataVariableType = this.getSecurityPolicyUriNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityPolicyUri(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSecurityPolicyUriNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }
}

