/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.BuildInfo;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.BuildInfoType;
import com.prosysopc.ua.types.opcua.ServerStatusType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2138")
public abstract class ServerStatusTypeImplBase
extends BaseDataVariableTypeImpl
implements ServerStatusType {
    protected ServerStatusTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "State");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerState getState() {
        BaseDataVariableType baseDataVariableType = this.getStateNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Variant variant = baseDataVariableType.getValue().getValue();
        return (ServerState)variant.asEnum(ServerState.class);
    }

    @Override
    @Mandatory
    public void setState(ServerState serverState) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getStateNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting State failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(serverState);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getSecondsTillShutdownNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecondsTillShutdown");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSecondsTillShutdown() {
        BaseDataVariableType baseDataVariableType = this.getSecondsTillShutdownNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSecondsTillShutdown(UnsignedInteger unsignedInteger) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSecondsTillShutdownNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SecondsTillShutdown failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public BuildInfoType getBuildInfoNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildInfo");
        return (BuildInfoType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public BuildInfo getBuildInfo() {
        BuildInfoType buildInfoType = this.getBuildInfoNode();
        if (buildInfoType == null) {
            return null;
        }
        Object object = buildInfoType.getValue().getValue().getValue();
        return (BuildInfo)object;
    }

    @Override
    @Mandatory
    public void setBuildInfo(BuildInfo buildInfo) throws StatusException {
        BuildInfoType buildInfoType = this.getBuildInfoNode();
        if (buildInfoType == null) {
            throw new RuntimeException("Setting BuildInfo failed, the Optional node does not exist)");
        }
        buildInfoType.setValue(buildInfo);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getShutdownReasonNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ShutdownReason");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getShutdownReason() {
        BaseDataVariableType baseDataVariableType = this.getShutdownReasonNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setShutdownReason(LocalizedText localizedText) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getShutdownReasonNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ShutdownReason failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getStartTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartTime");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getStartTime() {
        BaseDataVariableType baseDataVariableType = this.getStartTimeNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setStartTime(DateTime dateTime) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getStartTimeNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting StartTime failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(dateTime);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getCurrentTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentTime");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getCurrentTime() {
        BaseDataVariableType baseDataVariableType = this.getCurrentTimeNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setCurrentTime(DateTime dateTime) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getCurrentTimeNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting CurrentTime failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(dateTime);
    }
}

