/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ChassisIdSubtype;
import com.prosysopc.ua.stack.core.LldpManagementAddressType;
import com.prosysopc.ua.stack.core.LldpSystemCapabilitiesMap;
import com.prosysopc.ua.stack.core.LldpTlvType;
import com.prosysopc.ua.stack.core.PortIdSubtype;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.LldpRemoteSystemType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19033")
public abstract class LldpRemoteSystemTypeImplBase
extends BaseObjectTypeImpl
implements LldpRemoteSystemType {
    protected LldpRemoteSystemTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getRemoteIndexNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteIndex");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRemoteIndex() {
        BaseDataVariableType baseDataVariableType = this.getRemoteIndexNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRemoteIndex(UnsignedInteger unsignedInteger) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getRemoteIndexNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting RemoteIndex failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public BaseDataVariableType getRemoteTooManyNeighborsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteTooManyNeighbors");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isRemoteTooManyNeighbors() {
        BaseDataVariableType baseDataVariableType = this.getRemoteTooManyNeighborsNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setRemoteTooManyNeighbors(Boolean bl) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getRemoteTooManyNeighborsNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting RemoteTooManyNeighbors failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(bl);
    }

    @Override
    @Optional
    public BaseDataVariableType getSystemCapabilitiesEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemCapabilitiesEnabled");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LldpSystemCapabilitiesMap getSystemCapabilitiesEnabled() {
        BaseDataVariableType baseDataVariableType = this.getSystemCapabilitiesEnabledNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (LldpSystemCapabilitiesMap)object;
    }

    @Override
    @Optional
    public void setSystemCapabilitiesEnabled(LldpSystemCapabilitiesMap lldpSystemCapabilitiesMap) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSystemCapabilitiesEnabledNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SystemCapabilitiesEnabled failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(lldpSystemCapabilitiesMap);
    }

    @Override
    @Optional
    public BaseDataVariableType getSystemDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemDescription");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public String getSystemDescription() {
        BaseDataVariableType baseDataVariableType = this.getSystemDescriptionNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSystemDescription(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSystemDescriptionNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SystemDescription failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Optional
    public BaseDataVariableType getRemoteUnknownTlvNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteUnknownTlv");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LldpTlvType[] getRemoteUnknownTlv() {
        BaseDataVariableType baseDataVariableType = this.getRemoteUnknownTlvNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (LldpTlvType[])object;
    }

    @Override
    @Optional
    public void setRemoteUnknownTlv(LldpTlvType[] lldpTlvTypeArray) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getRemoteUnknownTlvNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting RemoteUnknownTlv failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(lldpTlvTypeArray);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getPortIdSubtypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortIdSubtype");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public PortIdSubtype getPortIdSubtype() {
        BaseDataVariableType baseDataVariableType = this.getPortIdSubtypeNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Variant variant = baseDataVariableType.getValue().getValue();
        return (PortIdSubtype)variant.asEnum(PortIdSubtype.class);
    }

    @Override
    @Mandatory
    public void setPortIdSubtype(PortIdSubtype portIdSubtype) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getPortIdSubtypeNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting PortIdSubtype failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(portIdSubtype);
    }

    @Override
    @Optional
    public BaseDataVariableType getPortDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortDescription");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public String getPortDescription() {
        BaseDataVariableType baseDataVariableType = this.getPortDescriptionNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setPortDescription(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getPortDescriptionNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting PortDescription failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Optional
    public BaseDataVariableType getManagementAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ManagementAddress");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LldpManagementAddressType[] getManagementAddress() {
        BaseDataVariableType baseDataVariableType = this.getManagementAddressNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (LldpManagementAddressType[])object;
    }

    @Override
    @Optional
    public void setManagementAddress(LldpManagementAddressType[] lldpManagementAddressTypeArray) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getManagementAddressNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ManagementAddress failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(lldpManagementAddressTypeArray);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getChassisIdSubtypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ChassisIdSubtype");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ChassisIdSubtype getChassisIdSubtype() {
        BaseDataVariableType baseDataVariableType = this.getChassisIdSubtypeNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Variant variant = baseDataVariableType.getValue().getValue();
        return (ChassisIdSubtype)variant.asEnum(ChassisIdSubtype.class);
    }

    @Override
    @Mandatory
    public void setChassisIdSubtype(ChassisIdSubtype chassisIdSubtype) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getChassisIdSubtypeNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ChassisIdSubtype failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(chassisIdSubtype);
    }

    @Override
    @Optional
    public BaseDataVariableType getRemoteChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteChanges");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isRemoteChanges() {
        BaseDataVariableType baseDataVariableType = this.getRemoteChangesNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setRemoteChanges(Boolean bl) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getRemoteChangesNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting RemoteChanges failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(bl);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getTimeMarkNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TimeMark");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTimeMark() {
        BaseDataVariableType baseDataVariableType = this.getTimeMarkNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTimeMark(UnsignedInteger unsignedInteger) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getTimeMarkNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting TimeMark failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getPortIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortId");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getPortId() {
        BaseDataVariableType baseDataVariableType = this.getPortIdNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setPortId(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getPortIdNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting PortId failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Optional
    public BaseDataVariableType getSystemCapabilitiesSupportedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemCapabilitiesSupported");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LldpSystemCapabilitiesMap getSystemCapabilitiesSupported() {
        BaseDataVariableType baseDataVariableType = this.getSystemCapabilitiesSupportedNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (LldpSystemCapabilitiesMap)object;
    }

    @Override
    @Optional
    public void setSystemCapabilitiesSupported(LldpSystemCapabilitiesMap lldpSystemCapabilitiesMap) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSystemCapabilitiesSupportedNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SystemCapabilitiesSupported failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(lldpSystemCapabilitiesMap);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getChassisIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ChassisId");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getChassisId() {
        BaseDataVariableType baseDataVariableType = this.getChassisIdNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setChassisId(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getChassisIdNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ChassisId failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Optional
    public BaseDataVariableType getSystemNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemName");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public String getSystemName() {
        BaseDataVariableType baseDataVariableType = this.getSystemNameNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSystemName(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSystemNameNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SystemName failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }
}

