/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.LldpManagementAddressTxPortType;
import com.prosysopc.ua.stack.core.PortIdSubtype;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.LldpPortInformationType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19009")
public abstract class LldpPortInformationTypeImplBase
extends BaseObjectTypeImpl
implements LldpPortInformationType {
    protected LldpPortInformationTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getIetfBaseNetworkInterfaceNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IetfBaseNetworkInterfaceName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getIetfBaseNetworkInterfaceName() {
        UaProperty uaProperty = this.getIetfBaseNetworkInterfaceNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setIetfBaseNetworkInterfaceName(String string) throws StatusException {
        UaProperty uaProperty = this.getIetfBaseNetworkInterfaceNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IetfBaseNetworkInterfaceName failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getManagementAddressTxPortNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ManagementAddressTxPort");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LldpManagementAddressTxPortType[] getManagementAddressTxPort() {
        UaProperty uaProperty = this.getManagementAddressTxPortNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LldpManagementAddressTxPortType[])object;
    }

    @Override
    @Optional
    public void setManagementAddressTxPort(LldpManagementAddressTxPortType[] lldpManagementAddressTxPortTypeArray) throws StatusException {
        UaProperty uaProperty = this.getManagementAddressTxPortNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ManagementAddressTxPort failed, the Optional node does not exist)");
        }
        uaProperty.setValue(lldpManagementAddressTxPortTypeArray);
    }

    @Override
    @Mandatory
    public UaProperty getPortIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getPortId() {
        UaProperty uaProperty = this.getPortIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setPortId(String string) throws StatusException {
        UaProperty uaProperty = this.getPortIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PortId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getPortDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortDescription");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getPortDescription() {
        UaProperty uaProperty = this.getPortDescriptionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setPortDescription(String string) throws StatusException {
        UaProperty uaProperty = this.getPortDescriptionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PortDescription failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getDestMacAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DestMacAddress");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte[] getDestMacAddress() {
        UaProperty uaProperty = this.getDestMacAddressNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedByte[])object;
    }

    @Override
    @Mandatory
    public void setDestMacAddress(UnsignedByte[] unsignedByteArray) throws StatusException {
        UaProperty uaProperty = this.getDestMacAddressNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DestMacAddress failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedByteArray);
    }

    @Override
    @Mandatory
    public UaProperty getPortIdSubtypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortIdSubtype");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PortIdSubtype getPortIdSubtype() {
        UaProperty uaProperty = this.getPortIdSubtypeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (PortIdSubtype)variant.asEnum(PortIdSubtype.class);
    }

    @Override
    @Mandatory
    public void setPortIdSubtype(PortIdSubtype portIdSubtype) throws StatusException {
        UaProperty uaProperty = this.getPortIdSubtypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PortIdSubtype failed, the Optional node does not exist)");
        }
        uaProperty.setValue(portIdSubtype);
    }

    @Override
    @Optional
    public FolderType getRemoteSystemsDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteSystemsData");
        return (FolderType)this.getComponent(qualifiedName);
    }
}

