/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ChassisIdSubtype;
import com.prosysopc.ua.stack.core.LldpSystemCapabilitiesMap;
import com.prosysopc.ua.types.opcua.LldpLocalSystemType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19002")
public abstract class LldpLocalSystemTypeImplBase
extends BaseObjectTypeImpl
implements LldpLocalSystemType {
    protected LldpLocalSystemTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getChassisIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ChassisId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getChassisId() {
        UaProperty uaProperty = this.getChassisIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setChassisId(String string) throws StatusException {
        UaProperty uaProperty = this.getChassisIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ChassisId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getChassisIdSubtypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ChassisIdSubtype");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ChassisIdSubtype getChassisIdSubtype() {
        UaProperty uaProperty = this.getChassisIdSubtypeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ChassisIdSubtype)variant.asEnum(ChassisIdSubtype.class);
    }

    @Override
    @Mandatory
    public void setChassisIdSubtype(ChassisIdSubtype chassisIdSubtype) throws StatusException {
        UaProperty uaProperty = this.getChassisIdSubtypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ChassisIdSubtype failed, the Optional node does not exist)");
        }
        uaProperty.setValue(chassisIdSubtype);
    }

    @Override
    @Mandatory
    public UaProperty getSystemDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemDescription");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSystemDescription() {
        UaProperty uaProperty = this.getSystemDescriptionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSystemDescription(String string) throws StatusException {
        UaProperty uaProperty = this.getSystemDescriptionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemDescription failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getSystemNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSystemName() {
        UaProperty uaProperty = this.getSystemNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSystemName(String string) throws StatusException {
        UaProperty uaProperty = this.getSystemNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemName failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getSystemCapabilitiesEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemCapabilitiesEnabled");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LldpSystemCapabilitiesMap getSystemCapabilitiesEnabled() {
        UaProperty uaProperty = this.getSystemCapabilitiesEnabledNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LldpSystemCapabilitiesMap)object;
    }

    @Override
    @Optional
    public void setSystemCapabilitiesEnabled(LldpSystemCapabilitiesMap lldpSystemCapabilitiesMap) throws StatusException {
        UaProperty uaProperty = this.getSystemCapabilitiesEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemCapabilitiesEnabled failed, the Optional node does not exist)");
        }
        uaProperty.setValue(lldpSystemCapabilitiesMap);
    }

    @Override
    @Optional
    public UaProperty getSystemCapabilitiesSupportedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemCapabilitiesSupported");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LldpSystemCapabilitiesMap getSystemCapabilitiesSupported() {
        UaProperty uaProperty = this.getSystemCapabilitiesSupportedNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LldpSystemCapabilitiesMap)object;
    }

    @Override
    @Optional
    public void setSystemCapabilitiesSupported(LldpSystemCapabilitiesMap lldpSystemCapabilitiesMap) throws StatusException {
        UaProperty uaProperty = this.getSystemCapabilitiesSupportedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemCapabilitiesSupported failed, the Optional node does not exist)");
        }
        uaProperty.setValue(lldpSystemCapabilitiesMap);
    }
}

