/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.FileTypeOpenMode;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.nodes.UaPropertyImpl;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.client.FileTypeImplBase;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11575")
public class FileTypeImpl
extends FileTypeImplBase {
    private static Logger logger = LoggerFactory.getLogger(FileTypeImpl.class);

    protected FileTypeImpl(UaNode.Parameters parameters) {
        super(parameters);
    }

    public DateTime getTimestamp() throws StatusException {
        DataValue dataValue = this.readSizeValue();
        return dataValue.getSourceTimestamp();
    }

    public UnsignedInteger open(EnumSet<FileTypeOpenMode> enumSet) throws MethodCallStatusException, ServiceException {
        return this.open(FileTypeOpenMode.getValue(enumSet));
    }

    public UnsignedInteger open(FileTypeOpenMode ... fileTypeOpenModeArray) throws MethodCallStatusException, ServiceException {
        return this.open(FileTypeOpenMode.getValue(fileTypeOpenModeArray));
    }

    public UnsignedShort readOpenCount() throws StatusException {
        DataValue dataValue;
        try {
            dataValue = ((UaPropertyImpl)this.getOpenCountNode()).readValue();
        }
        catch (ServiceException serviceException) {
            logger.debug("getOpenCount: Failed to readValue: " + serviceException);
            dataValue = this.getOpenCountNode().getValue();
        }
        if (dataValue.getStatusCode().isBad()) {
            throw new StatusException(dataValue.getStatusCode());
        }
        return dataValue.isNull() ? null : (UnsignedShort)dataValue.getValue().getValue();
    }

    public UnsignedLong readSize() throws StatusException {
        DataValue dataValue = this.readSizeValue();
        return (UnsignedLong)dataValue.getValue().getValue();
    }

    public DataValue readSizeValue() throws StatusException {
        DataValue dataValue;
        try {
            dataValue = ((UaPropertyImpl)this.getSizeNode()).readValue();
        }
        catch (ServiceException serviceException) {
            if (logger.isDebugEnabled()) {
                logger.debug("getSize: Failed to readValue: " + serviceException);
            }
            dataValue = this.getSizeNode().getValue();
        }
        catch (NullPointerException nullPointerException) {
            logger.info("Could not read Size: no such property");
            throw new StatusException(StatusCodes.Bad_NodeIdUnknown);
        }
        catch (ClassCastException classCastException) {
            logger.info("Could not read Size: not a property node");
            throw new StatusException(StatusCodes.Bad_NodeIdUnknown);
        }
        if (dataValue.getStatusCode().isBad()) {
            throw new StatusException(dataValue.getStatusCode());
        }
        return dataValue;
    }

    public Boolean readWritable() throws StatusException {
        DataValue dataValue;
        try {
            dataValue = ((UaPropertyImpl)this.getWritableNode()).readValue();
        }
        catch (ServiceException serviceException) {
            logger.debug("isWritable: Failed to readValue: " + serviceException);
            dataValue = this.getWritableNode().getValue();
        }
        if (dataValue.getStatusCode().isBad()) {
            throw new StatusException(dataValue.getStatusCode());
        }
        return dataValue.isNull() ? null : (Boolean)dataValue.getValue().getValue();
    }
}

