/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.ExclusiveDeviationAlarmType;
import com.prosysopc.ua.types.opcua.client.ExclusiveLimitAlarmTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=9764")
public abstract class ExclusiveDeviationAlarmTypeImplBase
extends ExclusiveLimitAlarmTypeImpl
implements ExclusiveDeviationAlarmType {
    protected ExclusiveDeviationAlarmTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getBaseSetpointNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BaseSetpointNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public NodeId getBaseSetpointNode() {
        UaProperty uaProperty = this.getBaseSetpointNodeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Optional
    public void setBaseSetpointNode(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getBaseSetpointNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BaseSetpointNode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Mandatory
    public UaProperty getSetpointNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetpointNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSetpointNode() {
        UaProperty uaProperty = this.getSetpointNodeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSetpointNode(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getSetpointNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SetpointNode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }
}

