/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.ReceiveQosDataType;
import com.prosysopc.ua.types.opcua.DatagramDataSetReaderTransportType;
import com.prosysopc.ua.types.opcua.NetworkAddressType;
import com.prosysopc.ua.types.opcua.client.DataSetReaderTransportTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24016")
public abstract class DatagramDataSetReaderTransportTypeImplBase
extends DataSetReaderTransportTypeImpl
implements DatagramDataSetReaderTransportType {
    protected DatagramDataSetReaderTransportTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getTopicNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Topic");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getTopic() {
        UaProperty uaProperty = this.getTopicNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setTopic(String string) throws StatusException {
        UaProperty uaProperty = this.getTopicNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Topic failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getQosCategoryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QosCategory");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getQosCategory() {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setQosCategory(String string) throws StatusException {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting QosCategory failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getDatagramQosNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DatagramQos");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ReceiveQosDataType[] getDatagramQos() {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ReceiveQosDataType[])object;
    }

    @Override
    @Optional
    public void setDatagramQos(ReceiveQosDataType[] receiveQosDataTypeArray) throws StatusException {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DatagramQos failed, the Optional node does not exist)");
        }
        uaProperty.setValue(receiveQosDataTypeArray);
    }

    @Override
    @Optional
    public NetworkAddressType getAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Address");
        return (NetworkAddressType)this.getComponent(qualifiedName);
    }
}

