/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.types.opcua.AlarmRateVariableType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17277")
public abstract class AlarmRateVariableTypeImplBase
extends BaseDataVariableTypeImpl
implements AlarmRateVariableType {
    protected AlarmRateVariableTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Rate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getRate() {
        UaProperty uaProperty = this.getRateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setRate(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Rate failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }
}

