/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.UaDataTypeIds;
import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.EnumDefinition;
import com.prosysopc.ua.stack.core.EnumField;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumerationSpecification
implements UaDataTypeSpecification {
    private static final Logger logger = LoggerFactory.getLogger(EnumerationSpecification.class);
    private final UaNodeId typeId;
    private final String name;
    private final Map<Integer, String> Dd;
    private final Class<? extends Enumeration> javaClass;
    private final Map<String, Integer> De;
    private final Map<Integer, Enumeration> Df;
    private final Map<String, Enumeration> Dg;
    private final SortedSet<Enumeration> Dh;
    private final EnumerationBuilderSupplier Di;

    public static Builder builder() {
        return new Builder();
    }

    private EnumerationSpecification(UaNodeId uaNodeId, String string, Class<? extends Enumeration> clazz, Map<Integer, String> map, Map<String, Integer> map2, EnumerationBuilderSupplier enumerationBuilderSupplier) {
        this.typeId = uaNodeId;
        this.name = string;
        this.javaClass = clazz == null ? DynamicEnumeration.class : clazz;
        this.Dd = new HashMap<Integer, String>(map);
        this.De = new HashMap<String, Integer>(map2);
        this.Di = enumerationBuilderSupplier;
        this.Df = new HashMap<Integer, Enumeration>();
        this.Dg = new HashMap<String, Enumeration>();
        this.Dh = new TreeSet<Enumeration>(new Comparator<Enumeration>(){

            public int a(Enumeration enumeration, Enumeration enumeration2) {
                int n2;
                int n3 = enumeration == null ? 0 : enumeration.getValue();
                int n4 = n2 = enumeration2 == null ? 0 : enumeration2.getValue();
                return n3 < n2 ? -1 : (n3 == n2 ? 0 : 1);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Enumeration)object, (Enumeration)object2);
            }
        });
        this.eDk();
    }

    @Deprecated
    public DynamicEnumeration createEnumerationFromInteger(int n2) {
        return DynamicEnumeration.builder(this).setValue(n2).build();
    }

    @Deprecated
    public DynamicEnumeration createEnumerationFromString(String string) {
        Integer n2 = this.De.get(string);
        if (n2 == null) {
            throw new IllegalArgumentException("This enumeration does not have value: " + string);
        }
        return DynamicEnumeration.builder(this).setValue(n2).build();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnumerationSpecification enumerationSpecification = (EnumerationSpecification)object;
        return !(this.typeId == null ? enumerationSpecification.typeId != null : !this.typeId.equals(enumerationSpecification.typeId));
    }

    public SortedSet<Enumeration> getAllEnumValues() {
        return Collections.unmodifiableSortedSet(this.Dh);
    }

    public Set<Integer> getAllIntegerValues() {
        return Collections.unmodifiableSet(this.Dd.keySet());
    }

    public Set<String> getAllStringValues() {
        return Collections.unmodifiableSet(this.De.keySet());
    }

    public Enumeration getByName(String string) {
        if (string == null) {
            return null;
        }
        return this.Dg.get(string);
    }

    public Enumeration getByValue(Integer n2) {
        if (n2 == null) {
            return null;
        }
        return this.Df.get(n2);
    }

    public Map<Integer, String> getIntToStringMappings() {
        return Collections.unmodifiableMap(this.Dd);
    }

    public Class<? extends Enumeration> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<String, Integer> getStringToIntMappings() {
        return Collections.unmodifiableMap(this.De);
    }

    @Override
    public UaNodeId getTypeId() {
        if (this.typeId == null && "IdType".equals(this.name)) {
            return UaNodeId.from("http://opcfoundation.org/UA/", Identifiers.IdType.getValue());
        }
        return this.typeId;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.typeId == null ? 0 : this.typeId.hashCode());
        return n3;
    }

    @Override
    public boolean isAbstract() {
        return UaDataTypeIds.Enumeration.equals(this.getTypeId());
    }

    public Builder toBuilder() {
        Builder builder = EnumerationSpecification.builder();
        builder.setTypeId(this.typeId);
        builder.setName(this.name);
        builder.setMappings(this.Dd);
        return builder;
    }

    @Override
    public DataTypeDefinition toDataTypeDefinition(NamespaceTable namespaceTable) {
        EnumDefinition.Builder builder = EnumDefinition.builder();
        ArrayList<EnumField> arrayList = new ArrayList<EnumField>();
        for (Map.Entry<Integer, String> entry : this.getIntToStringMappings().entrySet()) {
            EnumField.Builder builder2 = EnumField.builder();
            builder2.setDescription(null);
            builder2.setDisplayName(new LocalizedText(entry.getValue()));
            builder2.setName(entry.getValue());
            builder2.setValue(entry.getKey().longValue());
            arrayList.add(builder2.build());
        }
        builder.setFields(arrayList.toArray(new EnumField[0]));
        return builder.build();
    }

    public Enumeration.Builder toEnumerationBuilder() {
        if (this.Di == null) {
            return DynamicEnumeration.builder(this);
        }
        return this.Di.get();
    }

    public String toString() {
        return "EnumerationSpecification [typeId=" + this.typeId + ", name=" + this.name + ", values=" + this.Dd + "]";
    }

    @Override
    public EnumerationSpecification withTranslatedNamespaces(UaNamespaceTranslateable.Context context) {
        Object object;
        UaNodeId uaNodeId = this.getTypeId().withTranslatedNamespaces(context);
        if (context.getTypeSpecificationTarget() != null && (object = context.getTypeSpecificationTarget().getEnumerationSpecification(uaNodeId)) != null) {
            return object;
        }
        object = this.toBuilder();
        ((Builder)object).setTypeId(uaNodeId);
        ((Builder)object).setJavaClass(DynamicEnumeration.class);
        ((Builder)object).setBuilderSupplier(null);
        EnumerationSpecification enumerationSpecification = ((Builder)object).build();
        if (context.getTypeSpecificationTranslationListener() != null) {
            context.getTypeSpecificationTranslationListener().accept(enumerationSpecification);
        }
        return enumerationSpecification;
    }

    private void eDk() {
        for (Integer n2 : this.getAllIntegerValues()) {
            Enumeration enumeration;
            String string = this.getIntToStringMappings().get(n2);
            Enumeration.Builder builder = this.toEnumerationBuilder();
            builder.setValue(n2);
            Enumeration enumeration2 = builder.build();
            Enumeration enumeration3 = this.Df.put(n2, enumeration2);
            if (enumeration3 != null) {
                logger.warn("More than one Enumeration mapping for: {} in specification: {}", (Object)n2, (Object)this);
            }
            if ((enumeration = this.Dg.put(string, enumeration2)) != null) {
                logger.warn("More than one Enumeration mapping for: {} in specification: {}", (Object)string, (Object)this);
            }
            this.Dh.add(enumeration2);
        }
    }

    public static interface EnumerationBuilderSupplier {
        public Enumeration.Builder get();
    }

    public static class Builder {
        private UaNodeId typeId = null;
        private String name = null;
        private final Map<Integer, String> Dd = new HashMap<Integer, String>();
        private final Map<String, Integer> De = new HashMap<String, Integer>();
        private EnumerationBuilderSupplier Di = null;
        private Class<? extends Enumeration> javaClass = null;

        private Builder() {
        }

        public Builder addMapping(int n2, String string) {
            this.Dd.put(n2, string);
            if (this.De.put(string, n2) != null) {
                logger.warn("Duplicate String mapping '{}' for given Enumeration {} Integer value '{}'", string, this.name, n2);
            }
            return this;
        }

        public EnumerationSpecification build() {
            return new EnumerationSpecification(this.typeId, this.name, this.javaClass, this.Dd, this.De, this.Di);
        }

        public Builder setBuilderSupplier(EnumerationBuilderSupplier enumerationBuilderSupplier) {
            this.Di = enumerationBuilderSupplier;
            return this;
        }

        public Builder setJavaClass(Class<? extends Enumeration> clazz) {
            this.javaClass = clazz;
            return this;
        }

        public Builder setMappings(Map<Integer, String> map) {
            this.Dd.clear();
            this.De.clear();
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                this.addMapping(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setTypeId(UaNodeId uaNodeId) {
            this.typeId = uaNodeId;
            return this;
        }
    }
}

