/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferFactory;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class ByteQueue {
    private static final ByteBuffer CL = ByteBuffer.allocate(0);
    private static final ByteBuffer[] CM = new ByteBuffer[0];
    ByteBufferFactory CN = ByteBufferFactory.LITTLE_ENDIAN_HEAP_BYTEBUFFER_FACTORY;
    int chunkSize = 4096;
    long CF;
    long CO;
    long CP = Long.MAX_VALUE;
    ByteOrder CJ = ByteOrder.LITTLE_ENDIAN;
    Deque<ByteBuffer> CQ = new ArrayDeque<ByteBuffer>();
    ByteBuffer CR;
    ByteBuffer CS;

    private static void copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n2) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer2.limit();
        byteBuffer.limit(byteBuffer.position() + n2);
        byteBuffer2.limit(byteBuffer2.position() + n2);
        byteBuffer2.put(byteBuffer);
        byteBuffer.limit(n3);
        byteBuffer2.limit(n4);
    }

    private static void copyRemaining(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n2 = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
        ByteQueue.copy(byteBuffer, byteBuffer2, n2);
    }

    public ByteQueue() {
    }

    public ByteQueue(int n2) {
        this.chunkSize = n2;
    }

    public void clear() {
        this.CO = 0L;
        this.CF = 0L;
        this.CQ.clear();
        this.CR = null;
        this.CS = null;
    }

    public void get(byte[] byArray) throws BufferUnderflowException {
        this.get(byArray, 0, byArray.length);
    }

    public void get(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if ((long)n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        while (n3 > 0) {
            ByteBuffer byteBuffer = this.getReadChunk();
            if (byteBuffer == null) {
                throw new BufferUnderflowException();
            }
            int n4 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void get(ByteBuffer byteBuffer) throws BufferUnderflowException {
        if ((long)byteBuffer.remaining() > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.get(byteBuffer, byteBuffer.remaining());
    }

    public void get(ByteBuffer byteBuffer, int n2) throws BufferUnderflowException {
        if (n2 > byteBuffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        while (n2 > 0) {
            ByteBuffer byteBuffer2 = this.getReadChunk();
            int n3 = Math.min(byteBuffer2.remaining(), n2);
            ByteQueue.copy(byteBuffer2, byteBuffer, n3);
            n2 -= n3;
        }
    }

    public ByteBuffer get(int n2) throws BufferUnderflowException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return CL;
        }
        int n3 = this.E(n2);
        if (n3 == 1) {
            ByteBuffer byteBuffer = this.getChunks(n2)[0];
            return byteBuffer;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(this.CJ);
        this.get(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void getAvailable(ByteBuffer byteBuffer) {
        this.get(byteBuffer, Math.min(byteBuffer.remaining(), (int)this.remaining()));
    }

    public ByteBufferFactory getByteBufferFactory() {
        return this.CN;
    }

    public long getBytesRead() {
        return this.CF + (long)(this.CS == null ? 0 : this.CS.position());
    }

    public long getBytesWritten() {
        return this.CO + (long)(this.CR == null ? 0 : this.CR.position());
    }

    public ByteBuffer[] getChunks(int n2) throws BufferUnderflowException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return CM;
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.E(n2)];
        int n3 = 0;
        ByteBuffer byteBuffer = this.getReadChunk();
        while (byteBuffer != null && n2 > 0) {
            if (n2 < byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = this.CS.slice();
                byteBuffer2.order(this.CJ);
                this.CS.position(this.CS.position() + n2);
                byteBuffer2.limit(n2);
                byteBufferArray[n3++] = byteBuffer2;
                n2 = 0;
            } else {
                this.CF += (long)(byteBuffer.remaining() + byteBuffer.position());
                n2 -= byteBuffer.remaining();
                this.CS = null;
                byteBufferArray[n3++] = byteBuffer.slice().order(this.CJ);
            }
            byteBuffer = this.getReadChunk();
        }
        return byteBufferArray;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public ByteBuffer getReadChunk() {
        if (this.CS != null && !this.CS.hasRemaining()) {
            this.CF += (long)this.CS.position();
            this.CS = null;
        }
        if (this.CS != null) {
            return this.CS;
        }
        if (this.CQ.isEmpty()) {
            this.eDf();
        }
        if (!this.CQ.isEmpty()) {
            this.CS = this.CQ.removeFirst();
            this.CF -= (long)this.CS.position();
            return this.CS;
        }
        return null;
    }

    public int getWriteableBytesRemaining() {
        return (int)Math.min(Integer.MAX_VALUE, this.CP - this.getBytesWritten());
    }

    public ByteBuffer getWriteChunk() {
        if (this.CR != null && !this.CR.hasRemaining()) {
            this.eDf();
        }
        if (this.CR != null) {
            return this.CR;
        }
        int n2 = Math.min(this.getWriteableBytesRemaining(), this.chunkSize);
        if (n2 == 0) {
            throw new BufferOverflowException();
        }
        this.CR = this.CN.allocate(n2);
        this.CR.order(this.CJ);
        return this.CR;
    }

    public long getWriteLimit() {
        return this.CP;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public boolean isEmpty() {
        return this.remaining() == 0L;
    }

    public void offer(ByteBuffer byteBuffer) throws BufferOverflowException {
        if (this.getWriteableBytesRemaining() < byteBuffer.remaining()) {
            throw new BufferOverflowException();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        this.eDf();
        this.CO += (long)byteBuffer.remaining();
        this.CQ.addLast(byteBuffer);
    }

    public void omitAll() {
        if (this.CR != null) {
            this.CO += (long)this.CR.position();
        }
        this.CF = this.CO;
        this.CQ.clear();
        this.CR = null;
        this.CS = null;
    }

    public ByteOrder order() {
        return this.CJ;
    }

    public void order(ByteOrder byteOrder) {
        this.CJ = byteOrder;
    }

    public void peek(byte[] byArray) throws BufferUnderflowException {
        this.peek(byArray, 0, byArray.length);
    }

    public void peek(byte[] byArray, int n2, int n3) throws BufferUnderflowException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if ((long)n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (this.CS != null) {
            int n4 = Math.min(this.CS.remaining(), n3);
            this.CS.mark();
            this.CS.get(byArray, n2, n4);
            this.CS.reset();
            n2 += n4;
            if ((n3 -= n4) == 0) {
                return;
            }
        }
        if (!this.CQ.isEmpty()) {
            Iterator<ByteBuffer> iterator = this.CQ.iterator();
            while (n3 > 0 && iterator.hasNext()) {
                ByteBuffer byteBuffer = iterator.next();
                int n5 = Math.min(byteBuffer.remaining(), n3);
                byteBuffer.mark();
                byteBuffer.get(byArray, n2, n5);
                byteBuffer.reset();
                n2 += n5;
                n3 -= n5;
            }
        }
        if (this.CR != null) {
            ByteBuffer byteBuffer = (ByteBuffer)this.CR.duplicate().flip();
            byteBuffer.order(this.CJ);
            int n6 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n6);
            n2 += n6;
            n3 -= n6;
        }
    }

    public void peek(ByteBuffer byteBuffer) throws BufferUnderflowException {
        if ((long)byteBuffer.remaining() > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.peekAvailable(byteBuffer);
    }

    public ByteBuffer peek(int n2) throws BufferUnderflowException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return CL;
        }
        ByteBuffer[] byteBufferArray = this.peekChunks(n2);
        if (byteBufferArray.length == 1) {
            return byteBufferArray[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(this.CJ);
        this.peek(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void peekAvailable(ByteBuffer byteBuffer) {
        Object object;
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (this.CS != null) {
            this.CS.mark();
            ByteQueue.copyRemaining(this.CS, byteBuffer);
            this.CS.reset();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (!this.CQ.isEmpty()) {
            object = this.CQ.iterator();
            while (byteBuffer.hasRemaining() && object.hasNext()) {
                ByteBuffer byteBuffer2 = object.next();
                byteBuffer2.mark();
                ByteQueue.copyRemaining(byteBuffer2, byteBuffer);
                byteBuffer2.reset();
            }
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (this.CR != null) {
            object = (ByteBuffer)this.CR.duplicate().flip();
            ((ByteBuffer)object).order(this.CJ);
            ByteQueue.copyRemaining((ByteBuffer)object, byteBuffer);
        }
    }

    public ByteBuffer[] peekChunks(int n2) throws BufferUnderflowException {
        Object object;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return CM;
        }
        int n3 = n2;
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.E(n2)];
        int n4 = 0;
        if (this.CS != null) {
            object = this.CS.slice();
            ((ByteBuffer)object).order(this.CJ);
            if (n3 < ((Buffer)object).remaining()) {
                ((ByteBuffer)object).limit(n3);
                n3 = 0;
            } else {
                n3 -= ((Buffer)object).remaining();
            }
            byteBufferArray[n4++] = object;
        }
        if (!this.CQ.isEmpty() && n3 > 0) {
            object = this.CQ.iterator();
            while (n3 > 0 && object.hasNext()) {
                ByteBuffer byteBuffer = ((ByteBuffer)object.next()).slice();
                byteBuffer.order(this.CJ);
                if (n3 < byteBuffer.remaining()) {
                    byteBuffer.limit(n3);
                    n3 = 0;
                } else {
                    n3 -= byteBuffer.remaining();
                }
                byteBufferArray[n4++] = byteBuffer;
            }
        }
        if (n3 > 0 && this.CR != null) {
            object = (ByteBuffer)this.CR.duplicate().flip();
            ((ByteBuffer)object).order(this.CJ);
            if (n3 < ((Buffer)object).remaining()) {
                ((ByteBuffer)object).limit(n3);
                n3 = 0;
            } else {
                n3 -= ((Buffer)object).remaining();
            }
            byteBufferArray[n4++] = object;
        }
        return byteBufferArray;
    }

    public void put(byte by) {
        this.getWriteChunk().put(by);
    }

    public void put(byte[] byArray) throws BufferOverflowException {
        this.put(byArray, 0, byArray.length);
    }

    public void put(byte[] byArray, int n2, int n3) throws BufferOverflowException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        while (n3 > 0) {
            ByteBuffer byteBuffer = this.getWriteChunk();
            int n4 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void put(ByteBuffer byteBuffer) {
        this.put(byteBuffer, byteBuffer.remaining());
    }

    public void put(ByteBuffer byteBuffer, int n2) {
        while (n2 > 0) {
            ByteBuffer byteBuffer2 = this.getWriteChunk();
            int n3 = Math.min(byteBuffer2.remaining(), n2);
            ByteQueue.copy(byteBuffer, byteBuffer2, n3);
            n2 -= n3;
        }
    }

    public long remaining() {
        return this.getBytesWritten() - this.getBytesRead();
    }

    public void setByteBufferFactory(ByteBufferFactory byteBufferFactory) {
        this.CN = byteBufferFactory;
    }

    public void setChunkSize(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("chunk size < 1");
        }
        this.chunkSize = n2;
    }

    public void setWriteLimit(long l2) {
        this.CP = l2;
    }

    public void skip(int n2) throws BufferOverflowException {
        if ((long)n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (n2 > 0) {
            ByteBuffer byteBuffer = this.getReadChunk();
            int n3 = Math.min(byteBuffer.remaining(), n2);
            byteBuffer.position(byteBuffer.position() + n3);
            n2 -= n3;
        }
    }

    public String toString() {
        return "ByteQueue (read=" + this.getBytesRead() + ", written=" + this.getBytesWritten() + ")";
    }

    private int E(int n2) {
        int n3 = 0;
        if (n2 == 0) {
            return n3;
        }
        if (this.CS != null) {
            n2 -= Math.min(this.CS.remaining(), n2);
            ++n3;
        }
        if (n2 == 0) {
            return n3;
        }
        if (!this.CQ.isEmpty()) {
            Iterator<ByteBuffer> iterator = this.CQ.iterator();
            while (n2 > 0 && iterator.hasNext()) {
                ByteBuffer byteBuffer = iterator.next();
                n2 -= Math.min(byteBuffer.remaining(), n2);
                ++n3;
            }
        }
        if (n2 == 0) {
            return n3;
        }
        if (this.CR != null) {
            ++n3;
        }
        return n3;
    }

    private void eDf() {
        if (this.CR == null) {
            return;
        }
        if (this.CR.position() == 0) {
            return;
        }
        if (!this.CR.hasRemaining()) {
            this.CO += (long)this.CR.position();
            this.CR.flip();
            this.CQ.addLast(this.CR);
            this.CR = null;
            return;
        }
        this.CO += (long)this.CR.position();
        ByteBuffer byteBuffer = this.CR;
        this.CR = this.CR.slice();
        this.CR.order(this.CJ);
        byteBuffer.flip();
        this.CQ.addLast(byteBuffer);
    }
}

