/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.encoding.binary.ByteUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayWriteable2
implements IBinaryWriteable {
    ByteBuffer[] CH;
    int CI = 0;
    ByteBuffer cur;
    ByteOrder CJ;
    ChunkListener CK;

    public ByteBufferArrayWriteable2(ByteBuffer[] byteBufferArray, ChunkListener chunkListener) {
        if (byteBufferArray == null || chunkListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.CH = byteBufferArray;
        this.CK = chunkListener;
        this.cur = byteBufferArray[0];
    }

    @Override
    public void flush() {
    }

    @Override
    public ByteOrder order() {
        return this.CJ;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.CJ = byteOrder;
        this.cur.order(byteOrder);
    }

    @Override
    public void put(byte by) throws IOException {
        this.eDe();
        this.cur.put(by);
        this.eDd();
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.put(byArray, 0, byArray.length);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            this.eDe();
            int n4 = Math.min(n3, this.cur.remaining());
            this.cur.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
            this.eDd();
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            this.eDe();
            ByteBufferUtils.copyRemaining(byteBuffer, this.cur);
            this.eDd();
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) throws IOException {
        while (n2 > 0) {
            this.eDe();
            int n3 = Math.min(n2, Math.min(byteBuffer.remaining(), this.cur.remaining()));
            ByteBufferUtils.copy(byteBuffer, this.cur, n3);
            n2 -= n3;
            this.eDd();
        }
    }

    @Override
    public void putDouble(double d2) throws IOException {
        this.putLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void putFloat(float f2) throws IOException {
        this.putInt(Float.floatToIntBits(f2));
    }

    @Override
    public void putInt(int n2) throws IOException {
        if (this.cur.remaining() >= 4) {
            this.cur.putInt(n2);
            this.eDd();
        } else {
            this.put(ByteUtils.intToBytes(n2, this.CJ));
        }
    }

    @Override
    public void putLong(long l2) throws IOException {
        if (this.cur.remaining() >= 8) {
            this.cur.putLong(l2);
            this.eDd();
        } else {
            this.put(ByteUtils.longToBytes(l2, this.CJ));
        }
    }

    @Override
    public void putShort(short s2) throws IOException {
        if (this.cur.remaining() >= 2) {
            this.cur.putShort(s2);
            this.eDd();
        } else {
            this.put(ByteUtils.shortToBytes(s2, this.CJ));
        }
    }

    private void eDd() {
        if (!this.cur.hasRemaining()) {
            this.fireChunkComplete(this.CI);
        }
    }

    private void eDe() {
        while (!this.cur.hasRemaining()) {
            ++this.CI;
            if (this.CI >= this.CH.length) {
                throw new BufferOverflowException();
            }
            this.cur = this.CH[this.CI];
            this.cur.order(this.CJ);
        }
    }

    protected void fireChunkComplete(int n2) {
        if (this.CK != null) {
            this.CK.onChunkComplete(this.CH, n2);
        }
    }

    void D(int n2) throws IOException {
        this.eDe();
        this.cur.put((byte)n2);
        this.eDd();
    }

    public static interface ChunkListener {
        public void onChunkComplete(ByteBuffer[] var1, int var2);
    }
}

