/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayWriteable
implements IBinaryWriteable {
    ByteQueue Cd;
    ByteBuffer CG = ByteBuffer.allocate(8);

    public ByteBufferArrayWriteable(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.Cd = new ByteQueue();
        this.CG.order(this.Cd.order());
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.Cd.offer(byteBuffer);
        }
    }

    public ByteBufferArrayWriteable(ByteQueue byteQueue) {
        if (byteQueue == null) {
            throw new IllegalArgumentException("null");
        }
        this.Cd = byteQueue;
        this.CG.order(byteQueue.order());
    }

    @Override
    public void flush() {
    }

    @Override
    public ByteOrder order() {
        return this.Cd.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.CG.order(byteOrder);
        this.Cd.order(byteOrder);
    }

    @Override
    public void put(byte by) throws IOException {
        this.Cd.getWriteChunk().put(by);
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.Cd.put(byArray);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) throws IOException {
        this.Cd.put(byArray, n2, n3);
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        this.Cd.put(byteBuffer);
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) throws IOException {
        this.Cd.put(byteBuffer, n2);
    }

    @Override
    public void putDouble(double d2) throws IOException {
        if (this.Cd.getWriteChunk().remaining() > 8) {
            this.Cd.getWriteChunk().putDouble(d2);
        } else {
            this.CG.rewind();
            this.CG.putDouble(d2);
            this.CG.rewind();
            this.Cd.put(this.CG, 8);
        }
    }

    @Override
    public void putFloat(float f2) throws IOException {
        if (this.Cd.getWriteChunk().remaining() > 4) {
            this.Cd.getWriteChunk().putFloat(f2);
        } else {
            this.CG.rewind();
            this.CG.putFloat(f2);
            this.CG.rewind();
            this.Cd.put(this.CG, 4);
        }
    }

    @Override
    public void putInt(int n2) throws IOException {
        if (this.Cd.getWriteChunk().remaining() > 4) {
            this.Cd.getWriteChunk().putInt(n2);
        } else {
            this.CG.rewind();
            this.CG.putInt(n2);
            this.CG.rewind();
            this.Cd.put(this.CG, 4);
        }
    }

    @Override
    public void putLong(long l2) throws IOException {
        if (this.Cd.getWriteChunk().remaining() > 8) {
            this.Cd.getWriteChunk().putLong(l2);
        } else {
            this.CG.rewind();
            this.CG.putLong(l2);
            this.CG.rewind();
            this.Cd.put(this.CG, 8);
        }
    }

    @Override
    public void putShort(short s2) throws IOException {
        if (this.Cd.getWriteChunk().remaining() > 2) {
            this.Cd.getWriteChunk().putShort(s2);
        } else {
            this.CG.rewind();
            this.CG.putShort(s2);
            this.CG.rewind();
            this.Cd.put(this.CG, 2);
        }
    }
}

