/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.stack.encoding.binary.LittleEndianByteUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;

public class ByteBufferArrayReadable
implements IBinaryReadable {
    private final byte[] CC = new byte[1];
    private final byte[] tx = new byte[2];
    private final byte[] ty = new byte[4];
    private final byte[] CD = new byte[8];
    private final ArrayDeque<ByteBuffer> CE;
    private final long limit;
    private long CF = 0L;

    private static void copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n2) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer2.limit();
        byteBuffer.limit(byteBuffer.position() + n2);
        byteBuffer2.limit(byteBuffer2.position() + n2);
        byteBuffer2.put(byteBuffer);
        byteBuffer.limit(n3);
        byteBuffer2.limit(n4);
    }

    public ByteBufferArrayReadable(ByteBuffer[] byteBufferArray) {
        InternalArguments.checkNotNull(byteBufferArray);
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.CE = new ArrayDeque(byteBufferArray.length);
        long l2 = 0L;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (!ByteOrder.LITTLE_ENDIAN.equals(byteBuffer.order())) {
                throw new IllegalArgumentException("The given ByteBuffers shall be in LITTLE_ENDIAN order");
            }
            this.CE.add(byteBuffer);
            l2 += (long)byteBuffer.remaining();
        }
        this.limit = l2;
    }

    @Override
    public byte get() {
        this.get(this.CC);
        return this.CC[0];
    }

    @Override
    public void get(byte[] byArray) {
        this.d(byArray, 0, byArray.length);
    }

    @Override
    public void get(byte[] byArray, int n2, int n3) {
        this.d(byArray, n2, n3);
    }

    @Override
    public void get(ByteBuffer byteBuffer) {
        this.a(byteBuffer, byteBuffer.remaining());
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n2) {
        this.a(byteBuffer, n2);
    }

    @Override
    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public int getInt() {
        this.get(this.ty);
        return LittleEndianByteUtils.bytesToInt(this.ty);
    }

    @Override
    public long getLong() {
        this.get(this.CD);
        return LittleEndianByteUtils.bytesToLong(this.CD);
    }

    @Override
    public short getShort() {
        this.get(this.tx);
        return LittleEndianByteUtils.bytesToShort(this.tx);
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    @Deprecated
    public void order(ByteOrder byteOrder) {
        if (byteOrder != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("This implementation only supports LITTLE_ENDIAN");
        }
    }

    @Override
    public long position() {
        return this.CF;
    }

    public long remaining() {
        return this.limit - this.CF;
    }

    private void d(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            ByteBuffer byteBuffer = this.CE.peek();
            if (byteBuffer == null) {
                throw new BufferUnderflowException();
            }
            if (!byteBuffer.hasRemaining()) {
                this.CE.pop();
                continue;
            }
            int n4 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n4);
            n3 -= n4;
            n2 += n4;
            this.CF += (long)n4;
        }
    }

    private void a(ByteBuffer byteBuffer, int n2) {
        while (n2 > 0) {
            ByteBuffer byteBuffer2 = this.CE.peek();
            if (byteBuffer2 == null) {
                throw new BufferUnderflowException();
            }
            if (!byteBuffer2.hasRemaining()) {
                this.CE.pop();
                continue;
            }
            int n3 = Math.min(byteBuffer2.remaining(), n2);
            ByteBufferArrayReadable.copy(byteBuffer2, byteBuffer, n3);
            n2 -= n3;
            this.CF += (long)n3;
        }
    }
}

