/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenableServerSocketChannel {
    static Logger logger = LoggerFactory.getLogger(ListenableServerSocketChannel.class);
    AtomicReference<ServerSocketChannel> gp = new AtomicReference<Object>(null);
    AsyncSelector Cm;
    Executor executor;
    volatile ServerSocketAcceptable Cn;
    boolean Co = false;
    boolean Cp = false;
    Runnable Cq;
    AsyncSelector.SelectListener Cr = new AsyncSelector.SelectListener(){

        @Override
        public void onSelected(AsyncSelector asyncSelector, SelectableChannel selectableChannel, int n2, int n3) {
            Runnable runnable;
            selectableChannel.keyFor(asyncSelector.BG).interestOps(0);
            if ((n2 & 0x10) != 0 && (runnable = ListenableServerSocketChannel.this.Cq) != null) {
                if (ListenableServerSocketChannel.this.executor == null) {
                    ListenableServerSocketChannel.this.Co = true;
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        logger.trace("failure while selected channel", throwable);
                    }
                } else {
                    ListenableServerSocketChannel.this.Co = true;
                    ListenableServerSocketChannel.this.executor.execute(runnable);
                }
            }
            asyncSelector.interestOps(selectableChannel, ListenableServerSocketChannel.this.getInterestOps());
        }
    };

    public ListenableServerSocketChannel(ServerSocketChannel serverSocketChannel, Executor executor) throws IOException {
        this(serverSocketChannel, executor, new AsyncSelector(Selector.open()));
        this.Cp = true;
    }

    public ListenableServerSocketChannel(ServerSocketChannel serverSocketChannel, Executor executor, AsyncSelector asyncSelector) throws ClosedChannelException {
        if (serverSocketChannel.isBlocking()) {
            throw new IllegalArgumentException("channel arg must be in non-blocking mode. (SocketChannel.configureBlocking(false))");
        }
        if (asyncSelector == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.executor = executor;
        this.gp.set(serverSocketChannel);
        this.Cm = asyncSelector;
        asyncSelector.register(serverSocketChannel, 0, this.Cr);
    }

    public void bind(SocketAddress socketAddress, int n2) throws IOException {
        ServerSocketChannel serverSocketChannel = this.getChannel();
        serverSocketChannel.socket().bind(socketAddress, n2);
        if (socketAddress instanceof InetSocketAddress && ((InetSocketAddress)socketAddress).getPort() == 0) {
            logger.debug("OS chose port: {} as the next free port where to bind", (Object)serverSocketChannel.socket().getLocalPort());
        }
        logger.debug("bind, address:{}, backlog:{}, socket:{}", socketAddress, n2, serverSocketChannel);
        this.Cm.register(serverSocketChannel, 16, this.Cr);
    }

    public void close() throws IOException {
        ServerSocketChannel serverSocketChannel = this.gp.getAndSet(null);
        if (serverSocketChannel == null) {
            return;
        }
        this.Cm.unregister(serverSocketChannel);
        if (this.Cp) {
            this.Cm.close();
        }
        serverSocketChannel.close();
        logger.debug("closed");
    }

    public ServerSocketAcceptable getAcceptableListener() {
        return this.Cn;
    }

    public ServerSocketChannel getChannel() {
        return this.gp.get();
    }

    public AsyncSelector getSelectorThread() {
        return this.Cm;
    }

    public void setAcceptableListener(final ServerSocketAcceptable serverSocketAcceptable) {
        this.Cn = serverSocketAcceptable;
        this.Cq = serverSocketAcceptable != null ? new Runnable(){

            @Override
            public void run() {
                try {
                    serverSocketAcceptable.onConnectionAcceptable(ListenableServerSocketChannel.this);
                }
                finally {
                    ListenableServerSocketChannel.this.Co = false;
                    ListenableServerSocketChannel.this.eCZ();
                }
            }
        } : null;
        this.eCZ();
    }

    int getInterestOps() {
        ServerSocketChannel serverSocketChannel = this.gp.get();
        if (serverSocketChannel == null || !serverSocketChannel.isOpen() || !serverSocketChannel.isRegistered()) {
            return 0;
        }
        int n2 = 0;
        if (this.Cn != null && !this.Co) {
            n2 |= 0x10;
        }
        return n2;
    }

    void eCZ() {
        ServerSocketChannel serverSocketChannel = this.gp.get();
        if (serverSocketChannel != null) {
            this.Cm.interestOps(serverSocketChannel, this.getInterestOps());
        }
    }

    public static interface ServerSocketAcceptable {
        public void onConnectionAcceptable(ListenableServerSocketChannel var1);
    }
}

