/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.CurrentThreadExecutor;
import com.prosysopc.ua.stack.utils.IStatefulObject;
import com.prosysopc.ua.stack.utils.StateListener;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncInputStream;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncOutputStream;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSocket;
import com.prosysopc.ua.stack.utils.asyncsocket.BufferMonitor;
import com.prosysopc.ua.stack.utils.asyncsocket.BufferMonitorState;
import com.prosysopc.ua.stack.utils.asyncsocket.ListenableSocketChannel;
import com.prosysopc.ua.stack.utils.asyncsocket.MonitorListener;
import com.prosysopc.ua.stack.utils.asyncsocket.SocketState;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSocketImpl
extends AbstractState<SocketState, IOException>
implements IStatefulObject<SocketState, IOException>,
AsyncSocket {
    private static final int BT = 65536;
    private static Logger logger = LoggerFactory.getLogger(AsyncSocketImpl.class);
    ListenableSocketChannel BU;
    SocketChannel chan;
    AsyncSocketInputStream BV;
    AsyncSocketOutputStream BW;
    Executor BX;
    ListenableSocketChannel.ConnectionListener BY = new ListenableSocketChannel.ConnectionListener(){

        @Override
        public void onConnected(ListenableSocketChannel listenableSocketChannel) {
            AsyncSocketImpl.this.BU.setConnectListener(null);
            AsyncSocketImpl.this.setState(SocketState.Connected);
        }

        @Override
        public void onConnectFailed(ListenableSocketChannel listenableSocketChannel, IOException iOException) {
            AsyncSocketImpl.this.BU.setConnectListener(null);
            AsyncSocketImpl.this.setState(SocketState.Closed);
        }
    };
    ListenableSocketChannel.ReadableListener BZ = new ListenableSocketChannel.ReadableListener(){

        @Override
        public void onDataReadable(ListenableSocketChannel listenableSocketChannel) {
            if (AsyncSocketImpl.this.BV.closed) {
                try {
                    AsyncSocketImpl.this.close();
                }
                catch (IOException iOException) {}
            } else {
                AsyncSocketImpl.this.BV.eCU();
                AsyncSocketImpl.this.BV.eCW();
            }
        }
    };
    ListenableSocketChannel.WriteableListener Ca = new ListenableSocketChannel.WriteableListener(){

        @Override
        public void onDataWriteable(ListenableSocketChannel listenableSocketChannel) {
            AsyncSocketImpl.this.BW.eCY();
            AsyncSocketImpl.this.BW.eCX();
        }
    };

    public AsyncSocketImpl() throws IOException {
        this((SocketChannel)SocketChannel.open().configureBlocking(false), CurrentThreadExecutor.INSTANCE, new AsyncSelector());
    }

    public AsyncSocketImpl(SocketChannel socketChannel) throws IOException {
        this(socketChannel, CurrentThreadExecutor.INSTANCE, new AsyncSelector());
    }

    public AsyncSocketImpl(SocketChannel socketChannel, Executor executor, AsyncSelector asyncSelector) throws IOException {
        super(socketChannel.isConnected() ? SocketState.Connected : SocketState.Ready, SocketState.Error);
        this.BX = executor;
        this.BU = new ListenableSocketChannel(socketChannel, asyncSelector);
        this.chan = this.BU.getChannel();
        this.BV = new AsyncSocketInputStream();
        this.BW = new AsyncSocketOutputStream();
        this.addStateListener(new StateListener<SocketState>(){

            public void a(IStatefulObject<SocketState, ?> iStatefulObject, SocketState socketState, SocketState socketState2) {
                if (SocketState.FINAL_STATES.contains((Object)socketState2)) {
                    AsyncSocketImpl.this.BV.close();
                    AsyncSocketImpl.this.BW.close();
                }
            }

            @Override
            public /* synthetic */ void onStateTransition(IStatefulObject iStatefulObject, Object object, Object object2) {
                this.a(iStatefulObject, (SocketState)((Object)object), (SocketState)((Object)object2));
            }
        });
    }

    @Override
    public AsyncSocketImpl close() throws IOException {
        if (logger.isTraceEnabled()) {
            try {
                throw new Exception("This exception is only thrown for the purpose of showing the stacktrace of the call");
            }
            catch (Exception exception) {
                logger.trace("AsyncSocketImpl.close called from (see stacktrace)", exception);
            }
        }
        this.BU.close();
        this.attemptSetState(SocketState.NON_FINAL_STATES, SocketState.Closed);
        return this;
    }

    public void closeOnFlush() {
        this.getOutputStream().createMonitor(this.getOutputStream().getPosition(), new MonitorListener(){

            public void a(IStatefulObject<BufferMonitorState, ?> iStatefulObject, BufferMonitorState bufferMonitorState, BufferMonitorState bufferMonitorState2) {
                try {
                    AsyncSocketImpl.this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public /* synthetic */ void onStateTransition(IStatefulObject iStatefulObject, Object object, Object object2) {
                this.a(iStatefulObject, (BufferMonitorState)((Object)object), (BufferMonitorState)((Object)object2));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.throwIfError();
        SocketState socketState = (SocketState)((Object)this.getState());
        if (socketState != SocketState.Ready) {
            throw new IOException("Socket not ready, was in state: " + (Object)((Object)socketState));
        }
        AsyncSocketImpl asyncSocketImpl = this;
        synchronized (asyncSocketImpl) {
            try {
                this.BU.connect(socketAddress);
                this.BU.setConnectListener(this.BY);
                this.setState(SocketState.Connecting);
            }
            catch (IOException iOException) {
                this.BU.setConnectListener(null);
                throw iOException;
            }
        }
    }

    @Override
    public AsyncSocketInputStream getInputStream() {
        return this.BV;
    }

    @Override
    public AsyncSocketOutputStream getOutputStream() {
        return this.BW;
    }

    @Override
    public IStatefulObject<SocketState, IOException> getStateMonitor() {
        return this;
    }

    @Override
    public Socket socket() {
        return this.chan.socket();
    }

    @Override
    public SocketChannel socketChannel() {
        return this.chan;
    }

    public boolean syncConnect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress);
        try {
            this.waitForState(SocketState.CONNECTING_TRANSITION_STATES);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.getError() != null) {
            throw (IOException)this.getError();
        }
        return this.chan.isConnected();
    }

    @Override
    protected boolean isStateTransitionAllowed(SocketState socketState, SocketState socketState2) {
        return !SocketState.FINAL_STATES.contains(this.getState());
    }

    @Override
    protected void onStateTransition(SocketState socketState, SocketState socketState2) {
        if (SocketState.FINAL_STATES.contains((Object)socketState2)) {
            this.BV.close();
            this.BW.close();
        }
    }

    @Override
    protected boolean setState(SocketState socketState) {
        return super.setState(socketState, CurrentThreadExecutor.INSTANCE, null) == socketState;
    }

    public class AsyncSocketOutputStream
    extends AsyncOutputStream {
        TreeSet<BufferMonitor> Cc = new TreeSet();
        ByteQueue Cd = new ByteQueue(16384);
        boolean closed;

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (BufferMonitor bufferMonitor : this.Cc) {
                if (bufferMonitor.Cj > this.Cd.getBytesRead()) {
                    if (AsyncSocketImpl.this.getState() == SocketState.Error) {
                        bufferMonitor.setError((IOException)AsyncSocketImpl.this.getError());
                        continue;
                    }
                    bufferMonitor.close();
                    continue;
                }
                logger.error("AsyncSocketOutputStream.close(): unexpected untriggered monitor");
                bufferMonitor.trigger();
            }
            this.Cc.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferMonitor createMonitor(long l2, MonitorListener monitorListener) {
            BufferMonitor bufferMonitor = new BufferMonitor(l2, AsyncSocketImpl.this.BX){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    AsyncSocketOutputStream asyncSocketOutputStream = AsyncSocketOutputStream.this;
                    synchronized (asyncSocketOutputStream) {
                        if (this.getState() != BufferMonitorState.Waiting) {
                            return;
                        }
                        AsyncSocketOutputStream.this.Cc.remove(this);
                        this.setState(BufferMonitorState.Canceled, this.Ck, null);
                    }
                }
            };
            if (monitorListener != null) {
                bufferMonitor.addStateListener(monitorListener);
            }
            AsyncSocketOutputStream asyncSocketOutputStream = this;
            synchronized (asyncSocketOutputStream) {
                if (l2 >= this.Cd.getBytesRead()) {
                    bufferMonitor.trigger();
                } else if (this.closed) {
                    if (AsyncSocketImpl.this.getState() == SocketState.Error) {
                        bufferMonitor.setError((IOException)AsyncSocketImpl.this.getError());
                    } else {
                        bufferMonitor.close();
                    }
                } else {
                    this.Cc.add(bufferMonitor);
                }
            }
            return bufferMonitor;
        }

        public void flush() throws IOException {
            BufferMonitor bufferMonitor = this.createMonitor(this.getPosition(), null);
            try {
                bufferMonitor.waitForState(BufferMonitorState.FINAL_STATES);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }

        @Override
        public synchronized long getFlushPosition() {
            return this.Cd.getBytesRead();
        }

        @Override
        public synchronized long getPosition() {
            return this.Cd.getBytesWritten();
        }

        @Override
        public synchronized long getUnflushedBytes() {
            return this.Cd.remaining();
        }

        @Override
        public synchronized void offer(ByteBuffer byteBuffer) {
            this.Cd.offer(byteBuffer);
            this.eCY();
            this.eCX();
        }

        public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
            this.Cd.put(byArray, n2, n3);
            this.eCY();
            this.eCX();
        }

        @Override
        public synchronized void write(ByteBuffer byteBuffer) {
            this.Cd.put(byteBuffer);
            this.eCY();
            this.eCX();
        }

        @Override
        public synchronized void write(ByteBuffer byteBuffer, int n2) {
            this.Cd.put(byteBuffer, n2);
            this.eCY();
            this.eCX();
        }

        public synchronized void write(int n2) throws IOException {
            this.Cd.put((byte)n2);
            this.eCY();
            this.eCX();
        }

        private synchronized void eCX() {
            if (this.closed) {
                AsyncSocketImpl.this.BU.setWriteListener(null);
                return;
            }
            boolean bl = !this.Cd.isEmpty() && AsyncSocketImpl.this.getState() == SocketState.Connected;
            AsyncSocketImpl.this.BU.setWriteListener(bl ? AsyncSocketImpl.this.Ca : null);
        }

        private synchronized void eCY() {
            while (!this.Cd.isEmpty()) {
                try {
                    int n2 = AsyncSocketImpl.this.chan.write(this.Cd.getReadChunk());
                    if (n2 != 0 && n2 != -1) continue;
                    break;
                }
                catch (IOException iOException) {
                    AsyncSocketImpl.this.setError(iOException);
                    break;
                }
            }
            if (!this.Cc.isEmpty()) {
                BufferMonitor bufferMonitor;
                Iterator<BufferMonitor> iterator = this.Cc.iterator();
                while (iterator.hasNext() && (bufferMonitor = iterator.next()).getTriggerPos() <= this.Cd.getBytesRead()) {
                    iterator.remove();
                    AsyncSocketImpl.this.BX.execute(new Runnable(){

                        @Override
                        public void run() {
                            bufferMonitor.trigger();
                        }
                    });
                }
            }
        }
    }

    public class AsyncSocketInputStream
    extends AsyncInputStream {
        TreeSet<BufferMonitor> Cc = new TreeSet();
        ByteQueue Cd = new ByteQueue(16384);
        long Ce;
        boolean closed;
        long Cf = 65536L;

        @Override
        public synchronized int available() {
            long l2 = this.Cd.remaining();
            return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.d(this.Cd.getBytesWritten());
            long l2 = this.eCV();
            for (BufferMonitor bufferMonitor : this.Cc) {
                if (bufferMonitor.Cj > l2) {
                    if (AsyncSocketImpl.this.getState() == SocketState.Error) {
                        bufferMonitor.setError((IOException)AsyncSocketImpl.this.getError());
                        continue;
                    }
                    bufferMonitor.close();
                    continue;
                }
                logger.info("AsyncSocketInputStream.close(): unexpected untriggered monitor");
                bufferMonitor.trigger();
            }
            this.Cc.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized BufferMonitor createMonitor(long l2, MonitorListener monitorListener) {
            BufferMonitor bufferMonitor = new BufferMonitor(l2, AsyncSocketImpl.this.BX){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    AsyncSocketInputStream asyncSocketInputStream = AsyncSocketInputStream.this;
                    synchronized (asyncSocketInputStream) {
                        if (this.getState() != BufferMonitorState.Waiting) {
                            return;
                        }
                        AsyncSocketInputStream.this.Cc.remove(this);
                        this.setState(BufferMonitorState.Canceled, this.Ck, null);
                    }
                }
            };
            if (monitorListener != null) {
                bufferMonitor.addStateListener(monitorListener);
            }
            AsyncSocketInputStream asyncSocketInputStream = this;
            synchronized (asyncSocketInputStream) {
                if (l2 <= this.Cd.getBytesWritten()) {
                    bufferMonitor.trigger();
                } else if (l2 > this.eCV()) {
                    if (AsyncSocketImpl.this.getState() == SocketState.Error) {
                        bufferMonitor.setError((IOException)AsyncSocketImpl.this.getError());
                    } else {
                        bufferMonitor.close();
                    }
                } else {
                    this.Cc.add(bufferMonitor);
                    this.d(l2);
                }
            }
            return bufferMonitor;
        }

        @Override
        public int getBufferSize() {
            return (int)this.Cf;
        }

        @Override
        public synchronized long getPosition() {
            return this.Cd.getBytesRead();
        }

        @Override
        public synchronized long getReceivedBytes() {
            return this.Cd.getBytesWritten();
        }

        @Override
        public synchronized void peek(byte[] byArray) {
            this.Cd.peek(byArray);
        }

        @Override
        public synchronized void peek(byte[] byArray, int n2, int n3) {
            this.Cd.peek(byArray, n2, n3);
        }

        @Override
        public synchronized ByteBuffer peek(int n2) {
            return this.Cd.peek(n2);
        }

        @Override
        public synchronized ByteBuffer[] peekChunks(int n2) {
            return this.Cd.peekChunks(n2);
        }

        @Override
        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        public synchronized int read(byte[] byArray, int n2, int n3) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            int n4 = Math.min(this.available(), n3);
            if (n4 > 0) {
                this.Cd.get(byArray, n2, n4);
                this.eCW();
                return n4;
            }
            if (this.closed) {
                return -1;
            }
            return 0;
        }

        @Override
        public synchronized void read(ByteBuffer byteBuffer) {
            this.Cd.get(byteBuffer);
            this.eCW();
        }

        @Override
        public synchronized void read(ByteBuffer byteBuffer, int n2) {
            this.Cd.get(byteBuffer, n2);
            this.eCW();
        }

        @Override
        public synchronized ByteBuffer read(int n2) {
            ByteBuffer byteBuffer = this.Cd.get(n2);
            this.eCW();
            return byteBuffer;
        }

        @Override
        public synchronized ByteBuffer[] readChunks(int n2) {
            ByteBuffer[] byteBufferArray = this.Cd.getChunks(n2);
            this.eCW();
            return byteBufferArray;
        }

        @Override
        public void setBufferSize(int n2) {
            if (n2 < 1) {
                throw new IllegalArgumentException("buf size must be over 0");
            }
            this.Cf = n2;
            this.eCW();
        }

        private synchronized void eCU() {
            try {
                int n2 = 0;
                do {
                    if ((n2 = AsyncSocketImpl.this.chan.read(this.Cd.getWriteChunk())) != -1) continue;
                    AsyncSocketImpl.this.setState(SocketState.Closed);
                    return;
                } while (n2 > 0);
            }
            catch (ClosedChannelException closedChannelException) {
                AsyncSocketImpl.this.setState(SocketState.Closed);
            }
            catch (IOException iOException) {
                AsyncSocketImpl.this.setError(iOException);
            }
            this.eCW();
            if (!this.Cc.isEmpty()) {
                BufferMonitor bufferMonitor;
                Iterator<BufferMonitor> iterator = this.Cc.iterator();
                while (iterator.hasNext() && (bufferMonitor = iterator.next()).getTriggerPos() <= this.Cd.getBytesWritten()) {
                    iterator.remove();
                    AsyncSocketImpl.this.BX.execute(new Runnable(){

                        @Override
                        public void run() {
                            bufferMonitor.trigger();
                        }
                    });
                }
            }
        }

        long eCV() {
            if (this.closed || SocketState.FINAL_STATES.contains(AsyncSocketImpl.this.getState())) {
                return this.getReceivedBytes();
            }
            return Long.MAX_VALUE;
        }

        synchronized void eCW() {
            this.d(this.Cd.getBytesRead() + this.Cf);
        }

        synchronized void d(long l2) {
            if (this.closed) {
                this.Ce = this.Cd.getBytesWritten();
                AsyncSocketImpl.this.BU.setReadListener(null);
                return;
            }
            this.Ce = Math.max(l2, this.Ce);
            AsyncSocketImpl.this.BU.setReadListener(this.Cd.getBytesWritten() < this.Ce ? AsyncSocketImpl.this.BZ : null);
        }
    }
}

