/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSUtil {
    private static final String osName;
    private static final boolean aE;
    private static int Be;
    private static Logger logger;

    public static String exec(String string) throws IOException {
        return OSUtil.exec(string, Be, TimeUnit.SECONDS);
    }

    public static String exec(String string, int n2, TimeUnit timeUnit) throws IOException {
        Process process;
        String[] stringArray;
        Object object;
        if (!OSUtil.isWindows() && (string.contains("|") || string.contains("\"") || string.contains("'"))) {
            object = OSUtil.isAndroid() ? "/system/bin/sh" : "/bin/sh";
            stringArray = new String[]{object, "-c", string};
            process = Runtime.getRuntime().exec(stringArray);
        } else {
            process = Runtime.getRuntime().exec(string);
        }
        object = Executors.newScheduledThreadPool(1);
        try {
            stringArray = new ArrayList();
            Callable<Integer> callable = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return process.waitFor();
                }
            };
            stringArray.add(callable);
            Future future = object.invokeAll(stringArray, n2, timeUnit).get(0);
            if ((Integer)future.get() == 0) {
                String string2 = OSUtil.a(process.getInputStream());
                return string2;
            }
            try {
                throw new IOException("Call to '" + string + "' exited with " + process.exitValue() + ": " + OSUtil.a(process.getErrorStream()));
            }
            catch (InterruptedException interruptedException) {
                throw new CancellationException("Call to '" + string + "' interrupted.");
            }
            catch (ExecutionException executionException) {
                throw new IOException("Failed", executionException);
            }
            catch (CancellationException cancellationException) {
                throw new CancellationException("Call to '" + string + "' timed out.");
            }
        }
        finally {
            object.shutdown();
        }
    }

    public static int getDefaultExecTimeout() {
        return Be;
    }

    public static String getDomainNameFromOs() throws IOException {
        String string = "";
        if (OSUtil.isWindows()) {
            string = OSUtil.eCR();
        } else if (OSUtil.isLinux()) {
            string = OSUtil.exec("hostname -d");
        } else if (OSUtil.isMacOs()) {
            string = OSUtil.exec("scutil --dns | sed -n -e '/^domain/s/.*: *//p' | head -1");
        }
        return string.trim();
    }

    public static String getHostNameWithDomain() {
        try {
            if (OSUtil.isAndroid()) {
                return OSUtil.getLocalHostName();
            }
            if (OSUtil.isWindows()) {
                String string;
                try {
                    string = OSUtil.getDomainNameFromOs();
                }
                catch (IOException iOException) {
                    logger.debug("Cannot resolve windows domain name, falling back to regular hostname search", iOException);
                    string = "";
                }
                if (string.isEmpty()) {
                    return OSUtil.hostname();
                }
                return OSUtil.hostname() + "." + string;
            }
            return OSUtil.hostname();
        }
        catch (IOException iOException) {
            return OSUtil.getLocalHostName();
        }
    }

    public static String getHostNameWithoutDomain() throws IOException {
        String string = OSUtil.hostname();
        string = string.split("\\.")[0];
        return string;
    }

    public static String getLocalCanonicalHostName() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug("getLocalCanonicalHostName", unknownHostException);
            return "locahost";
        }
        String string = inetAddress.getCanonicalHostName();
        logger.debug("Localhost.getCanonicalHostName {}", (Object)string);
        return string;
    }

    public static String getLocalHostName() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug("getLocalHostName", unknownHostException);
            return "localhost";
        }
        String string = inetAddress.getHostName();
        logger.debug("Localhost.getHostName: {}", (Object)string);
        return string;
    }

    public static String getOsName() {
        return osName;
    }

    public static boolean isAndroid() {
        return aE;
    }

    public static boolean isLinux() {
        return OSUtil.getOsName().contains("linux");
    }

    public static boolean isMacOs() {
        return OSUtil.getOsName().contains("mac os");
    }

    public static boolean isWindows() {
        return OSUtil.getOsName().contains("windows");
    }

    public static void setDefaultExecTimeout(int n2) {
        Be = n2;
    }

    private static String a(InputStream inputStream) throws IOException {
        try {
            Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());
            try {
                scanner.useDelimiter("\\A");
                String string = scanner.hasNext() ? scanner.next().trim() : "";
                scanner.close();
                return string;
            }
            catch (Throwable throwable) {
                scanner.close();
                throw throwable;
            }
        }
        finally {
            inputStream.close();
        }
    }

    protected static List<String> getHostNamesFromNetworkInterfaces(boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isPointToPoint()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!bl2 && !(inetAddress instanceof Inet4Address)) continue;
                    if (bl || !inetAddress.getHostName().contains(inetAddress.getHostAddress())) {
                        arrayList.add(inetAddress.getHostName());
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(networkInterface.getName() + ": address=" + inetAddress.getHostAddress() + " Hostname=" + arrayList + " CanonicalHostname=" + inetAddress.getCanonicalHostName() + " - Loopback=" + networkInterface.isLoopback() + " PointToPoint=" + networkInterface.isPointToPoint() + " Multicast: " + networkInterface.supportsMulticast());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return arrayList;
    }

    static String hostname() throws IOException {
        if (OSUtil.isWindows()) {
            return OSUtil.exec("hostname");
        }
        try {
            return OSUtil.exec("hostname -f");
        }
        catch (IOException iOException) {
            return OSUtil.exec("hostname");
        }
    }

    static String aw(String string) {
        if (string.trim().isEmpty()) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String stringArray2 : Arrays.asList(string.split("\\r?\\n|\\r"))) {
            arrayList.add(stringArray2.trim());
        }
        Object object = "";
        for (String string2 : arrayList) {
            if (!string2.startsWith("Domain")) continue;
            object = string2;
            break;
        }
        if (((String)object).isEmpty()) {
            return "";
        }
        String[] stringArray = ((String)object).split("\\s+");
        if (stringArray.length == 3) {
            return stringArray[2];
        }
        return "";
    }

    static String eCR() throws IOException {
        String string = OSUtil.eCS();
        return OSUtil.aw(string);
    }

    static String eCS() throws IOException {
        return OSUtil.exec("reg query HKLM\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters /v Domain");
    }

    static {
        Be = 5;
        logger = LoggerFactory.getLogger(OSUtil.class);
        osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        aE = System.getProperty("java.vendor").toLowerCase(Locale.ROOT).contains("android");
    }
}

