/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AnonymousIdentityToken;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.IssuedIdentityToken;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserNameIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.core.X509IdentityToken;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferUtils;
import java.lang.reflect.Array;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointUtil {
    private static Logger logger = LoggerFactory.getLogger(EndpointUtil.class);

    public static boolean containsSecureUserTokenPolicy(UserTokenPolicy[] userTokenPolicyArray) {
        if (userTokenPolicyArray != null) {
            for (UserTokenPolicy userTokenPolicy : userTokenPolicyArray) {
                if (userTokenPolicy.getSecurityPolicyUri() == null || userTokenPolicy.getSecurityPolicyUri().equals(SecurityPolicy.NONE.getPolicyUri())) continue;
                return true;
            }
        }
        return false;
    }

    public static UserIdentityToken createAnonymousIdentityToken(EndpointDescription endpointDescription) throws ServiceResultException {
        UserTokenPolicy userTokenPolicy = EndpointUtil.findUserTokenPolicy(endpointDescription, UserTokenType.Anonymous);
        if (userTokenPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_IdentityTokenRejected, "Anonymous UserTokenType is not supported");
        }
        return new AnonymousIdentityToken(userTokenPolicy.getPolicyId());
    }

    public static UserIdentityToken createIssuedIdentityToken(EndpointDescription endpointDescription, ByteString byteString, byte[] byArray) throws ServiceResultException {
        SecurityPolicy securityPolicy;
        UserTokenPolicy userTokenPolicy = EndpointUtil.findUserTokenPolicy(endpointDescription, UserTokenType.IssuedToken);
        if (userTokenPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_IdentityTokenRejected, "IssuedToken not supported");
        }
        String string = userTokenPolicy.getSecurityPolicyUri();
        if (string == null) {
            string = endpointDescription.getSecurityPolicyUri();
        }
        if ((securityPolicy = SecurityPolicy.getSecurityPolicy(string)) == null) {
            securityPolicy = SecurityPolicy.NONE;
        }
        IssuedIdentityToken issuedIdentityToken = new IssuedIdentityToken();
        issuedIdentityToken.setPolicyId(userTokenPolicy.getPolicyId());
        issuedIdentityToken.setTokenData(ByteString.valueOf(byArray));
        SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricEncryptionAlgorithm();
        if (securityAlgorithm == null) {
            securityAlgorithm = SecurityAlgorithm.RsaOaep;
        }
        try {
            Cipher cipher = Cipher.getInstance(securityAlgorithm.getStandardName());
            Cert cert = new Cert(ByteString.asByteArray(endpointDescription.getServerCertificate()));
            cipher.init(1, cert.getCertificate());
            byte[] byArray2 = byArray;
            if (byteString != null) {
                byArray2 = ByteBufferUtils.concatenate(EndpointUtil.y(byArray.length + byteString.getLength()), byArray, byteString.getValue());
            }
            issuedIdentityToken.setTokenData(ByteString.valueOf(cipher.doFinal(byArray2)));
            issuedIdentityToken.setEncryptionAlgorithm(securityAlgorithm.getUri());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + invalidKeyException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, illegalBlockSizeException.getClass().getName() + ":" + illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + badPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchPaddingException);
        }
        return issuedIdentityToken;
    }

    public static UserIdentityToken createUserNameIdentityToken(EndpointDescription endpointDescription, ByteString byteString, String string, String string2) throws ServiceResultException {
        SecurityPolicy securityPolicy;
        UserTokenPolicy userTokenPolicy = EndpointUtil.findUserTokenPolicy(endpointDescription, UserTokenType.UserName);
        if (userTokenPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_IdentityTokenRejected, "UserName not supported");
        }
        String string3 = userTokenPolicy.getSecurityPolicyUri();
        if (string3 == null) {
            string3 = endpointDescription.getSecurityPolicyUri();
        }
        if ((securityPolicy = SecurityPolicy.getSecurityPolicy(string3)) == null) {
            securityPolicy = SecurityPolicy.NONE;
        }
        UserNameIdentityToken userNameIdentityToken = new UserNameIdentityToken();
        userNameIdentityToken.setUserName(string);
        userNameIdentityToken.setPolicyId(userTokenPolicy.getPolicyId());
        SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricEncryptionAlgorithm();
        logger.debug("createUserNameIdentityToken: algorithm={}", (Object)securityAlgorithm);
        byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        if (securityAlgorithm == null) {
            userNameIdentityToken.setPassword(ByteString.valueOf(byArray));
        } else {
            try {
                Cert cert;
                byte[] byArray2 = ByteString.asByteArray(endpointDescription.getServerCertificate());
                Cert cert2 = cert = byArray2 == null || byArray2.length == 0 ? null : new Cert(byArray2);
                if (cert == null) {
                    throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "The Server Certificate was null. To enable activating a Session with Username/Password, the Server must provide a Server Certificate that is used for encrypting the password.");
                }
                byArray = byteString != null ? ByteBufferUtils.concatenate(EndpointUtil.y(byArray.length + byteString.getLength()), byArray, byteString.getValue()) : ByteBufferUtils.concatenate(EndpointUtil.y(byArray.length), byArray);
                byArray = CryptoUtil.encryptAsymm(byArray, cert.getCertificate().getPublicKey(), securityAlgorithm);
                userNameIdentityToken.setPassword(ByteString.valueOf(byArray));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + invalidKeyException.getMessage());
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, illegalBlockSizeException.getClass().getName() + ":" + illegalBlockSizeException.getMessage());
            }
            catch (BadPaddingException badPaddingException) {
                throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + badPaddingException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchAlgorithmException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchPaddingException);
            }
            userNameIdentityToken.setEncryptionAlgorithm(securityAlgorithm.getUri());
        }
        return userNameIdentityToken;
    }

    public static X509IdentityToken createX509IdentityToken(EndpointDescription endpointDescription, ByteString byteString, Cert cert, PrivateKey privateKey, SignatureData signatureData) throws ServiceResultException {
        Cert cert2;
        if (signatureData == null) {
            throw new NullPointerException("signatureData must be defined (will be filled in)");
        }
        UserTokenPolicy userTokenPolicy = EndpointUtil.findUserTokenPolicy(endpointDescription, UserTokenType.Certificate);
        if (userTokenPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_IdentityTokenRejected, "Certificate UserTokenType is not supported");
        }
        X509IdentityToken x509IdentityToken = new X509IdentityToken(userTokenPolicy.getPolicyId(), ByteString.valueOf(cert.getEncoded()));
        String string = userTokenPolicy.getSecurityPolicyUri();
        if (string == null) {
            string = endpointDescription.getSecurityPolicyUri();
        }
        SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(string);
        Cert cert3 = cert2 = endpointDescription.getServerCertificate() != null ? new Cert(ByteString.asByteArray(endpointDescription.getServerCertificate())) : null;
        if (cert2 == null) {
            throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Signature generation failed: The Server Certificate was null. To enable activating a Session with X509IdentityToken, the Server must provide a Server Certificate for generating the UserTokenSignature.");
        }
        if (securityPolicy != null && cert2 != null) {
            try {
                Signature signature = Signature.getInstance(securityPolicy.getAsymmetricSignatureAlgorithm().getTransformation());
                signature.initSign(privateKey);
                signature.update(cert2.getEncoded());
                if (byteString != null) {
                    signature.update(byteString.getValue());
                }
                signatureData.setSignature(ByteString.valueOf(signature.sign()));
                signatureData.setAlgorithm(securityPolicy.getAsymmetricSignatureAlgorithm().getUri());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Signature generation failed: " + noSuchAlgorithmException.getMessage());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + invalidKeyException.getMessage());
            }
            catch (SignatureException signatureException) {
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Signature generation failed: " + signatureException.getMessage());
            }
        }
        return x509IdentityToken;
    }

    public static UserTokenPolicy findUserTokenPolicy(EndpointDescription endpointDescription, String string) {
        if (endpointDescription.getUserIdentityTokens() == null) {
            return null;
        }
        for (UserTokenPolicy userTokenPolicy : endpointDescription.getUserIdentityTokens()) {
            String string2;
            if (userTokenPolicy == null || (string2 = userTokenPolicy.getPolicyId()) == null || !string2.equals(string)) continue;
            return userTokenPolicy;
        }
        return null;
    }

    public static UserTokenPolicy findUserTokenPolicy(EndpointDescription endpointDescription, UserTokenType userTokenType) {
        if (endpointDescription.getUserIdentityTokens() == null) {
            return null;
        }
        for (UserTokenPolicy userTokenPolicy : endpointDescription.getUserIdentityTokens()) {
            try {
                String string = userTokenPolicy.getSecurityPolicyUri();
                SecurityPolicy.getSecurityPolicy(string);
            }
            catch (ServiceResultException serviceResultException) {
                continue;
            }
            if (userTokenPolicy.getTokenType() != userTokenType) continue;
            return userTokenPolicy;
        }
        return null;
    }

    public static String getHostname() throws SocketException {
        Object object;
        try {
            object = InetAddress.getLocalHost().getHostName();
            if (object != null) {
                return object;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        object = EndpointUtil.getInetAddresses();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string;
            InetAddress inetAddress = (InetAddress)iterator.next();
            String string2 = inetAddress.getHostAddress();
            if (string2.equals(string = EndpointUtil.inetAddressToName(inetAddress))) continue;
            return string;
        }
        return "localhost";
    }

    public static Set<InetAddress> getInetAddresses() throws SocketException {
        return EndpointUtil.getInetAddresses(false);
    }

    public static Set<InetAddress> getInetAddresses(boolean bl) throws SocketException {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress instanceof Inet6Address && !bl) continue;
                hashSet.add(inetAddress);
            }
        }
        return hashSet;
    }

    public static Set<String> getInetAddressNames() throws SocketException {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress instanceof Inet6Address) continue;
                hashSet.add(EndpointUtil.inetAddressToName(inetAddress));
            }
        }
        return hashSet;
    }

    public static String inetAddressToName(InetAddress inetAddress) {
        String string;
        String string2 = inetAddress.getHostName();
        boolean bl = !string2.equals(string = inetAddress.getHostAddress());
        boolean bl2 = inetAddress instanceof Inet6Address;
        if (bl) {
            return string2;
        }
        if (bl2) {
            return "[" + string + "]";
        }
        return string;
    }

    public static boolean needsCertificate(EndpointDescription endpointDescription) {
        return endpointDescription.getSecurityMode() != MessageSecurityMode.None || EndpointUtil.containsSecureUserTokenPolicy(endpointDescription.getUserIdentityTokens());
    }

    public static void reverse(Object object) {
        int n2 = Array.getLength(object);
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            Object object2 = Array.get(object, i2);
            Object object3 = Array.get(object, n2 - 1 - i2);
            Array.set(object, i2, object3);
            Array.set(object, n2 - i2 - 1, object2);
        }
    }

    public static EndpointDescription select(EndpointDescription[] endpointDescriptionArray) throws ServiceResultException {
        EndpointDescription[] endpointDescriptionArray2 = EndpointUtil.selectByProtocol(endpointDescriptionArray, "opc.tcp");
        if (endpointDescriptionArray2.length != 0) {
            endpointDescriptionArray2 = EndpointUtil.sortBySecurityLevel(endpointDescriptionArray2);
            return endpointDescriptionArray2[endpointDescriptionArray2.length - 1];
        }
        endpointDescriptionArray2 = EndpointUtil.selectByProtocol(endpointDescriptionArray, "https");
        if (endpointDescriptionArray2.length != 0) {
            return endpointDescriptionArray2[0];
        }
        throw new ServiceResultException("No compatible endpoint was found");
    }

    public static EndpointDescription[] select(EndpointDescription[] endpointDescriptionArray, int n2, int n3) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            try {
                Cert cert = new Cert(ByteString.asByteArray(endpointDescription.getServerCertificate()));
                int n4 = cert.getKeySize();
                if (n4 < n2 || n4 > n3) continue;
                arrayList.add(endpointDescription);
            }
            catch (ServiceResultException serviceResultException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription select(EndpointDescription[] endpointDescriptionArray, String string) throws ServiceResultException {
        EndpointDescription[] endpointDescriptionArray2 = EndpointUtil.select(endpointDescriptionArray, string, null, null, null, null);
        if (endpointDescriptionArray2.length > 0) {
            return EndpointUtil.select(endpointDescriptionArray2);
        }
        String string2 = UriUtil.getTransportProtocol(string);
        EndpointDescription[] endpointDescriptionArray3 = EndpointUtil.select(endpointDescriptionArray, null, string2, null, null, null);
        if (endpointDescriptionArray3.length > 0) {
            return EndpointUtil.select(endpointDescriptionArray3);
        }
        return EndpointUtil.select(endpointDescriptionArray);
    }

    public static EndpointDescription[] select(EndpointDescription[] endpointDescriptionArray, String string, String string2, MessageSecurityMode messageSecurityMode, SecurityPolicy securityPolicy, byte[] byArray) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            String string3;
            String string4 = string3 = endpointDescription.getEndpointUrl() == null ? null : endpointDescription.getEndpointUrl().toLowerCase(Locale.ROOT);
            if (string3 == null || string2 != null && !string3.startsWith(string2.toLowerCase(Locale.ROOT)) || string != null && !Objects.equals(string3, string.toLowerCase(Locale.ROOT)) || messageSecurityMode != null && !Objects.equals(endpointDescription.getSecurityMode(), messageSecurityMode) || securityPolicy != null && !Objects.equals(endpointDescription.getSecurityPolicyUri(), securityPolicy.getPolicyUri()) || byArray != null && !Arrays.equals(byArray, ByteString.asByteArray(endpointDescription.getServerCertificate()))) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] selectByMessageSecurityMode(EndpointDescription[] endpointDescriptionArray, MessageSecurityMode messageSecurityMode) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            if (endpointDescription.getSecurityMode() != messageSecurityMode) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] selectByProtocol(EndpointDescription[] endpointDescriptionArray, String string) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            if (!endpointDescription.getEndpointUrl().toLowerCase(Locale.ROOT).startsWith(string.toLowerCase(Locale.ROOT))) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] selectBySecurityPolicy(EndpointDescription[] endpointDescriptionArray, SecurityPolicy securityPolicy) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            if (!Objects.equals(endpointDescription.getSecurityPolicyUri(), securityPolicy.getPolicyUri())) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] selectByUrl(EndpointDescription[] endpointDescriptionArray, String string) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            if (!string.equalsIgnoreCase(endpointDescription.getEndpointUrl())) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription selectEndpoint(EndpointDescription[] endpointDescriptionArray) {
        if (endpointDescriptionArray == null) {
            throw new IllegalArgumentException("null arg");
        }
        endpointDescriptionArray = EndpointUtil.selectByProtocol(endpointDescriptionArray, "opc.tcp");
        if ((endpointDescriptionArray = EndpointUtil.selectByMessageSecurityMode(endpointDescriptionArray, MessageSecurityMode.SignAndEncrypt)).length == 0) {
            return null;
        }
        endpointDescriptionArray = EndpointUtil.sortBySecurityLevel(endpointDescriptionArray);
        EndpointUtil.reverse(endpointDescriptionArray);
        return endpointDescriptionArray[0];
    }

    public static EndpointDescription[] sortBySecurityLevel(EndpointDescription[] endpointDescriptionArray) {
        Comparator<EndpointDescription> comparator = new Comparator<EndpointDescription>(){

            public int a(EndpointDescription endpointDescription, EndpointDescription endpointDescription2) {
                return endpointDescription.getSecurityLevel().intValue() - endpointDescription2.getSecurityLevel().intValue();
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((EndpointDescription)object, (EndpointDescription)object2);
            }
        };
        EndpointDescription[] endpointDescriptionArray2 = (EndpointDescription[])endpointDescriptionArray.clone();
        Arrays.sort(endpointDescriptionArray2, comparator);
        return endpointDescriptionArray2;
    }

    public static boolean supportsUserTokenType(EndpointDescription endpointDescription, UserTokenType userTokenType) {
        return EndpointUtil.findUserTokenPolicy(endpointDescription, userTokenType) != null;
    }

    public static List<SocketAddress> toSocketAddresses(String string) throws IllegalArgumentException {
        return EndpointUtil.toSocketAddresses(string, false);
    }

    public static List<SocketAddress> toSocketAddresses(String string, boolean bl) throws IllegalArgumentException {
        Object[] objectArray;
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>();
        if (string == null) {
            throw new IllegalArgumentException("URL not valid.");
        }
        UaAddress uaAddress = UaAddress.parse(string);
        String string2 = UriUtil.getTransportProtocol(string);
        String string3 = uaAddress.getHost();
        int n2 = uaAddress.getPort();
        if (string3 == null) {
            objectArray = string.split("/+");
            String[] stringArray = objectArray[1].split(":");
            string3 = stringArray[0];
            try {
                n2 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n2 = 0;
            }
        }
        string2 = string2.toLowerCase(Locale.ROOT);
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("Port number is not in range 0-65525, was: " + n2);
        }
        if (string2.equals("opc.tcp") || string2.equals("http") || string2.equals("opc.https")) {
            try {
                objectArray = InetAddress.getAllByName(string3);
                boolean bl2 = false;
                boolean bl3 = false;
                for (Object object : objectArray) {
                    bl2 |= object instanceof Inet4Address;
                    bl3 |= object instanceof Inet6Address;
                }
                for (Object object : objectArray) {
                    boolean bl4 = object instanceof Inet6Address;
                    if (!bl && bl4 && bl3 && bl2) {
                        logger.warn("Binding of {} to {} was omited. (Workaround)", (Object)string, (Object)((InetAddress)object).getHostAddress());
                        continue;
                    }
                    InetSocketAddress inetSocketAddress = new InetSocketAddress((InetAddress)object, n2);
                    arrayList.add(inetSocketAddress);
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException(unknownHostException);
            }
        } else {
            throw new IllegalArgumentException("Unsupported protocol " + string2);
        }
        return arrayList;
    }

    public static boolean urlEqualsHostIgnoreCase(String string, String string2) {
        try {
            UaAddress uaAddress = UaAddress.parse(string);
            UaAddress uaAddress2 = UaAddress.parse(string2);
            if (uaAddress.getProtocol() != uaAddress2.getProtocol()) {
                return false;
            }
            if (uaAddress.getPort() != uaAddress2.getPort()) {
                return false;
            }
            return uaAddress.getServerName().equalsIgnoreCase(uaAddress2.getServerName());
        }
        catch (Exception exception) {
            logger.debug("Failure in converting {} or {} to a valid OPC UA Address", string, string2, exception);
            return false;
        }
    }

    @Deprecated
    public static boolean urlEqualsHostIgnoreCase(URI uRI, URI uRI2) {
        return uRI.getScheme().equalsIgnoreCase(uRI2.getScheme()) && uRI.getPort() == uRI2.getPort() && uRI.getPath().equalsIgnoreCase(uRI2.getPath());
    }

    public static boolean urlEqualsProtocolAndServerNameIgnoringCase(String string, String string2) {
        try {
            UaAddress uaAddress = UaAddress.parse(string);
            UaAddress uaAddress2 = UaAddress.parse(string2);
            if (uaAddress.getProtocol() != uaAddress2.getProtocol()) {
                return false;
            }
            return uaAddress.getServerName().equalsIgnoreCase(uaAddress2.getServerName());
        }
        catch (Exception exception) {
            logger.debug("Failure in converting {} or {} to a valid OPC UA Address", string, string2, exception);
            return false;
        }
    }

    private static byte[] y(int n2) {
        return new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
    }
}

