/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.transport.security.BcCertificateProvider;
import com.prosysopc.ua.stack.transport.security.BcFipsCertificateProvider;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateProvider;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.ScCertificateProvider;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    public static final int DEFAULT_KEY_SIZE = 2048;
    private static final int DNS = 2;
    private static final int NAME_URI = 6;
    private static final int IP = 7;
    private static Logger logger = LoggerFactory.getLogger(CertificateUtils.class);
    private static int keySize = 2048;
    private static String AJ = "SHA256WithRSA";
    private static final String AK = "com.prosysopc.ua.stack.transport.security.ScCertificateProvider";
    private static final String AL = "com.prosysopc.ua.stack.transport.security.BcCertificateProvider";
    private static final String AM = "com.prosysopc.ua.stack.transport.security.BcFipsCertificateProvider";
    private static CertificateProvider AN;

    public static byte[] base64Decode(String string) {
        return CertificateUtils.getCertificateProvider().base64Decode(string);
    }

    public static String base64Encode(byte[] byArray) {
        return CertificateUtils.getCertificateProvider().base64Encode(byArray);
    }

    public static com.prosysopc.ua.stack.transport.security.KeyPair createApplicationInstanceCertificate(String string, String string2, String string3, int n2, com.prosysopc.ua.stack.transport.security.KeyPair keyPair, int n3, String ... stringArray) throws IOException, GeneralSecurityException {
        if (string3 == null) {
            throw new NullPointerException("applicationUri must not be null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("createApplicationInstanceCertificate: getProviders={}", (Object)Arrays.toString(Security.getProviders()));
        }
        KeyPair keyPair2 = CertificateUtils.w(n3);
        String string4 = "CN=" + string + (string2 == null ? "" : ", O=" + string2) + (stringArray == null || stringArray.length == 0 ? "" : ", DC=" + stringArray[0]);
        X509Certificate x509Certificate = CertificateUtils.a(string4, n2, string3, keyPair2, keyPair, stringArray);
        return CertificateUtils.toKeyPair(x509Certificate, keyPair2.getPrivate());
    }

    @Deprecated
    public static com.prosysopc.ua.stack.transport.security.KeyPair createApplicationInstanceCertificate(String string, String string2, String string3, int n2, com.prosysopc.ua.stack.transport.security.KeyPair keyPair, String ... stringArray) throws IOException, GeneralSecurityException {
        if (string3 == null) {
            throw new NullPointerException("applicationUri must not be null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("createApplicationInstanceCertificate: getProviders={}", (Object)Arrays.toString(Security.getProviders()));
        }
        KeyPair keyPair2 = CertificateUtils.generateKeyPair();
        String string4 = "CN=" + string + (string2 == null ? "" : ", O=" + string2) + (stringArray == null || stringArray.length == 0 ? "" : ", DC=" + stringArray[0]);
        X509Certificate x509Certificate = CertificateUtils.a(string4, n2, string3, keyPair2, keyPair, stringArray);
        return CertificateUtils.toKeyPair(x509Certificate, keyPair2.getPrivate());
    }

    public static com.prosysopc.ua.stack.transport.security.KeyPair createApplicationInstanceCertificate(String string, String string2, String string3, int n2, int n3, String ... stringArray) throws IOException, GeneralSecurityException {
        return CertificateUtils.createApplicationInstanceCertificate(string, string2, string3, n2, null, n3, stringArray);
    }

    @Deprecated
    public static com.prosysopc.ua.stack.transport.security.KeyPair createApplicationInstanceCertificate(String string, String string2, String string3, int n2, String ... stringArray) throws IOException, GeneralSecurityException {
        return CertificateUtils.createApplicationInstanceCertificate(string, string2, string3, n2, null, stringArray);
    }

    @Deprecated
    public static com.prosysopc.ua.stack.transport.security.KeyPair createHttpsCertificate(String string, String string2, int n2, com.prosysopc.ua.stack.transport.security.KeyPair keyPair) throws IOException, GeneralSecurityException {
        if (string2 == null) {
            throw new NullPointerException("applicationUri must not be null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("createApplicationInstanceCertificate: getProviders={}", (Object)Arrays.toString(Security.getProviders()));
        }
        KeyPair keyPair2 = CertificateUtils.generateKeyPair();
        X509Certificate x509Certificate = CertificateUtils.a("CN=" + string, n2, string2, keyPair2.getPublic(), keyPair2.getPrivate(), keyPair, new String[0]);
        return CertificateUtils.toKeyPair(x509Certificate, keyPair2.getPrivate());
    }

    public static com.prosysopc.ua.stack.transport.security.KeyPair createHttpsCertificate(String string, String string2, int n2, com.prosysopc.ua.stack.transport.security.KeyPair keyPair, int n3) throws IOException, GeneralSecurityException {
        if (string2 == null) {
            throw new NullPointerException("applicationUri must not be null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("createApplicationInstanceCertificate: getProviders={}", (Object)Arrays.toString(Security.getProviders()));
        }
        KeyPair keyPair2 = CertificateUtils.w(n3);
        X509Certificate x509Certificate = CertificateUtils.a("CN=" + string, n2, string2, keyPair2.getPublic(), keyPair2.getPrivate(), keyPair, new String[0]);
        return CertificateUtils.toKeyPair(x509Certificate, keyPair2.getPrivate());
    }

    @Deprecated
    public static com.prosysopc.ua.stack.transport.security.KeyPair createIssuerCertificate(String string, int n2, com.prosysopc.ua.stack.transport.security.KeyPair keyPair) throws GeneralSecurityException, IOException {
        KeyPair keyPair2 = CertificateUtils.generateKeyPair();
        Instant instant = CertificateUtils.eCO();
        Instant instant2 = CertificateUtils.x(n2);
        BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
        if (!string.startsWith("CN=")) {
            string = "CN=" + string;
        }
        X509Certificate x509Certificate = CertificateUtils.getCertificateProvider().generateIssuerCert(keyPair2.getPublic(), keyPair2.getPrivate(), keyPair, string, bigInteger, instant, instant2);
        return CertificateUtils.toKeyPair(x509Certificate, keyPair2.getPrivate());
    }

    public static com.prosysopc.ua.stack.transport.security.KeyPair createIssuerCertificate(String string, int n2, com.prosysopc.ua.stack.transport.security.KeyPair keyPair, int n3) throws GeneralSecurityException, IOException {
        KeyPair keyPair2 = CertificateUtils.w(n3);
        Instant instant = CertificateUtils.eCO();
        Instant instant2 = CertificateUtils.x(n2);
        BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
        if (!string.startsWith("CN=")) {
            string = "CN=" + string;
        }
        X509Certificate x509Certificate = CertificateUtils.getCertificateProvider().generateIssuerCert(keyPair2.getPublic(), keyPair2.getPrivate(), keyPair, string, bigInteger, instant, instant2);
        return CertificateUtils.toKeyPair(x509Certificate, keyPair2.getPrivate());
    }

    public static byte[] createThumbprint(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
    }

    public static RSAPrivateKey decodePKCS8EncodedRSAPrivateKey(ByteString byteString) throws Exception {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byteString.getValue());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", CryptoUtil.getSecurityProviderName(KeyFactory.class));
            return (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            logger.error("Could not read private key with security provider name: {}", (Object)CryptoUtil.getSecurityProviderName(KeyFactory.class));
            throw new RuntimeException("Could not read private key with provider " + CryptoUtil.getSecurityProviderName(KeyFactory.class), noSuchProviderException);
        }
    }

    public static X509Certificate decodeX509Certificate(byte[] byArray) throws CertificateException {
        try {
            if (byArray == null) {
                throw new IllegalArgumentException("null arg");
            }
            CertificateUtils.getCertificateProvider();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", CryptoUtil.getSecurityProviderName());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            byteArrayInputStream.close();
            return x509Certificate;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException);
        }
    }

    public static String getApplicationUriOfCertificate(Cert cert) throws CertificateParsingException {
        return CertificateUtils.getApplicationUriOfCertificate(cert.getCertificate());
    }

    public static String getApplicationUriOfCertificate(X509Certificate x509Certificate) throws CertificateParsingException {
        Collection<List<?>> collection = CertificateUtils.getSubjectAlternativeNames(x509Certificate);
        if (collection != null) {
            for (List<?> list : collection) {
                int n2 = (Integer)list.get(0);
                if (n2 != 6) continue;
                String string = (String)list.get(1);
                return string;
            }
        }
        return "";
    }

    public static CertificateProvider getCertificateProvider() {
        if (AN == null) {
            if ("SC".equals(CryptoUtil.getSecurityProviderName())) {
                try {
                    AN = new ScCertificateProvider();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Cannot init com.prosysopc.ua.stack.transport.security.ScCertificateProvider", exception);
                }
            } else if ("BC".equals(CryptoUtil.getSecurityProviderName())) {
                try {
                    AN = new BcFipsCertificateProvider();
                    CryptoUtil.setSecurityProviderName("BCFIPS");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        AN = new BcCertificateProvider();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Cannot init com.prosysopc.ua.stack.transport.security.BcCertificateProvider or com.prosysopc.ua.stack.transport.security.BcFipsCertificateProvider", exception);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Cannot init com.prosysopc.ua.stack.transport.security.BcFipsCertificateProvider", exception);
                }
            } else if ("BCFIPS".equals(CryptoUtil.getSecurityProviderName())) {
                try {
                    AN = new BcFipsCertificateProvider();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Cannot init com.prosysopc.ua.stack.transport.security.BcFipsCertificateProvider", exception);
                }
            } else {
                throw new RuntimeException("NO CRYPTO PROVIDER AVAILABLE!");
            }
        }
        return AN;
    }

    public static String getCertificateSignatureAlgorithm() {
        return AJ;
    }

    public static List<String> getDnsOfCertificate(Cert cert) throws CertificateParsingException {
        return CertificateUtils.getDnsOfCertificate(cert.getCertificate());
    }

    public static List<String> getDnsOfCertificate(X509Certificate x509Certificate) throws CertificateParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<List<?>> collection = CertificateUtils.getSubjectAlternativeNames(x509Certificate);
        if (collection != null) {
            for (List<?> list : collection) {
                int n2 = (Integer)list.get(0);
                if (n2 != 2) continue;
                String string = (String)list.get(1);
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static List<String> getIpOfCertificate(Cert cert) throws CertificateParsingException {
        return CertificateUtils.getIpOfCertificate(cert.getCertificate());
    }

    public static List<String> getIpOfCertificate(X509Certificate x509Certificate) throws CertificateParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<List<?>> collection = CertificateUtils.getSubjectAlternativeNames(x509Certificate);
        if (collection != null) {
            for (List<?> list : collection) {
                int n2 = (Integer)list.get(0);
                if (n2 != 7) continue;
                Object obj = list.get(1);
                if (obj instanceof byte[]) {
                    byte[] byArray = (byte[])obj;
                    String string = "";
                    for (int i2 = 0; i2 < byArray.length; ++i2) {
                        string = string + (byArray[i2] < 0 ? 256 + byArray[i2] : byArray[i2]) + (i2 + 1 < byArray.length ? "." : "");
                    }
                    arrayList.add(string);
                    continue;
                }
                if (obj instanceof String) {
                    logger.warn("Value for IP was String instead of byte[], value: {}", obj);
                    arrayList.add((String)obj);
                    continue;
                }
                if (obj == null) {
                    logger.warn("Value for IP was null");
                    continue;
                }
                logger.warn("Value for IP had unexpected Java class: {}", (Object)obj.getClass());
            }
        }
        return arrayList;
    }

    @Deprecated
    public static int getKeySize() {
        return keySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPrivateKey loadFromKeyStore(URL uRL, String string) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        logger.debug("loadFromKeyStore: keystoreUrl={}", (Object)uRL);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            Object object;
            KeyStore keyStore;
            if (logger.isDebugEnabled()) {
                logger.debug("getproviders={}", (Object)Arrays.toString(Security.getProviders()));
            }
            try {
                try {
                    keyStore = KeyStore.getInstance("PKCS12", "SunJSSE");
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    keyStore = KeyStore.getInstance("PKCS12", CryptoUtil.getSecurityProviderName(KeyStore.class));
                }
            }
            catch (NoSuchProviderException noSuchProviderException) {
                keyStore = KeyStore.getInstance("PKCS12");
            }
            logger.debug("loadFromKeyStore: keyStore Provider={}", (Object)keyStore.getProvider());
            keyStore.load(inputStream, string == null ? null : string.toCharArray());
            Enumeration<String> enumeration = keyStore.aliases();
            Key key = null;
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                key = keyStore.getKey((String)object, string == null ? null : string.toCharArray());
            }
            object = (RSAPrivateKey)key;
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    public static com.prosysopc.ua.stack.transport.security.KeyPair loadKeyPairFromProtectedStore(String string, String string2, String string3, String string4) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = null;
        keyStore = KeyStore.getInstance("JKS");
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        keyStore.load(fileInputStream, string3.toCharArray());
        fileInputStream.close();
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyStore.getKey(string2, string4.toCharArray());
        return new com.prosysopc.ua.stack.transport.security.KeyPair(new Cert(x509Certificate), new PrivKey(rSAPrivateKey));
    }

    public static PrivateKey readPrivateKey(File file, String string, String string2) throws IOException {
        return CertificateUtils.readPrivateKey(new BufferedInputStream(new FileInputStream(file)), string, string2);
    }

    public static PrivateKey readPrivateKey(InputStream inputStream, String string, String string2) throws IOException {
        return CertificateUtils.getCertificateProvider().readPrivateKey(inputStream, string, string2);
    }

    public static X509Certificate readX509Certificate(File file) throws IOException, CertificateException {
        return CertificateUtils.readX509Certificate(file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate readX509Certificate(URL uRL) throws IOException, CertificateException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            return x509Certificate;
        }
        finally {
            inputStream.close();
        }
    }

    public static com.prosysopc.ua.stack.transport.security.KeyPair renewApplicationInstanceCertificate(String string, String string2, String string3, int n2, com.prosysopc.ua.stack.transport.security.KeyPair keyPair, com.prosysopc.ua.stack.transport.security.KeyPair keyPair2, String ... stringArray) throws IOException, IllegalStateException, GeneralSecurityException {
        if (string3 == null) {
            throw new NullPointerException("applicationUri must not be null");
        }
        PublicKey publicKey = keyPair.getCertificate().getCertificate().getPublicKey();
        RSAPrivateKey rSAPrivateKey = keyPair.getPrivateKey().getPrivateKey();
        X509Certificate x509Certificate = CertificateUtils.a("CN=" + string + (string2 == null ? "" : ", O=" + string2), n2, string3, new KeyPair(publicKey, rSAPrivateKey), keyPair2, stringArray);
        Cert cert = new Cert(x509Certificate);
        PrivKey privKey = new PrivKey(rSAPrivateKey);
        return new com.prosysopc.ua.stack.transport.security.KeyPair(cert, privKey);
    }

    public static com.prosysopc.ua.stack.transport.security.KeyPair renewApplicationInstanceCertificate(String string, String string2, String string3, int n2, com.prosysopc.ua.stack.transport.security.KeyPair keyPair, String ... stringArray) throws IOException, IllegalStateException, GeneralSecurityException {
        return CertificateUtils.renewApplicationInstanceCertificate(string, string2, string3, n2, keyPair, null, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveKeyPairToProtectedStore(com.prosysopc.ua.stack.transport.security.KeyPair keyPair, String string, String string2, String string3, String string4) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        keyStore = KeyStore.getInstance("JKS");
        File file = new File(string);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            keyStore.load(fileInputStream, string3.toCharArray());
        }
        catch (FileNotFoundException fileNotFoundException) {
            keyStore.load(null, null);
        }
        Certificate[] certificateArray = new Certificate[]{keyPair.certificate.getCertificate()};
        keyStore.setKeyEntry(string2, keyPair.privateKey.getPrivateKey(), string4.toCharArray(), certificateArray);
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
            keyStore.store(fileOutputStream, string3.toCharArray());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToProtectedStore(PrivateKey privateKey, Certificate certificate, File file, String string, String string2, String string3, String string4) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        keyStore = string4.equals("PKCS12") ? KeyStore.getInstance(string4, CryptoUtil.getSecurityProviderName(KeyStore.class)) : KeyStore.getInstance(string4);
        keyStore.load(null, null);
        Certificate[] certificateArray = new Certificate[]{certificate};
        if (string2 != null) {
            keyStore.setKeyEntry(string, privateKey, string2.toCharArray(), certificateArray);
        } else {
            keyStore.setKeyEntry(string, privateKey, null, certificateArray);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            keyStore.store(fileOutputStream, string3 == null ? null : string3.toCharArray());
        }
    }

    public static void setCertificateProvider(CertificateProvider certificateProvider) {
        AN = certificateProvider;
    }

    public static void setCertificateSignatureAlgorithm(String string) {
        AJ = string;
    }

    @Deprecated
    public static void setKeySize(int n2) {
        if (n2 < 1024 || n2 % 1024 != 0 || n2 > 4096) {
            throw new IllegalArgumentException("KeySize must be 1024, 2048, 3072 or 4096");
        }
        keySize = n2;
    }

    @Deprecated
    public static SignatureData sign(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        try {
            return CryptoUtil.signAsymm(privateKey, securityAlgorithm, byArray);
        }
        catch (ServiceResultException serviceResultException) {
            throw new SignatureException(serviceResultException);
        }
    }

    public static com.prosysopc.ua.stack.transport.security.KeyPair toKeyPair(X509Certificate x509Certificate, PrivateKey privateKey) throws CertificateEncodingException {
        Cert cert = new Cert(x509Certificate);
        PrivKey privKey = new PrivKey((RSAPrivateKey)privateKey);
        return new com.prosysopc.ua.stack.transport.security.KeyPair(cert, privKey);
    }

    @Deprecated
    public static boolean verify(X509Certificate x509Certificate, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            return CryptoUtil.verifyAsymm(x509Certificate, securityAlgorithm, byArray, byArray2);
        }
        catch (ServiceResultException serviceResultException) {
            throw new SignatureException(serviceResultException);
        }
    }

    public static void writePrivateKey(PrivateKey privateKey, File file, String string, String string2) throws IOException {
        CertificateUtils.writePrivateKey(privateKey, new FileOutputStream(file), string, string2);
    }

    public static void writePrivateKey(PrivateKey privateKey, OutputStream outputStream, String string, String string2) throws IOException {
        CertificateUtils.getCertificateProvider().writePrivateKey(privateKey, outputStream, string, string2);
    }

    public static void writeToPem(PrivateKey privateKey, File file, String string, String string2) throws IOException {
        CertificateUtils.writePrivateKey(privateKey, file, string, string2);
    }

    private static X509Certificate a(String string, int n2, String string2, KeyPair keyPair, com.prosysopc.ua.stack.transport.security.KeyPair keyPair2, String ... stringArray) throws GeneralSecurityException, IOException {
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        return CertificateUtils.a(string, n2, string2, publicKey, privateKey, keyPair2, stringArray);
    }

    private static X509Certificate a(String string, int n2, String string2, PublicKey publicKey, PrivateKey privateKey, com.prosysopc.ua.stack.transport.security.KeyPair keyPair, String ... stringArray) throws IOException, GeneralSecurityException {
        Instant instant = CertificateUtils.eCO();
        Instant instant2 = CertificateUtils.x(n2);
        BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
        return CertificateUtils.getCertificateProvider().generateCertificate(string, publicKey, privateKey, keyPair, instant, instant2, bigInteger, string2, stringArray);
    }

    @Deprecated
    private static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(CertificateUtils.getKeySize());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    private static KeyPair w(int n2) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n2);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    private static Instant x(int n2) {
        return Instant.now().plus((long)n2, ChronoUnit.DAYS);
    }

    private static Instant eCO() {
        return Instant.now().minus(1L, ChronoUnit.HOURS);
    }

    protected static Collection<List<?>> getSubjectAlternativeNames(X509Certificate x509Certificate) throws CertificateParsingException {
        return CertificateUtils.getCertificateProvider().getSubjectAlternativeNames(x509Certificate);
    }
}

