/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.server.ReverseConnectionParameters;
import com.prosysopc.ua.server.ReverseConnectionStatus;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.ConnectionMonitor;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ServerConnection;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.impl.ConnectionCollection;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServerConnection;
import com.prosysopc.ua.stack.transport.tcp.nio.a;
import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncServerSocket;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSocketImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcTcpServer
extends AbstractState<CloseableObjectState, ServiceResultException>
implements EndpointServer {
    static Logger logger = LoggerFactory.getLogger(OpcTcpServer.class);
    Application application;
    AtomicInteger vP = new AtomicInteger();
    EndpointBindingCollection endpointBindings = new EndpointBindingCollection();
    public Server discoveryServer;
    public EndpointBinding discoveryEndpointBinding;
    private int yX = 0;
    private boolean initialized = false;
    Map<SocketAddress, SocketHandle> wh = new HashMap<SocketAddress, SocketHandle>();
    AsyncServerSocket.ConnectListener zP = new AsyncServerSocket.ConnectListener(){

        @Override
        public void onConnected(AsyncServerSocket asyncServerSocket, AsyncSocketImpl asyncSocketImpl) {
            logger.info("{}: {} connected", (Object)OpcTcpServer.this, (Object)asyncSocketImpl.socket().getRemoteSocketAddress());
            final OpcTcpServerConnection opcTcpServerConnection = new OpcTcpServerConnection(OpcTcpServer.this, asyncSocketImpl);
            OpcTcpServer.this.vR.addConnection(opcTcpServerConnection);
            opcTcpServerConnection.addConnectionListener(new IConnectionListener(){

                @Override
                public void onClosed(ServiceResultException serviceResultException) {
                    OpcTcpServer.this.vR.removeConnection(opcTcpServerConnection);
                }

                @Override
                public void onOpen() {
                }
            });
            ArrayList<ServerConnection> arrayList = new ArrayList<ServerConnection>();
            OpcTcpServer.this.vR.getConnections(arrayList);
            logger.trace("Checking maximum number of connections, limit: {}, current: {}", (Object)OpcTcpServer.this.vs, (Object)arrayList.size());
            int n2 = arrayList.size() - OpcTcpServer.this.vs;
            if (n2 >= 0) {
                if (n2 == 0) {
                    n2 = 1;
                }
                logger.trace("We are at max or over limit, number of connections to purge if possible: {}", (Object)n2);
                int n3 = 0;
                for (ServerConnection serverConnection : arrayList) {
                    OpcTcpServerConnection opcTcpServerConnection2;
                    if (!(serverConnection instanceof OpcTcpServerConnection) || opcTcpServerConnection == (opcTcpServerConnection2 = (OpcTcpServerConnection)serverConnection) || !opcTcpServerConnection2.isPurgeEligible()) continue;
                    opcTcpServerConnection2.close();
                    if (++n3 < n2) continue;
                    break;
                }
                logger.trace("We are at max or over limit, purged {} old connections", (Object)n3);
            }
            ArrayList<ServerConnection> arrayList2 = new ArrayList<ServerConnection>();
            OpcTcpServer.this.vR.getConnections(arrayList2);
            if (arrayList2.size() > OpcTcpServer.this.vs) {
                logger.trace("We are at over limit, unable to purge enough old connections, closing this connection");
                opcTcpServerConnection.close();
            } else if (arrayList2.size() == OpcTcpServer.this.vs) {
                logger.trace("We are exactly at maximum connections (including this connection). No older connections could be purged. Keeping this connection open.");
                opcTcpServerConnection.init();
            } else {
                logger.trace("We are below maximum connection limit");
                opcTcpServerConnection.init();
            }
        }
    };
    ConnectionCollection vR = new ConnectionCollection(this);
    int vs;

    public OpcTcpServer(Application application) throws ServiceResultException {
        super(CloseableObjectState.Closed, CloseableObjectState.Closed);
        this.application = application;
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            this.discoveryServer = new Server(application);
            this.discoveryServer.setEndpointBindings(this.endpointBindings);
            this.discoveryEndpointBinding = new EndpointBinding(this, discoveryEndpoint, this.discoveryServer);
        }
        catch (IOException iOException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)iOException);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created (context: {}", (Object)System.identityHashCode(this));
        }
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.vR.addConnectionListener(connectListener);
    }

    @Override
    public EndpointServer.EndpointHandle bind(SocketAddress socketAddress, EndpointBinding endpointBinding) throws ServiceResultException {
        Object object;
        if (endpointBinding == null || socketAddress == null || endpointBinding.endpointServer != this) {
            throw new IllegalArgumentException();
        }
        this.init();
        String string = UriUtil.getTransportProtocol(endpointBinding.endpointAddress.getEndpointUrl());
        if (!"opc.tcp".equals(string)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind " + string + " to opc.tcp server");
        }
        SocketHandle socketHandle = this.a(socketAddress);
        if (socketHandle.vQ == null) {
            try {
                socketHandle.setChannel(ServerSocketChannel.open());
                socketHandle.getChannel().configureBlocking(false);
                socketHandle.vQ = new AsyncServerSocket(socketHandle.getChannel(), StackUtils.getBlockingWorkExecutor(), StackUtils.getSelector());
                if (!(socketHandle.getSocketAddress() instanceof InetSocketAddress)) {
                    throw new IllegalArgumentException("SocketHandle's socketAddress was not an InetSocketAddress");
                }
                object = (InetSocketAddress)socketHandle.getSocketAddress();
                if (((InetSocketAddress)object).getPort() == 0) {
                    for (Map.Entry<SocketAddress, SocketHandle> entry : this.wh.entrySet()) {
                        SocketHandle socketHandle2 = entry.getValue();
                        if (socketHandle2.getBoundSocketAddress() == null || !socketHandle2.eCK()) continue;
                        logger.info("Found SocketHandle address: {}, that was bound to 0 and OS gave: {} as the next free port", (Object)socketHandle2.getSocketAddress(), (Object)socketHandle2.getBoundSocketAddress().getPort());
                        object = new InetSocketAddress(((InetSocketAddress)object).getAddress(), socketHandle2.getBoundSocketAddress().getPort());
                        break;
                    }
                }
                socketHandle.vQ.bind((SocketAddress)object, 0);
                if (((InetSocketAddress)object).getPort() == 0) {
                    socketHandle.setBoundSocketAddress(new InetSocketAddress(((InetSocketAddress)object).getAddress(), socketHandle.vQ.socket().getLocalPort()));
                } else {
                    socketHandle.setBoundSocketAddress((InetSocketAddress)object);
                }
                logger.debug("For address: {}, using bind address: {}", (Object)socketAddress, (Object)socketHandle.getBoundSocketAddress());
                if (socketAddress instanceof InetSocketAddress && ((InetSocketAddress)socketAddress).getPort() == 0) {
                    endpointBinding.rewriteEndpointUrlPort(socketHandle.getBoundSocketAddress().getPort());
                }
                socketHandle.vQ.addListener(this.zP);
                logger.info("TCP/IP Socket bound to {}", (Object)(socketHandle.getBoundSocketAddress() != null ? socketHandle.getBoundSocketAddress() : socketHandle.getSocketAddress()));
            }
            catch (IOException iOException) {
                logger.error("Failed to bind address " + socketHandle.getSocketAddress(), iOException);
                socketHandle.close();
                throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)iOException);
            }
        }
        object = socketHandle.b(endpointBinding);
        return object;
    }

    @Override
    public a bindReverse(SocketAddress socketAddress, ReverseConnectionParameters reverseConnectionParameters, ScheduledExecutorService scheduledExecutorService) {
        return this.a(socketAddress, reverseConnectionParameters, null, scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OpcTcpServer close() {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing (context: {}", (Object)System.identityHashCode(this));
        }
        logger.info("{} closed", (Object)this.getBoundAddress());
        if (!((CloseableObjectState)((Object)this.getState())).isClosed()) {
            this.setState(CloseableObjectState.Closing);
        }
        try {
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                socketHandle.close();
            }
        }
        finally {
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    public void disconnectAll() {
        ArrayList<ServerConnection> arrayList = new ArrayList<ServerConnection>();
        this.getConnections(arrayList);
        for (ServerConnection serverConnection : arrayList) {
            OpcTcpServerConnection opcTcpServerConnection = (OpcTcpServerConnection)serverConnection;
            opcTcpServerConnection.close();
        }
    }

    public SocketAddress getBoundAddress() {
        SocketHandle[] socketHandleArray;
        for (SocketHandle socketHandle : socketHandleArray = this.socketHandleSnapshot()) {
            if (socketHandle.vQ == null) continue;
            return socketHandle.getBoundSocketAddress() != null ? socketHandle.getBoundSocketAddress() : socketHandle.getSocketAddress();
        }
        return null;
    }

    @Override
    public List<SocketAddress> getBoundSocketAddresses() {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            arrayList.add(socketHandle.getBoundSocketAddress() != null ? socketHandle.getBoundSocketAddress() : socketHandle.getSocketAddress());
        }
        return arrayList;
    }

    @Override
    public void getConnections(Collection<ServerConnection> collection) {
        this.vR.getConnections(collection);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    @Override
    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public int getReceiveBufferSize() {
        return this.yX;
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.vR.removeConnectionListener(connectListener);
    }

    public void setReceiveBufferSize(int n2) throws ServiceResultException {
        this.yX = n2;
        if (n2 > 0) {
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                try {
                    AsyncServerSocket asyncServerSocket = socketHandle.vQ;
                    if (asyncServerSocket == null) continue;
                    asyncServerSocket.socket().setReceiveBufferSize(n2);
                }
                catch (SocketException socketException) {
                    throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)socketException);
                }
            }
        }
    }

    public SocketHandle[] socketHandleSnapshot() {
        return this.wh.values().toArray(new SocketHandle[this.wh.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OpcTcpServer");
        stringBuilder.append("(");
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            stringBuilder.append(socketHandle.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private a a(final SocketAddress socketAddress, final ReverseConnectionParameters reverseConnectionParameters, a a2, final ScheduledExecutorService scheduledExecutorService) {
        final String string = reverseConnectionParameters.getEndpointUrlForClientConnection();
        if (a2 != null && a2.isClosed()) {
            return a2;
        }
        if (socketAddress == null || string == null) {
            throw new IllegalArgumentException();
        }
        this.init();
        final a a3 = a2 != null ? a2 : new a();
        ReverseSocketHandle reverseSocketHandle = new ReverseSocketHandle(socketAddress);
        if (reverseSocketHandle.Aa == null) {
            try {
                reverseSocketHandle.setChannel(SocketChannel.open());
                reverseSocketHandle.getChannel().configureBlocking(false);
                reverseSocketHandle.Aa = new AsyncSocketImpl(reverseSocketHandle.getChannel(), StackUtils.getBlockingWorkExecutor(), StackUtils.getSelector());
                ReverseHello reverseHello = new ReverseHello();
                reverseHello.setEndpointUrl(string);
                reverseHello.setServerUri(this.application.getApplicationDescription().getApplicationUri());
                final OpcTcpServerConnection opcTcpServerConnection = new OpcTcpServerConnection(this, reverseSocketHandle.Aa, reverseHello);
                this.vR.addConnection(opcTcpServerConnection);
                a3.a(opcTcpServerConnection);
                final AtomicReference<2> atomicReference = new AtomicReference<2>();
                atomicReference.set(new IConnectionListener(){

                    @Override
                    public void onClosed(ServiceResultException serviceResultException) {
                        OpcTcpServer.this.vR.removeConnection(opcTcpServerConnection);
                        if (logger.isDebugEnabled()) {
                            logger.debug("ReverseHello connection closed (context: {}), rescheduling connection process, addressToConnect:{}, endpointUrl:{}", System.identityHashCode(OpcTcpServer.this), socketAddress, string);
                        }
                        if (a3.isClosed()) {
                            logger.debug("The ReverseConnection is closed/removed (or the server is shutting down), skipping resceduling");
                            ReverseConnectionStatus.Builder builder = ReverseConnectionStatus.builder();
                            builder.setConnected(false);
                            builder.setCurrentRetryCount(0);
                            builder.setParameters(reverseConnectionParameters);
                            builder.setCloseError(new ServiceResultException(StatusCodes.Bad_Shutdown, "The ReverseConnection is closed/removed (or the server is shutting down)"));
                            reverseConnectionParameters.internalFireStatusNotification(builder.build());
                            return;
                        }
                        opcTcpServerConnection.removeConnectionListener((IConnectionListener)atomicReference.get());
                        try {
                            int n2 = a3.eCJ().getAndIncrement();
                            ReverseConnectionStatus.Builder builder = ReverseConnectionStatus.builder();
                            builder.setConnected(false);
                            builder.setCurrentRetryCount(n2);
                            builder.setParameters(reverseConnectionParameters);
                            builder.setCloseError(serviceResultException);
                            reverseConnectionParameters.internalFireStatusNotification(builder.build());
                            int n3 = reverseConnectionParameters.getRetryWaitIntervals().get(Math.min(n2, reverseConnectionParameters.getRetryWaitIntervals().size() - 1));
                            logger.debug("Retry attempt index: {}, wait time: {}", (Object)n2, (Object)n3);
                            a3.a(scheduledExecutorService.schedule(() -> OpcTcpServer.this.a(socketAddress, reverseConnectionParameters, a3, scheduledExecutorService), (long)n3, TimeUnit.MILLISECONDS));
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void onOpen() {
                        if (a3.isClosed()) {
                            logger.debug("The ReverseConnection is closed/removed while connection happened, closing..");
                            a3.close();
                        }
                        a3.eCJ().set(0);
                        if (logger.isDebugEnabled()) {
                            logger.debug("ReverseHello connection opened (context: {}), addressToConnect:{}, endpointUrl:{}", System.identityHashCode(OpcTcpServer.this), socketAddress, string);
                        }
                        ReverseConnectionStatus.Builder builder = ReverseConnectionStatus.builder();
                        builder.setConnected(true);
                        builder.setCurrentRetryCount(0);
                        builder.setParameters(reverseConnectionParameters);
                        reverseConnectionParameters.internalFireStatusNotification(builder.build());
                    }
                });
                opcTcpServerConnection.addConnectionListener((IConnectionListener)atomicReference.get());
                opcTcpServerConnection.init();
                if (logger.isDebugEnabled()) {
                    logger.debug("ReverseHello connection connecting (context: {}), addressToConnect:{}, endpointUrl:{}", System.identityHashCode(this), socketAddress, string);
                }
                reverseSocketHandle.Aa.connect(reverseSocketHandle.wq);
            }
            catch (IOException iOException) {
                logger.error("Failed to create a ReverseSocketHandle", iOException);
                reverseSocketHandle.close();
            }
        }
        return a3;
    }

    private void init() {
        if (!this.initialized) {
            int n2 = this.application.getOpctcpSettings().getMaxConnections();
            if (n2 <= 0) {
                throw new IllegalStateException("Maximum number of connections was not configured; must be greater than 0");
            }
            this.vs = n2;
            this.initialized = true;
            this.addStateListener((iStatefulObject, closeableObjectState, closeableObjectState2) -> logger.debug("onStateTransition, old: {}, new: {}", closeableObjectState, closeableObjectState2));
            this.setState(CloseableObjectState.Open);
        }
    }

    int a(Endpoint endpoint) {
        int n2 = 0;
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            for (OpcTcpEndpointHandle opcTcpEndpointHandle : socketHandle.endpointHandleSnapshot()) {
                if (!opcTcpEndpointHandle.wo.endpointAddress.equals(endpoint)) continue;
                ++n2;
            }
        }
        return n2;
    }

    List<OpcTcpEndpointHandle> av(String string) {
        ArrayList<OpcTcpEndpointHandle> arrayList = new ArrayList<OpcTcpEndpointHandle>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            socketHandle.b(arrayList);
        }
        return arrayList;
    }

    synchronized SocketHandle a(SocketAddress socketAddress) throws ServiceResultException {
        SocketHandle socketHandle = this.wh.get(socketAddress);
        if (socketHandle == null) {
            socketHandle = new SocketHandle(socketAddress);
            this.wh.put(socketAddress, socketHandle);
        }
        return socketHandle;
    }

    public class SocketHandle {
        private SocketAddress wq;
        private InetSocketAddress wr;
        AsyncServerSocket vQ;
        private ServerSocketChannel Ab;
        Map<Endpoint, OpcTcpEndpointHandle> endpoints = new HashMap<Endpoint, OpcTcpEndpointHandle>();

        SocketHandle(SocketAddress socketAddress) {
            this.wq = socketAddress;
        }

        public synchronized OpcTcpEndpointHandle[] endpointHandleSnapshot() {
            return this.endpoints.values().toArray(new OpcTcpEndpointHandle[this.endpoints.size()]);
        }

        public InetSocketAddress getBoundSocketAddress() {
            return this.wr;
        }

        public ServerSocketChannel getChannel() {
            return this.Ab;
        }

        public SocketAddress getSocketAddress() {
            return this.wq;
        }

        public void setBoundSocketAddress(InetSocketAddress inetSocketAddress) {
            this.wr = inetSocketAddress;
        }

        public void setChannel(ServerSocketChannel serverSocketChannel) {
            this.Ab = serverSocketChannel;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("opc.tcp(" + (this.getBoundSocketAddress() != null ? this.getBoundSocketAddress() : this.getSocketAddress()) + ", ");
            for (OpcTcpEndpointHandle opcTcpEndpointHandle : this.endpoints.values()) {
                stringBuilder.append(opcTcpEndpointHandle.toString());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        void close() {
            for (OpcTcpEndpointHandle opcTcpEndpointHandle : this.endpoints.values()) {
                opcTcpEndpointHandle.eCv();
            }
            OpcTcpServer.this.wh.remove(this.getSocketAddress());
            if (this.vQ != null) {
                AsyncServerSocket asyncServerSocket = this.vQ;
                this.vQ = null;
                asyncServerSocket.close();
            }
        }

        synchronized void b(Collection<OpcTcpEndpointHandle> collection) {
            collection.addAll(this.endpoints.values());
        }

        synchronized OpcTcpEndpointHandle b(EndpointBinding endpointBinding) throws ServiceResultException {
            OpcTcpEndpointHandle opcTcpEndpointHandle = this.endpoints.get(endpointBinding.endpointAddress);
            if (opcTcpEndpointHandle == null) {
                opcTcpEndpointHandle = new OpcTcpEndpointHandle(this, endpointBinding);
                this.endpoints.put(endpointBinding.endpointAddress, opcTcpEndpointHandle);
                OpcTcpServer.this.endpointBindings.add(endpointBinding);
                endpointBinding.serviceServer.getEndpointBindings().add(endpointBinding);
            } else if (!opcTcpEndpointHandle.wo.equals(endpointBinding)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind an endpoint address to two different servers.");
            }
            return opcTcpEndpointHandle;
        }

        int getPort() {
            return ((InetSocketAddress)this.getSocketAddress()).getPort();
        }

        boolean eCK() {
            return this.getSocketAddress() instanceof InetSocketAddress && ((InetSocketAddress)this.getSocketAddress()).getPort() == 0;
        }
    }

    public static class ReverseSocketHandle {
        private SocketAddress wq;
        private SocketChannel channel;
        private AsyncSocketImpl Aa;

        public ReverseSocketHandle(SocketAddress socketAddress) {
            this.wq = socketAddress;
        }

        public SocketChannel getChannel() {
            return this.channel;
        }

        public AsyncSocketImpl getSocket() {
            return this.Aa;
        }

        public SocketAddress getSocketAddress() {
            return this.wq;
        }

        public void setChannel(SocketChannel socketChannel) {
            this.channel = socketChannel;
        }

        public void setSocket(AsyncSocketImpl asyncSocketImpl) {
            this.Aa = asyncSocketImpl;
        }

        void close() {
            SocketChannel socketChannel = this.channel;
            if (socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    logger.error("Failure in closing ReverseSockeHandle", iOException);
                }
            }
        }
    }

    public class OpcTcpEndpointHandle
    implements EndpointServer.EndpointHandle {
        EndpointBinding wo;
        SocketHandle zZ;

        OpcTcpEndpointHandle(SocketHandle socketHandle, EndpointBinding endpointBinding) {
            this.zZ = socketHandle;
            this.wo = endpointBinding;
        }

        @Override
        public void close() {
            this.eCu();
            this.eCv();
        }

        @Override
        public EndpointBinding endpointBinding() {
            return this.wo;
        }

        @Override
        public SocketAddress socketAddress() {
            return this.zZ.getBoundSocketAddress() != null ? this.zZ.getBoundSocketAddress() : this.zZ.getSocketAddress();
        }

        public String toString() {
            return "(" + this.wo.endpointAddress.toString() + ")";
        }

        void eCu() {
            this.zZ.endpoints.remove(this.wo.endpointAddress);
            if (this.zZ.endpoints.isEmpty()) {
                this.zZ.close();
            }
        }

        void eCv() {
            int n2 = OpcTcpServer.this.a(this.wo.endpointAddress);
            if (n2 == 0) {
                OpcTcpServer.this.endpointBindings.remove(this.wo);
                this.wo.serviceServer.getEndpointBindings().remove(this.wo);
            }
        }
    }
}

