/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.AsyncWrite;
import com.prosysopc.ua.stack.transport.CloseableObject;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ServerConnection;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.impl.TcpConnectionParameters;
import com.prosysopc.ua.stack.transport.tcp.nio.Channel;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServerSecureChannel;
import com.prosysopc.ua.stack.transport.tcp.nio.SecureInputMessageBuilder;
import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.StateListener;
import com.prosysopc.ua.stack.utils.asyncsocket.SocketState;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerConnection
extends AbstractState<CloseableObjectState, ServiceResultException>
implements CloseableObject,
ServerConnection {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServerConnection.class);
    int zB = 0;
    SecurityConfiguration securityConfiguration;
    StateListener<SocketState> zC;
    TcpConnectionParameters zD = new TcpConnectionParameters();
    SecureInputMessageBuilder zE;
    OpcTcpServerSecureChannel zF = null;
    CopyOnWriteArrayList<ServerConnection.SecureChannelListener> ww = new CopyOnWriteArrayList();
    CopyOnWriteArrayList<Channel.ChannelListener> zG = new CopyOnWriteArrayList();
    CopyOnWriteArrayList<IConnectionListener> wx = new CopyOnWriteArrayList();

    protected AbstractServerConnection() {
        super(CloseableObjectState.Closed);
    }

    public void addChannelListener(Channel.ChannelListener channelListener) {
        this.zG.add(channelListener);
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.wx.add(iConnectionListener);
    }

    @Override
    public void addSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.ww.add(secureChannelListener);
    }

    @Override
    public synchronized CloseableObject close() {
        try {
            this.setState(CloseableObjectState.Closing);
        }
        finally {
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    public String getConnectURL() {
        return this.zD.endpointUrl;
    }

    public Certificate getRemoteCertificate() {
        return this.securityConfiguration.getReceiverCertificate();
    }

    @Override
    public void getSecureChannels(Collection<ServerSecureChannel> collection) {
        OpcTcpServerSecureChannel opcTcpServerSecureChannel = this.zF;
        if (opcTcpServerSecureChannel != null) {
            collection.add(opcTcpServerSecureChannel);
        }
    }

    public void removeChannelListener(Channel.ChannelListener channelListener) {
        this.zG.remove(channelListener);
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.wx.remove(iConnectionListener);
    }

    @Override
    public void removeSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.ww.remove(secureChannelListener);
    }

    public String toString() {
        CloseableObjectState closeableObjectState = (CloseableObjectState)((Object)this.getState());
        return "Connection (state=" + (Object)((Object)closeableObjectState) + ", local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + ")";
    }

    protected void fireSecureChannelAttached(ServerSecureChannel serverSecureChannel) {
        for (ServerConnection.SecureChannelListener secureChannelListener : this.ww) {
            secureChannelListener.onSecureChannelAttached(this, serverSecureChannel);
        }
    }

    protected void fireSecureChannelDetached(ServerSecureChannel serverSecureChannel) {
        for (ServerConnection.SecureChannelListener secureChannelListener : this.ww) {
            secureChannelListener.onSecureChannelDetached(this, serverSecureChannel);
        }
    }

    protected abstract CertificateValidator getRemoteCertificateValidator();

    @Override
    protected void onListenerException(RuntimeException runtimeException) {
        this.setError(StackUtils.toServiceResultException(runtimeException));
    }

    @Override
    protected void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Open) {
            for (IConnectionListener object : this.wx) {
                object.onOpen();
            }
        }
        if (closeableObjectState2 == CloseableObjectState.Closed) {
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_CommunicationError);
            for (IConnectionListener iConnectionListener : this.wx) {
                iConnectionListener.onClosed(serviceResultException);
            }
        }
    }

    protected abstract int sendAsymmSecureMessage(AsyncWrite var1, SecurityConfiguration var2, int var3, int var4, AtomicInteger var5) throws ServiceResultException;

    protected abstract void sendSecureMessage(AsyncWrite var1, SecurityToken var2, int var3, int var4, AtomicInteger var5);

    @Override
    protected synchronized void setError(ServiceResultException serviceResultException) {
        if (this.hasError()) {
            return;
        }
        super.setError(serviceResultException);
        this.close();
    }

    @Override
    protected void setError(StatusCode statusCode) {
        this.setError(new ServiceResultException(statusCode));
    }

    @Override
    protected void setError(UnsignedInteger unsignedInteger) {
        this.setError(new StatusCode(unsignedInteger));
    }
}

