/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ChannelSecurityToken;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.SecurityTokenRequestType;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalClientSideDecodingServiceFault;
import com.prosysopc.ua.stack.transport.tcp.io.IConnection;
import com.prosysopc.ua.stack.transport.tcp.io.ITransportChannel;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnection;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannelTcp
implements IConnectionListener,
SecureChannel,
IConnection.IMessageListener,
ITransportChannel {
    static Logger logger = LoggerFactory.getLogger(SecureChannelTcp.class);
    private static final int[] yE = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 120, 120, 120};
    private static final double ow = 0.1;
    @Deprecated
    public static boolean disableReconnectLogic = false;
    private EncoderContext ctx;
    Executor executor = StackUtils.getBlockingWorkExecutor();
    int vi = -1;
    long yF;
    long yG;
    TransportChannelSettings yH;
    InetSocketAddress addr;
    AtomicInteger vm = new AtomicInteger(0);
    AtomicReference<IConnection> yI = new AtomicReference<Object>(null);
    Map<Integer, a> vv = new ConcurrentHashMap<Integer, a>();
    int yJ = 0;
    TimerTask yK;
    boolean yL = false;
    Object yM = new Object();
    TimerTask yN;
    AtomicReference<TimerTask> vx = new AtomicReference<Object>(null);
    Timer vw;
    Runnable vB = new Runnable(){

        @Override
        public void run() {
            SecureChannelTcp.this.eCq();
            long l2 = System.currentTimeMillis();
            for (a a2 : SecureChannelTcp.this.vv.values()) {
                if (l2 < a2.vF) continue;
                logger.warn("Request id={} timeouted {}ms elapsed. timeout at {}ms", a2.requestId, System.currentTimeMillis() - a2.vE, a2.vF - a2.vE);
                a2.vG.setError(new ServiceResultException(StatusCodes.Bad_Timeout));
                SecureChannelTcp.this.vv.remove(a2.requestId);
            }
            SecureChannelTcp.this.eCr();
        }
    };
    private Runnable yO = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable runnable = SecureChannelTcp.this.yO;
            synchronized (runnable) {
                try {
                    SecureChannelTcp.this.eCz();
                }
                catch (ServiceResultException serviceResultException) {
                    logger.trace("failure while sendPendingRequestMessages", serviceResultException);
                }
            }
        }
    };
    Runnable yP = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SecureChannelTcp.this.yM;
            synchronized (object) {
                if (!SecureChannelTcp.this.yL) {
                    return;
                }
            }
            if (!SecureChannelTcp.this.isOpen()) {
                SecureChannelTcp.this.d(false);
                logger.info("{}: Error recovery failed, security token has expired", (Object)SecureChannelTcp.this.vi);
                SecureChannelTcp.this.close();
                return;
            }
            try {
                logger.debug("{}: Error recovery reconnect", (Object)SecureChannelTcp.this.vi);
                if (SecureChannelTcp.this.eCA() == null) {
                    throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
                }
                SecureChannelTcp.this.eCA().open();
                SecureChannelTcp.this.c(true);
                SecureChannelTcp.this.d(false);
                SecureChannelTcp.this.executor.execute(SecureChannelTcp.this.yO);
            }
            catch (ServiceResultException serviceResultException) {
                if (serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_TcpSecureChannelUnknown) || serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_SecureChannelTokenUnknown) || serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_NotFound)) {
                    logger.info(SecureChannelTcp.this.vi + ": The secure channel has been closed by the server", serviceResultException);
                    SecureChannelTcp.this.close();
                    return;
                }
                Object object2 = SecureChannelTcp.this.yM;
                synchronized (object2) {
                    ++SecureChannelTcp.this.yJ;
                    long l2 = System.currentTimeMillis();
                    long l3 = SecureChannelTcp.this.yJ >= yE.length ? (long)(yE[yE.length - 1] * 1000) : (long)(yE[SecureChannelTcp.this.yJ] * 1000);
                    long l4 = (long)((double)SecureChannelTcp.this.yG * 1.25) + SecureChannelTcp.this.yF;
                    if (l2 + l3 > l4) {
                        logger.info("{}: Error recovery failed, security token has expired", (Object)SecureChannelTcp.this.vi);
                        SecureChannelTcp.this.close();
                        return;
                    }
                    if (!disableReconnectLogic) {
                        SecureChannelTcp.this.yK = TimerUtil.schedule(SecureChannelTcp.this.vw, SecureChannelTcp.this.yP, SecureChannelTcp.this.executor, l2 + l3);
                    }
                }
            }
        }
    };
    private Runnable yQ = new Runnable(){

        @Override
        public void run() {
            try {
                logger.debug("{} Renewing security token", (Object)SecureChannelTcp.this.vi);
                SecureChannelTcp.this.c(true);
            }
            catch (ServiceResultException serviceResultException) {
                logger.error(SecureChannelTcp.this.vi + " Failed to renew security token. ", serviceResultException);
            }
        }
    };

    @Override
    public void close() {
        Cloneable cloneable;
        this.d(false);
        Object object = this.yN;
        this.yN = null;
        if (object != null) {
            ((TimerTask)object).cancel();
        }
        if ((object = this.eCA()) != null) {
            cloneable = new CloseSecureChannelRequest();
            try {
                this.serviceRequest((ServiceRequest)cloneable);
            }
            catch (ServiceResultException serviceResultException) {
                // empty catch block
            }
            if (this.vi != -1) {
                logger.info("{} Closed", (Object)this.vi);
            }
            this.vi = -1;
            object.close();
            object.removeMessageListener(this);
            object.removeConnectionListener(this);
            object.dispose();
            this.setTransportChannel(null);
        }
        this.eCq();
        cloneable = new ArrayList<a>(this.vv.values());
        logger.debug("requests.clear()");
        this.vv.clear();
        if (!cloneable.isEmpty()) {
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
            Iterator iterator = cloneable.iterator();
            while (iterator.hasNext()) {
                a a2 = (a)iterator.next();
                a2.vG.setError(serviceResultException);
            }
        }
    }

    @Override
    public AsyncResult<SecureChannel> closeAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SecureChannelTcp.this.close();
                }
                finally {
                    asyncResultImpl.setResult(SecureChannelTcp.this);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public void dispose() {
        this.close();
        this.yI = null;
        this.yH = null;
        this.addr = null;
        this.vv = null;
        this.vw = null;
    }

    @Override
    public String getConnectURL() {
        return this.getEndpointDescription().getEndpointUrl();
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        if (this.yH == null) {
            return null;
        }
        return this.yH.getConfiguration();
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        if (this.yH == null) {
            return null;
        }
        return this.yH.getDescription();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.ctx;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        return this.getEndpointDescription().getSecurityMode();
    }

    @Override
    public int getOperationTimeout() {
        Integer n2 = this.yH.getConfiguration().getOperationTimeout();
        return n2 == null ? 0 : n2;
    }

    @Override
    public int getSecureChannelId() {
        return this.vi;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        try {
            return SecurityPolicy.getSecurityPolicy(this.getEndpointDescription().getSecurityPolicyUri());
        }
        catch (ServiceResultException serviceResultException) {
            return null;
        }
    }

    @Override
    public EnumSet<ITransportChannel.TransportChannelFeature> getSupportedFeatures() {
        return EnumSet.of(ITransportChannel.TransportChannelFeature.open, new ITransportChannel.TransportChannelFeature[]{ITransportChannel.TransportChannelFeature.openAsync, ITransportChannel.TransportChannelFeature.close, ITransportChannel.TransportChannelFeature.closeAync, ITransportChannel.TransportChannelFeature.sendRequest, ITransportChannel.TransportChannelFeature.sendRequestAsync});
    }

    public void initialize(InetSocketAddress inetSocketAddress, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        if (this.vi != -1) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Cannot reconfigure already opened secure channel");
        }
        this.yH = transportChannelSettings.clone();
        this.addr = inetSocketAddress;
        this.ctx = encoderContext;
        this.yK = null;
        this.yJ = 0;
        this.vw = TimerUtil.getTimer();
        String string = transportChannelSettings.getDescription().getEndpointUrl();
        if (string != null && !string.isEmpty() && !"opc.tcp".equals(UriUtil.getTransportProtocol(string))) {
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, "The protocol is not supported by the this SecureChannelTcp");
        }
        this.setTransportChannel(new TcpConnection());
        this.eCA().initialize(inetSocketAddress, transportChannelSettings, encoderContext);
        this.eCA().addConnectionListener(this);
        this.eCA().addMessageListener(this);
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        logger.debug("initialize: url={}, settings: {}", (Object)string, (Object)transportChannelSettings);
        InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(string);
        this.initialize(inetSocketAddress, transportChannelSettings, encoderContext);
    }

    @Override
    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    @Override
    public boolean isOpen() {
        if (this.vi == -1) {
            return false;
        }
        long l2 = (long)((double)this.yG * 1.25) + this.yF;
        long l3 = System.currentTimeMillis();
        return l2 > l3;
    }

    @Override
    public void onClosed(ServiceResultException serviceResultException) {
        StatusCode statusCode;
        if (this.vi == -1) {
            return;
        }
        StatusCode statusCode2 = statusCode = serviceResultException == null ? null : serviceResultException.getStatusCode();
        if (statusCode != null && statusCode.isStatusCode(StatusCodes.Bad_ConnectionClosed)) {
            this.d(true);
        } else {
            if (serviceResultException == null) {
                serviceResultException = new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            while (!this.vv.isEmpty()) {
                ArrayList<a> arrayList = new ArrayList<a>(this.vv.values());
                for (a a2 : arrayList) {
                    a2.vG.setError(serviceResultException);
                }
                this.vv.values().removeAll(arrayList);
            }
            this.d(false);
        }
        if (statusCode != null && statusCode.isStatusCode(StatusCodes.Bad_ConnectionClosed)) {
            this.d(true);
        }
        boolean bl = serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_ConnectionClosed);
        this.d(bl);
    }

    @Override
    public void onMessage(int n2, int n3, IEncodeable iEncodeable) {
        if (n3 != this.vi) {
            return;
        }
        a a2 = this.vv.remove(n2);
        if (a2 == null) {
            if (!(iEncodeable instanceof OpenSecureChannelResponse)) {
                ServiceFault serviceFault;
                ServiceFault serviceFault2 = serviceFault = iEncodeable instanceof ServiceFault ? (ServiceFault)iEncodeable : null;
                if (serviceFault != null && serviceFault.getResponseHeader().getServiceResult().equals(StatusCode.valueOf(StatusCodes.Bad_TooManyPublishRequests))) {
                    logger.info("ServiceFault={}", (Object)serviceFault);
                } else {
                    logger.warn("{} Unidentified message, RequestId={}, type={}!", n3, n2, iEncodeable.getClass().getSimpleName());
                    if (serviceFault != null) {
                        logger.warn("ServiceFault={}", (Object)serviceFault);
                    }
                }
            }
            return;
        }
        if (iEncodeable instanceof ServiceFault) {
            if (iEncodeable instanceof InternalClientSideDecodingServiceFault) {
                InternalClientSideDecodingServiceFault internalClientSideDecodingServiceFault = (InternalClientSideDecodingServiceFault)iEncodeable;
                a2.vG.setError(new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)internalClientSideDecodingServiceFault.getDecodingException(), "Client-side DecodingException happened while decoding the server reponse"));
            } else {
                a2.vG.setError(new ServiceFaultException((ServiceFault)iEncodeable));
            }
        } else {
            try {
                a2.vG.setResult(iEncodeable);
            }
            catch (ClassCastException classCastException) {
                logger.error("onMessage: Cannot set result", classCastException);
            }
        }
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void open() throws ServiceResultException {
        logger.debug("open");
        if (this.vi == -1) {
            try {
                this.eCA().open();
            }
            catch (ServiceResultException serviceResultException) {
                logger.warn("Connection failed: {}", (Object)serviceResultException.getMessage());
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_CommunicationError)) {
                    logger.warn("Bad_CommunicationError: Retrying");
                    this.eCA().open();
                }
                throw serviceResultException;
            }
            this.c(false);
        }
    }

    @Override
    public AsyncResult<SecureChannel> openAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        if (this.vi != -1) {
            asyncResultImpl.setResult(this);
            return asyncResultImpl;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SecureChannelTcp.this.open();
                    asyncResultImpl.setResult(SecureChannelTcp.this);
                }
                catch (ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceFaultException, ServiceResultException {
        long l2 = this.getRequestTimeout(serviceRequest);
        return this.serviceRequest(serviceRequest, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest, long l2) throws ServiceFaultException, ServiceResultException {
        int n2 = 0;
        while (!this.isOpen()) {
            try {
                if (n2++ > 100) {
                    throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        a<T> a2 = this.a(serviceRequest, l2);
        a2.vG = new AsyncResultImpl();
        this.vv.put(a2.requestId, a2);
        logger.debug("serviceRequest: requests.size={}", (Object)this.vv.size());
        try {
            Object object;
            try {
                object = this.eCA();
                if (object != null) {
                    object.sendRequest(serviceRequest, this.vi, a2.requestId);
                }
                logger.debug("serviceRequest: Message sent, requestId={} secureChannelId={}", (Object)a2.requestId, (Object)this.vi);
                logger.trace("serviceRequest: message={}", (Object)serviceRequest);
            }
            catch (ServiceResultException serviceResultException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("serviceRequest: While sending requestId=" + a2.requestId + ", secureChannelId=" + this.vi + ", message=" + serviceRequest, serviceResultException);
                }
                if (serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_CommunicationError)) {
                    a2.yW = serviceRequest;
                    this.executor.execute(this.yO);
                }
                throw serviceResultException;
            }
            if (serviceRequest instanceof CloseSecureChannelRequest) {
                object = null;
                return (T)object;
            }
            if (l2 == 0L) {
                object = (ServiceResponse)a2.vG.waitForResult();
            } else {
                long l3 = a2.vF - System.currentTimeMillis();
                object = (ServiceResponse)a2.vG.waitForResult(l3, TimeUnit.MILLISECONDS);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Response: {}", object);
            } else {
                logger.debug("Response: {}", (Object)object.getClass().getSimpleName());
            }
            ResponseHeader responseHeader = object.getResponseHeader();
            StatusCode statusCode = responseHeader.getServiceResult();
            if (statusCode.isBad()) {
                logger.debug("BAD response: {}", (Object)statusCode);
                throw new ServiceFaultException(new ServiceFault(responseHeader));
            }
            Object object2 = object;
            return (T)object2;
        }
        finally {
            this.vv.remove(a2.requestId);
        }
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) {
        long l2 = this.getRequestTimeout(serviceRequest);
        return this.serviceRequestAsync(serviceRequest, l2);
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest, long l2) {
        AsyncResultImpl asyncResultImpl = new AsyncResultImpl();
        if (!this.isOpen()) {
            asyncResultImpl.setError(new ServiceResultException(StatusCodes.Bad_SecureChannelClosed));
            return asyncResultImpl;
        }
        a<T> a2 = this.a(serviceRequest, l2);
        a2.vG = asyncResultImpl;
        a2.yW = serviceRequest;
        this.vv.put(a2.requestId, a2);
        logger.debug("serviceRequestAsync: requests.size={}", (Object)this.vv.size());
        if (l2 != 0L) {
            this.eCr();
        }
        this.executor.execute(this.yO);
        return asyncResultImpl;
    }

    @Override
    public void setOperationTimeout(int n2) {
        this.yH.getConfiguration().setOperationTimeout(n2);
    }

    public String toString() {
        return "SecureChannel " + this.vi + " " + (this.isOpen() ? "open" : "closed");
    }

    private void eCq() {
        TimerTask timerTask = this.vx.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    private void c(boolean bl) throws ServiceResultException {
        IConnection iConnection = this.eCA();
        logger.debug("createSecureChannel: renew={} channel={}", (Object)bl, (Object)iConnection);
        if (iConnection == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
        }
        long l2 = System.currentTimeMillis();
        int n2 = this.vm.incrementAndGet();
        logger.debug("createSecureChannel: requestId={}", (Object)n2);
        OpenSecureChannelRequest openSecureChannelRequest = new OpenSecureChannelRequest();
        SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(this.yH.getDescription().getSecurityPolicyUri());
        ByteString byteString = CryptoUtil.createNonce(securityPolicy.getSecureChannelNonceLength());
        Integer n3 = this.yH.getConfiguration().getSecurityTokenLifetime();
        if (n3 == null) {
            n3 = 3600000;
        }
        logger.debug("tokenLifetime: {}", (Object)n3);
        openSecureChannelRequest.setClientNonce(byteString);
        openSecureChannelRequest.setClientProtocolVersion(UnsignedInteger.valueOf(0L));
        openSecureChannelRequest.setRequestedLifetime(UnsignedInteger.valueOf(n3.intValue()));
        openSecureChannelRequest.setRequestType(bl ? SecurityTokenRequestType.Renew : SecurityTokenRequestType.Issue);
        openSecureChannelRequest.setSecurityMode(this.yH.getDescription().getSecurityMode());
        int n4 = bl ? this.vi : 0;
        final Semaphore semaphore = new Semaphore(0);
        final ServiceResultException[] serviceResultExceptionArray = new ServiceResultException[1];
        final IEncodeable[] iEncodeableArray = new IEncodeable[1];
        final int[] nArray = new int[1];
        final int n5 = n2;
        IConnection.IMessageListener iMessageListener = new IConnection.IMessageListener(){

            @Override
            public void onMessage(int n2, int n3, IEncodeable iEncodeable) {
                if (n2 != n5) {
                    return;
                }
                iEncodeableArray[0] = iEncodeable;
                nArray[0] = n3;
                semaphore.release(10);
            }
        };
        IConnectionListener iConnectionListener = new IConnectionListener(){

            @Override
            public void onClosed(ServiceResultException serviceResultException) {
                if (serviceResultException == null) {
                    serviceResultException = new ServiceResultException(StatusCodes.Bad_CommunicationError, "Connection Closed");
                }
                serviceResultExceptionArray[0] = serviceResultException;
                semaphore.release(10);
            }

            @Override
            public void onOpen() {
            }
        };
        iConnection.addConnectionListener(iConnectionListener);
        iConnection.addMessageListener(iMessageListener);
        try {
            iConnection.sendRequest(openSecureChannelRequest, n4, n2);
            try {
                long l3 = this.getOperationTimeout();
                if (l3 > 0L) {
                    long l4 = (System.currentTimeMillis() - l2) / 1000L;
                    long l5 = l3 - l4;
                    semaphore.tryAcquire(1, l5, TimeUnit.MILLISECONDS);
                } else {
                    semaphore.acquire();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (serviceResultExceptionArray[0] != null) {
                throw serviceResultExceptionArray[0];
            }
            IEncodeable iEncodeable = iEncodeableArray[0];
            if (iEncodeable == null) {
                throw new ServiceResultException(StatusCodes.Bad_Timeout);
            }
            if (iEncodeable instanceof ServiceFault) {
                ServiceFaultException serviceFaultException = new ServiceFaultException((ServiceFault)iEncodeable);
                logger.error(nArray + ": CreateSecureChannel Fault", serviceFaultException);
                throw serviceFaultException;
            }
            if (!(iEncodeable instanceof OpenSecureChannelResponse)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Unexpected result " + iEncodeable.getClass().getName() + " OpenSecureChannelResponse expected");
            }
            OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)iEncodeable;
            ChannelSecurityToken channelSecurityToken = openSecureChannelResponse.getSecurityToken();
            this.vi = channelSecurityToken.getChannelId().intValue();
            if (bl) {
                logger.debug("{} Secure channel renewed, SecureChannelId={}, TokenId={}", this.vi, this.vi, channelSecurityToken.getTokenId().longValue());
            } else {
                logger.debug("{} Secure channel opened, SecureChannelId={}, TokenId={}", this.vi, this.vi, channelSecurityToken.getTokenId().longValue());
            }
            if (bl) {
                this.vi = n4;
            }
            long l6 = System.currentTimeMillis();
            this.yF = l2 / 2L + l6 / 2L;
            this.yG = channelSecurityToken.getRevisedLifetime().longValue();
            TimerTask timerTask = this.yN;
            this.yN = null;
            if (timerTask != null) {
                timerTask.cancel();
            }
            long l7 = channelSecurityToken.getRevisedLifetime().longValue();
            logger.debug("RevisedLifetime: {}", (Object)l7);
            this.yN = TimerUtil.schedule(this.vw, this.yQ, this.executor, l6 + (long)((double)l7 * 0.75));
        }
        catch (ServiceResultException serviceResultException) {
            throw serviceResultException;
        }
        finally {
            iConnection.removeConnectionListener(iConnectionListener);
            iConnection.removeMessageListener(iMessageListener);
        }
    }

    private a eCx() {
        long l2 = Long.MAX_VALUE;
        a a2 = null;
        logger.debug("getNextTimeoutingPendingRequest: requests.size={}", (Object)this.vv.size());
        for (a a3 : this.vv.values()) {
            if (l2 <= a3.vF) continue;
            l2 = a3.vF;
            a2 = a3;
        }
        return a2;
    }

    private a eCy() {
        for (a a2 : this.vv.values()) {
            if (a2.yW == null) continue;
            return a2;
        }
        return null;
    }

    private <T extends ServiceResponse> a<T> a(ServiceRequest<T> serviceRequest, long l2) {
        a a2 = new a();
        a2.requestId = this.vm.incrementAndGet();
        a2.vE = System.currentTimeMillis();
        a2.vF = l2 == 0L ? Long.MAX_VALUE : (long)((double)a2.vE + (double)l2 * 1.1);
        return a2;
    }

    private void eCr() {
        a a2 = this.eCx();
        if (a2 == null) {
            this.eCq();
        } else {
            TimerTask timerTask = this.vx.get();
            if (timerTask == null || timerTask.scheduledExecutionTime() > a2.vF) {
                this.eCq();
                timerTask = TimerUtil.schedule(this.vw, this.vB, this.executor, a2.vF);
                if (!this.vx.compareAndSet(null, timerTask)) {
                    timerTask.cancel();
                }
            }
        }
    }

    private void eCz() throws ServiceResultException {
        if (!this.isOpen()) {
            return;
        }
        a a2 = null;
        while ((a2 = this.eCy()) != null) {
            IEncodeable iEncodeable = a2.yW;
            a2.yW = null;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - a2.vE;
            if (l2 > a2.vF) {
                logger.debug("Request id={} timeouted {}ms elapsed. timeout at {} ms", a2.requestId, l3, a2.vF - a2.vE);
                this.vv.remove(a2.requestId);
                a2.vG.setError(new ServiceResultException(StatusCodes.Bad_Timeout));
                continue;
            }
            if (iEncodeable == null) continue;
            try {
                logger.debug("sendPendingRequestMessages: requestId={}", (Object)a2.requestId);
                IConnection iConnection = this.eCA();
                if (iConnection == null) continue;
                iConnection.sendRequest((ServiceRequest)iEncodeable, this.vi, a2.requestId);
            }
            catch (EncodingException encodingException) {
                this.vv.remove(a2.requestId);
                a2.vG.setError(encodingException);
            }
            catch (ServiceResultException serviceResultException) {
                StatusCode statusCode = serviceResultException.getStatusCode();
                if (statusCode.isStatusCode(StatusCodes.Bad_CommunicationError)) {
                    a2.yW = iEncodeable;
                    continue;
                }
                a2.vG.setError(serviceResultException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(boolean bl) {
        Object object = this.yM;
        synchronized (object) {
            if (this.yL == bl) {
                return;
            }
            if (bl) {
                logger.info("{}: Error recovery = true", (Object)this.vi);
                this.yL = true;
                this.yJ = 0;
                if (!disableReconnectLogic) {
                    long l2 = System.currentTimeMillis();
                    this.yK = TimerUtil.schedule(this.vw, this.yP, this.executor, l2 + (long)yE[0]);
                }
            } else {
                logger.info("{}: Error recovery = false", (Object)this.vi);
                this.yL = false;
                this.yJ = 0;
                this.yK.cancel();
                this.yK = null;
            }
        }
    }

    protected long getRequestTimeout(ServiceRequest serviceRequest) {
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l2 = unsignedInteger != null ? unsignedInteger.longValue() : (long)this.getOperationTimeout();
        return l2;
    }

    protected void setTransportChannel(IConnection iConnection) {
        this.yI.set(iConnection);
    }

    IConnection eCA() {
        return this.yI.get();
    }

    static class a<T extends ServiceResponse> {
        long vE = System.currentTimeMillis();
        long vF;
        int requestId;
        AsyncResultImpl<T> vG;
        IEncodeable yW;

        a() {
        }
    }
}

