/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnection;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.EnumSet;

public class OpcTcpSettings
implements Cloneable {
    PrivKey yz;
    Cert rw;
    CertificateValidator cH;
    EnumSet<Flag> yA = EnumSet.noneOf(Flag.class);
    int yB = -1;
    int connectTimeout = -1;
    int yC = -1;
    int vs = 0;
    TcpConnection.SocketFactory hm;

    public OpcTcpSettings clone() {
        OpcTcpSettings opcTcpSettings = new OpcTcpSettings();
        opcTcpSettings.setClientCertificate(this.rw);
        opcTcpSettings.setCertificateValidator(this.cH);
        opcTcpSettings.setPrivKey(this.yz);
        opcTcpSettings.yA = this.yA.clone();
        opcTcpSettings.setConnectTimeout(this.connectTimeout);
        opcTcpSettings.setHandshakeTimeout(this.yB);
        opcTcpSettings.setReverseHelloAcceptTimeout(this.yC);
        opcTcpSettings.setSocketFactory(this.hm);
        return opcTcpSettings;
    }

    public CertificateValidator getCertificateValidator() {
        return this.cH;
    }

    public Cert getClientCertificate() {
        return this.rw;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public EnumSet<Flag> getFlags() {
        return this.yA;
    }

    public int getHandshakeTimeout() {
        return this.yB;
    }

    public int getMaxConnections() {
        return this.vs;
    }

    public PrivKey getPrivKey() {
        return this.yz;
    }

    public int getReverseHelloAcceptTimeout() {
        return this.yC;
    }

    public TcpConnection.SocketFactory getSocketFactory() {
        return this.hm;
    }

    public void readFrom(OpcTcpSettings opcTcpSettings) {
        if (opcTcpSettings.rw != null) {
            this.rw = opcTcpSettings.rw;
        }
        if (opcTcpSettings.cH != null) {
            this.cH = opcTcpSettings.cH;
        }
        if (opcTcpSettings.yz != null) {
            this.yz = opcTcpSettings.yz;
        }
        this.yA = opcTcpSettings.yA;
        this.yC = opcTcpSettings.yC;
        this.yB = opcTcpSettings.yB;
        this.connectTimeout = opcTcpSettings.connectTimeout;
        this.vs = opcTcpSettings.vs;
        this.hm = opcTcpSettings.hm;
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.cH = certificateValidator;
    }

    public void setClientCertificate(Cert cert) {
        this.rw = cert;
    }

    public void setClientCertificate(X509Certificate x509Certificate) throws CertificateEncodingException {
        this.rw = new Cert(x509Certificate);
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2;
    }

    public void setFlags(EnumSet<Flag> enumSet) {
        this.yA = enumSet;
    }

    public void setHandshakeTimeout(int n2) {
        this.yB = n2;
    }

    public void setMaxConnections(int n2) {
        this.vs = n2;
    }

    public void setPrivKey(PrivKey privKey) {
        this.yz = privKey;
    }

    public void setReverseHelloAcceptTimeout(int n2) {
        this.yC = n2;
    }

    public void setSocketFactory(TcpConnection.SocketFactory socketFactory) {
        this.hm = socketFactory;
    }

    public static enum Flag {
        MultiThread;

    }
}

