/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkSymmDecryptVerifier
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkSymmDecryptVerifier.class);
    static final int ye = 8;
    static final int messageHeaderSize = 8;
    static final int yf = 8;
    static final int yg = 16;
    ByteBuffer xX;
    SecurityToken yh;

    public ChunkSymmDecryptVerifier(ByteBuffer byteBuffer, SecurityToken securityToken) {
        this.xX = byteBuffer;
        this.yh = securityToken;
    }

    @Override
    public void run() throws RuntimeServiceResultException {
        SecurityPolicy securityPolicy = this.yh.getSecurityPolicy();
        MessageSecurityMode messageSecurityMode = this.yh.getMessageSecurityMode();
        int n2 = this.xX.limit();
        try {
            Object object;
            int n3;
            int n4 = ChunkUtils.getTokenId(this.xX);
            if (n4 != this.yh.getTokenId()) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            ServiceResultException serviceResultException = null;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                this.xX.position(16);
                byte[] byArray = new byte[this.xX.limit() - 16];
                this.xX.get(byArray, 0, byArray.length);
                try {
                    n3 = this.a(this.yh, byArray, 0, byArray.length, this.xX.array(), 16 + this.xX.arrayOffset());
                }
                catch (ServiceResultException serviceResultException2) {
                    serviceResultException = serviceResultException2;
                    n3 = byArray.length;
                }
            } else {
                n3 = this.xX.limit() - 16;
            }
            int n5 = 0;
            int n6 = securityPolicy.getSymmetricSignatureSize();
            ServiceResultException serviceResultException3 = null;
            if (messageSecurityMode == MessageSecurityMode.Sign || messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                object = new byte[n6];
                this.xX.position(n2 - n6);
                this.xX.get((byte[])object);
                this.xX.position(0);
                byte[] byArray = new byte[16 + n3 - n6];
                this.xX.get(byArray, 0, byArray.length);
                try {
                    this.a(this.yh, byArray, (byte[])object);
                }
                catch (ServiceResultException serviceResultException4) {
                    serviceResultException3 = serviceResultException4;
                }
            }
            object = null;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n7 = 0;
                n7 = 16 + n3 - n6 - 1;
                n5 = this.xX.get(n7);
                for (int i2 = n7 - n5; i2 < n7; ++i2) {
                    if (this.xX.get(i2) == n5) continue;
                    logger.error("Padding does not match");
                    object = new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Could not verify the padding in the message");
                }
                ++n5;
            }
            this.xX.position(24);
            this.xX.limit(this.xX.position() + n3 - 8 - n5 - n6);
            int n8 = this.xX.limit() - 8 - 8 - 8 - n6 - n5;
            if (n8 < 0) {
                // empty if block
            }
            if (serviceResultException != null) {
                throw serviceResultException;
            }
            if (serviceResultException3 != null) {
                throw serviceResultException3;
            }
            if (object != null) {
                throw object;
            }
        }
        catch (ServiceResultException serviceResultException) {
            this.t(100);
            throw new RuntimeServiceResultException(serviceResultException);
        }
        catch (Exception exception) {
            this.t(100);
            throw new RuntimeServiceResultException(new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)exception));
        }
    }

    private int a(SecurityToken securityToken, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ServiceResultException {
        logger.debug("decrypt: dataToDecrypt.length={} inputOffset={} inputLength={} output.length={} outputOffset={}", byArray.length, n2, n3, byArray2.length, n4);
        return CryptoUtil.getCryptoProvider().decryptSymm(securityToken.getSecurityPolicy(), securityToken.getRemoteEncryptingKey(), securityToken.getRemoteInitializationVector(), byArray, n2, n3, byArray2, n4);
    }

    private void t(int n2) {
        int n3 = 1 + CryptoUtil.getRandom().nextInt(n2);
        try {
            Thread.sleep(n3);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void a(SecurityToken securityToken, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        CryptoUtil.getCryptoProvider().verifySymm(securityToken.getSecurityPolicy(), securityToken.getRemoteSigningKey(), byArray, 0, byArray.length, byArray2);
    }
}

