/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.transport.security.CertificateProvider;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AuthorityKeyIdentifier;
import org.spongycastle.asn1.x509.BasicConstraints;
import org.spongycastle.asn1.x509.ExtendedKeyUsage;
import org.spongycastle.asn1.x509.Extension;
import org.spongycastle.asn1.x509.GeneralName;
import org.spongycastle.asn1.x509.GeneralNames;
import org.spongycastle.asn1.x509.KeyPurposeId;
import org.spongycastle.asn1.x509.KeyUsage;
import org.spongycastle.cert.jcajce.JcaX509CertificateConverter;
import org.spongycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.spongycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.openssl.PEMDecryptorProvider;
import org.spongycastle.openssl.PEMEncryptedKeyPair;
import org.spongycastle.openssl.PEMEncryptor;
import org.spongycastle.openssl.PEMKeyPair;
import org.spongycastle.openssl.PEMParser;
import org.spongycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.spongycastle.openssl.jcajce.JcaPEMWriter;
import org.spongycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.spongycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.spongycastle.operator.ContentSigner;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.jcajce.JcaContentSignerBuilder;
import org.spongycastle.util.encoders.Base64;
import org.spongycastle.x509.extension.X509ExtensionUtil;

public class ScCertificateProvider
implements CertificateProvider {
    private static final Logger logger = LoggerFactory.getLogger(ScCertificateProvider.class);

    @Deprecated
    private static Date a(Instant instant) {
        return Date.from(instant);
    }

    public ScCertificateProvider() {
        CryptoUtil.loadOrInstallProvider("SC", () -> new BouncyCastleProvider(), "org.spongycastle.jce.provider.BouncyCastleProvider");
    }

    @Override
    public byte[] base64Decode(String string) {
        return Base64.decode((String)StringUtils.removeWhitespace(string));
    }

    @Override
    public String base64Encode(byte[] byArray) {
        return new String(Base64.encode((byte[])byArray), StandardCharsets.UTF_8);
    }

    @Override
    public X509Certificate generateCertificate(String string, PublicKey publicKey, PrivateKey privateKey, KeyPair keyPair, Instant instant, Instant instant2, BigInteger bigInteger, String string2, String ... stringArray) throws IOException, GeneralSecurityException {
        Object object;
        Object object2;
        PrivateKey privateKey2;
        AuthorityKeyIdentifier authorityKeyIdentifier;
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder;
        Serializable serializable;
        JcaX509ExtensionUtils jcaX509ExtensionUtils = new JcaX509ExtensionUtils();
        if (keyPair == null) {
            serializable = new X500Name(string);
            jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder((X500Name)serializable, bigInteger, ScCertificateProvider.a(instant), ScCertificateProvider.a(instant2), (X500Name)serializable, publicKey);
            authorityKeyIdentifier = jcaX509ExtensionUtils.createAuthorityKeyIdentifier(publicKey);
            privateKey2 = privateKey;
        } else {
            serializable = keyPair.getCertificate().getCertificate();
            jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder((X509Certificate)serializable, bigInteger, ScCertificateProvider.a(instant), ScCertificateProvider.a(instant2), new X500Principal(string), publicKey);
            authorityKeyIdentifier = jcaX509ExtensionUtils.createAuthorityKeyIdentifier((X509Certificate)serializable);
            privateKey2 = keyPair.getPrivateKey().getPrivateKey();
        }
        jcaX509v3CertificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createSubjectKeyIdentifier(publicKey)).addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(244));
        jcaX509v3CertificateBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth}));
        serializable = new ArrayList();
        serializable.add(new GeneralName(6, string2));
        boolean bl = false;
        String string3 = null;
        try {
            object2 = string2.split("[:/]");
            if (((String[])object2).length > 1 && !(string3 = object2[1]).toLowerCase(Locale.ROOT).equals("localhost")) {
                object = new GeneralName(2, string3);
                serializable.add(object);
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.warn("Cannot initialize DNS Name to Certificate from ApplicationUri{}", (Object)string2);
        }
        object2 = new ArrayList();
        if (stringArray != null) {
            for (String string4 : stringArray) {
                boolean bl2 = string4.matches("^[0-9.]+$");
                if (string4.equals(string3) || string4.toLowerCase(Locale.ROOT).equals("localhost")) continue;
                GeneralName generalName = new GeneralName(string4.matches("^[0-9.]+$") ? 7 : 2, string4);
                if (bl2) {
                    object2.add(generalName);
                    continue;
                }
                serializable.add(generalName);
                bl = true;
            }
        }
        if (!bl) {
            object = object2.iterator();
            while (object.hasNext()) {
                GeneralName generalName = (GeneralName)object.next();
                serializable.add(generalName);
            }
        }
        object = new GeneralNames(serializable.toArray(new GeneralName[0]));
        jcaX509v3CertificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)object);
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder(CertificateUtils.getCertificateSignatureAlgorithm()).setProvider("SC").build(privateKey2);
            return new JcaX509CertificateConverter().setProvider("SC").getCertificate(jcaX509v3CertificateBuilder.build(contentSigner));
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new GeneralSecurityException(operatorCreationException);
        }
    }

    @Override
    public X509Certificate generateIssuerCert(PublicKey publicKey, PrivateKey privateKey, KeyPair keyPair, String string, BigInteger bigInteger, Instant instant, Instant instant2) throws GeneralSecurityException, IOException {
        AuthorityKeyIdentifier authorityKeyIdentifier;
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder;
        X509Certificate x509Certificate;
        JcaX509ExtensionUtils jcaX509ExtensionUtils = new JcaX509ExtensionUtils();
        if (keyPair == null) {
            x509Certificate = new X500Name(string);
            jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder((X500Name)x509Certificate, bigInteger, ScCertificateProvider.a(instant), ScCertificateProvider.a(instant2), (X500Name)x509Certificate, publicKey);
            authorityKeyIdentifier = jcaX509ExtensionUtils.createAuthorityKeyIdentifier(publicKey);
        } else {
            x509Certificate = keyPair.getCertificate().getCertificate();
            jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x509Certificate, bigInteger, ScCertificateProvider.a(instant), ScCertificateProvider.a(instant2), new X500Principal(string), publicKey);
            authorityKeyIdentifier = jcaX509ExtensionUtils.createAuthorityKeyIdentifier(x509Certificate);
        }
        jcaX509v3CertificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)jcaX509ExtensionUtils.createSubjectKeyIdentifier(publicKey)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        try {
            x509Certificate = new JcaContentSignerBuilder(CertificateUtils.getCertificateSignatureAlgorithm()).setProvider("SC").build(privateKey);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new GeneralSecurityException("Failed to sign the certificate", operatorCreationException);
        }
        return new JcaX509CertificateConverter().setProvider("SC").getCertificate(jcaX509v3CertificateBuilder.build((ContentSigner)x509Certificate));
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames(X509Certificate x509Certificate) throws CertificateParsingException {
        return X509ExtensionUtil.getSubjectAlternativeNames((X509Certificate)x509Certificate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrivateKey readPrivateKey(InputStream inputStream, String string, String string2) throws IOException {
        String string3 = CryptoUtil.getSecurityProviderName(null);
        try (PEMParser pEMParser = new PEMParser((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            if (string == null || string.isEmpty()) {
                PEMKeyPair pEMKeyPair = (PEMKeyPair)pEMParser.readObject();
                if (pEMKeyPair == null) {
                    throw new IOException("readPrivateKey failed: Could not read from InputStream");
                }
                PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(pEMKeyPair.getPrivateKeyInfo());
                return privateKey;
            }
            char[] cArray = string.toCharArray();
            PEMEncryptedKeyPair pEMEncryptedKeyPair = (PEMEncryptedKeyPair)pEMParser.readObject();
            if (pEMEncryptedKeyPair == null) {
                throw new IOException("readPrivateKey failed: Could not read from InputStream");
            }
            PEMDecryptorProvider pEMDecryptorProvider = new JcePEMDecryptorProviderBuilder().setProvider(string3).build(cArray);
            JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter().setProvider(string3);
            PrivateKey privateKey = jcaPEMKeyConverter.getPrivateKey(pEMEncryptedKeyPair.decryptKeyPair(pEMDecryptorProvider).getPrivateKeyInfo());
            return privateKey;
        }
    }

    @Override
    public void writePrivateKey(PrivateKey privateKey, OutputStream outputStream, String string, String string2) throws IOException {
        JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        if (string == null) {
            jcaPEMWriter.writeObject((Object)privateKey);
        } else {
            PEMEncryptor pEMEncryptor = new JcePEMEncryptorBuilder(string2).setSecureRandom(CryptoUtil.getRandom()).build(string.toCharArray());
            jcaPEMWriter.writeObject((Object)privateKey, pEMEncryptor);
        }
        jcaPEMWriter.close();
    }
}

