/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.CryptoProvider;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JceCryptoProvider
implements CryptoProvider {
    private static final Logger logger = LoggerFactory.getLogger(JceCryptoProvider.class);
    protected final Provider provider;

    public JceCryptoProvider(Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Given provider cannot be null");
        }
        this.provider = provider;
    }

    @Override
    public byte[] base64Decode(String string) {
        return CertificateUtils.base64Decode(string);
    }

    @Override
    public String base64Encode(byte[] byArray) {
        return CertificateUtils.base64Encode(byArray);
    }

    @Override
    public Mac createMac(SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        Mac mac;
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, securityAlgorithm.getStandardName());
        try {
            mac = Mac.getInstance(securityAlgorithm.getStandardName(), this.provider);
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
        return mac;
    }

    @Override
    public int decryptAsymm(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2, int n2) throws ServiceResultException {
        Cipher cipher;
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
        int n3 = rSAPrivateKey.getModulus().bitLength() / 8;
        try {
            cipher = this.a(securityAlgorithm, privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.info("decrypt: The provided RSA key is invalid", invalidKeyException);
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
        if (byArray.length % n3 != 0) {
            logger.error("decrypt: Wrong blockSize!!!");
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Error in asymmetric decrypt: Input data is not an even number of encryption blocks.");
        }
        try {
            logger.info("JceCipherDecrypt={}", (Object)cipher);
            int n4 = n2 + byArray.length;
            int n5 = 0;
            int n6 = -1;
            int n7 = 0;
            for (int i2 = n2; i2 < n4; i2 += n3) {
                n6 = cipher.doFinal(byArray, n7, n3, byArray2, n2);
                n7 += n3;
                n2 += n6;
                n5 += n6;
            }
            return n5;
        }
        catch (GeneralSecurityException generalSecurityException) {
            logger.error("decrypt: error", generalSecurityException);
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public int decryptSymm(SecurityPolicy securityPolicy, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3, byte[] byArray4, int n4) throws ServiceResultException {
        SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricEncryptionAlgorithm();
        if (logger.isTraceEnabled()) {
            logger.trace("decrypt: token.getRemoteEncryptingKey()=" + CryptoUtil.toHex(byArray));
            logger.trace("decrypt: token.getRemoteInitializationVector()=" + CryptoUtil.toHex(byArray2));
            logger.trace("decrypt: dataToDecrypt=" + CryptoUtil.toHex(byArray3));
            logger.trace("decrypt: algorithm=" + (Object)((Object)securityAlgorithm));
        }
        int n5 = 0;
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, securityAlgorithm.getStandardName());
        try {
            Cipher cipher = Cipher.getInstance(securityAlgorithm.getTransformation());
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
            n5 = cipher.update(byArray3, n2, n3, byArray4, n4);
            n5 += cipher.doFinal(byArray4, n4 + n5);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)illegalStateException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("decrypt: output=" + CryptoUtil.toHex(byArray4));
        }
        return n5;
    }

    @Override
    public void encryptAsymm(PublicKey publicKey, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2, int n2) throws ServiceResultException {
        Cipher cipher = null;
        int n3 = 1;
        n3 = CryptoUtil.getPlainTextBlockSize(securityAlgorithm, publicKey);
        try {
            cipher = this.a(securityAlgorithm, publicKey);
            int n4 = n2 + byArray.length;
            int n5 = 0;
            for (int i2 = n2; i2 < n4; i2 += n3) {
                int n6 = cipher.doFinal(byArray, n5, Math.min(n4 - i2, n3), byArray2, n2);
                logger.debug("Asym encryption: amountOfEncryptedBytes={} inputOffset={} outputOffset={} index={}", n6, n5 += n3, n2 += n6, i2);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public int encryptSymm(SecurityPolicy securityPolicy, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3, byte[] byArray4, int n4) throws ServiceResultException {
        SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricEncryptionAlgorithm();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, securityAlgorithm.getStandardName());
        try {
            Cipher cipher = Cipher.getInstance(securityAlgorithm.getTransformation());
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray2));
            int n5 = cipher.update(byArray3, n2, n3, byArray4, n4);
            n5 += cipher.doFinal(byArray4, n4 + n5);
            return n5;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, (Throwable)invalidKeyException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public String getSecurityProviderName(Class<?> clazz) {
        return this.provider.getName();
    }

    @Override
    public byte[] signAsymm(PrivateKey privateKey, SecurityAlgorithm securityAlgorithm, byte[] byArray) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return null;
        }
        if (byArray == null || privateKey == null) {
            throw new IllegalArgumentException("null arg");
        }
        try {
            Signature signature = this.a(securityAlgorithm);
            logger.debug("signer.getProvider(): {}", (Object)signature.getProvider());
            signature.initSign(privateKey);
            signature.update(byArray);
            return signature.sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public void signSymm(SecurityPolicy securityPolicy, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) throws ServiceResultException {
        Mac mac = this.createMac(securityPolicy.getSymmetricSignatureAlgorithm(), byArray);
        mac.update(byArray2, n2, n3);
        try {
            mac.doFinal(byArray3, n4);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeServiceResultException(new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException));
        }
    }

    @Override
    public boolean verifyAsymm(PublicKey publicKey, SecurityAlgorithm securityAlgorithm, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        if (securityAlgorithm == null) {
            return true;
        }
        if (publicKey == null || byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("null arg");
        }
        try {
            Signature signature = this.a(securityAlgorithm);
            signature.initVerify(publicKey);
            signature.update(byArray);
            if (signature.verify(byArray2)) {
                logger.debug("Asym Signature Verify : OK");
                return true;
            }
            logger.error("Asymmetric Signature Verification fails");
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)generalSecurityException);
        }
    }

    @Override
    public void verifySymm(SecurityPolicy securityPolicy, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) throws ServiceResultException {
        Mac mac = this.createMac(securityPolicy.getSymmetricSignatureAlgorithm(), byArray);
        mac.update(byArray2, n2, n3);
        byte[] byArray4 = new byte[mac.getMacLength()];
        try {
            mac.doFinal(byArray4, 0);
        }
        catch (ShortBufferException shortBufferException) {
            logger.error("verifySymm", shortBufferException);
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Invalid signature");
        }
        catch (IllegalStateException illegalStateException) {
            logger.error("verifySymm", illegalStateException);
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Invalid signature");
        }
        if (!MessageDigest.isEqual(byArray3, byArray4)) {
            logger.warn("Signatures do not match: \n" + CryptoUtil.toHex(byArray3) + " vs. \n" + CryptoUtil.toHex(byArray4));
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Invalid signature: signatures do not match");
        }
    }

    private Cipher a(SecurityAlgorithm securityAlgorithm, PrivateKey privateKey) throws NoSuchProviderException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(securityAlgorithm.getTransformation(), this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            cipher = Cipher.getInstance(securityAlgorithm.getStandardName(), this.provider);
        }
        cipher.init(2, privateKey);
        logger.debug("decrypt: cipher.provider={}", (Object)cipher.getProvider());
        return cipher;
    }

    private Cipher a(SecurityAlgorithm securityAlgorithm, PublicKey publicKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(securityAlgorithm.getTransformation(), this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            cipher = Cipher.getInstance(securityAlgorithm.getStandardName(), this.provider);
        }
        cipher.init(1, publicKey);
        logger.trace("encrypt: cipher.provider={}", (Object)cipher.getProvider());
        return cipher;
    }

    private Signature a(SecurityAlgorithm securityAlgorithm) throws NoSuchAlgorithmException {
        try {
            return Signature.getInstance(securityAlgorithm.getStandardName(), this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Signature.getInstance(securityAlgorithm.getStandardName());
        }
    }
}

