/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.impl;

import com.prosysopc.ua.stack.transport.ConnectionMonitor;
import com.prosysopc.ua.stack.transport.ServerConnection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionCollection
implements ConnectionMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionCollection.class);
    Set<ServerConnection> xa = new CopyOnWriteArraySet<ServerConnection>();
    CopyOnWriteArrayList<ConnectionMonitor.ConnectListener> vk = new CopyOnWriteArrayList();
    Object xb;

    public ConnectionCollection(Object object) {
        this.xb = object;
    }

    public void addConnection(ServerConnection serverConnection) {
        logger.trace("addConnection: {}", (Object)serverConnection);
        if (!this.xa.add(serverConnection)) {
            return;
        }
        for (ConnectionMonitor.ConnectListener connectListener : this.vk) {
            connectListener.onConnect(this.xb, serverConnection);
        }
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.vk.add(connectListener);
    }

    public Iterator<ConnectionMonitor.ConnectListener> getConnectionListeners() {
        return this.vk.iterator();
    }

    @Override
    public synchronized void getConnections(Collection<ServerConnection> collection) {
        collection.addAll(this.xa);
    }

    public void removeConnection(ServerConnection serverConnection) {
        logger.trace("removeConnection: {}", (Object)serverConnection);
        this.xa.remove(serverConnection);
        for (ConnectionMonitor.ConnectListener connectListener : this.vk) {
            connectListener.onClose(this.xb, serverConnection);
        }
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.vk.remove(connectListener);
    }
}

