/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.impl;

import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResultImpl<T>
implements AsyncResult<T> {
    static Logger logger = LoggerFactory.getLogger(AsyncResultImpl.class);
    static Logger wT = LoggerFactory.getLogger(ResultListener.class);
    static Executor executor = StackUtils.getBlockingWorkExecutor();
    ServiceResultException wU;
    T result;
    ResultListener<T> wV;
    Semaphore wW = new Semaphore(0);

    public static <T> AsyncResultImpl<T> failed(ServiceResultException serviceResultException) {
        AsyncResultImpl<T> asyncResultImpl = new AsyncResultImpl<T>();
        asyncResultImpl.setError(serviceResultException);
        return asyncResultImpl;
    }

    @Override
    public ServiceResultException getError() {
        return this.wU;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public AsyncResult.AsyncResultStatus getStatus() {
        if (this.wU != null) {
            return AsyncResult.AsyncResultStatus.Failed;
        }
        if (this.result != null) {
            return AsyncResult.AsyncResultStatus.Succeed;
        }
        return AsyncResult.AsyncResultStatus.Waiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(final ServiceResultException serviceResultException) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.wU = serviceResultException;
            final ResultListener<T> resultListener = this.wV;
            if (resultListener != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resultListener.onError(serviceResultException);
                        }
                        catch (RuntimeException runtimeException) {
                            wT.error("Unexpected RuntimeException in ResultListener#onError(", runtimeException);
                        }
                        finally {
                            AsyncResultImpl.this.finish();
                        }
                    }
                });
            }
        }
        this.wW.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorSync(ServiceResultException serviceResultException) throws RuntimeException {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.wU = serviceResultException;
            ResultListener<T> resultListener = this.wV;
            if (resultListener != null) {
                try {
                    resultListener.onError(serviceResultException);
                }
                catch (RuntimeException runtimeException) {
                    wT.error("Unexpected RuntimeException in ResultListener#onError(", runtimeException);
                }
                finally {
                    this.finish();
                }
            }
        }
        this.wW.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(ResultListener<T> resultListener) {
        T t2;
        ServiceResultException serviceResultException;
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            this.wV = resultListener;
            serviceResultException = this.wU;
            t2 = this.result;
        }
        if (resultListener != null) {
            if (t2 != null) {
                resultListener.onCompleted(t2);
            }
            if (serviceResultException != null) {
                resultListener.onError(serviceResultException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(T t2) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.result = t2;
            final ResultListener<T> resultListener = this.wV;
            if (resultListener != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resultListener.onCompleted(AsyncResultImpl.this.result);
                        }
                        catch (RuntimeException runtimeException) {
                            wT.error("Unexpected RuntimeException in ResultListener#onCompleted", runtimeException);
                        }
                        finally {
                            AsyncResultImpl.this.finish();
                        }
                    }
                });
            }
        }
        this.wW.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSync(T t2) throws RuntimeException {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.result = t2;
            ResultListener<T> resultListener = this.wV;
            if (resultListener != null) {
                try {
                    resultListener.onCompleted(t2);
                }
                catch (RuntimeException runtimeException) {
                    wT.error("Unexpected RuntimeException in ResultListener#onCompleted(", runtimeException);
                }
                finally {
                    this.finish();
                }
            }
        }
        this.wW.release(Integer.MAX_VALUE);
    }

    public void setSource(AsyncResult<T> asyncResult) {
        asyncResult.setListener(new ResultListener<T>(){

            @Override
            public void onCompleted(T t2) {
                AsyncResultImpl.this.setResult(t2);
            }

            @Override
            public void onError(ServiceResultException serviceResultException) {
                AsyncResultImpl.this.setError(serviceResultException);
            }
        });
    }

    @Override
    public T waitForResult() throws ServiceResultException {
        try {
            this.wW.acquire();
        }
        catch (InterruptedException interruptedException) {
            logger.debug("timeout: ", this.wU);
            throw new ServiceResultException(StatusCodes.Bad_Timeout, (Throwable)interruptedException);
        }
        if (this.result != null) {
            return this.result;
        }
        if (this.wU != null) {
            logger.debug("error: ", this.wU);
            if (this.wU instanceof ServiceFaultException) {
                throw new ServiceFaultException(((ServiceFaultException)this.wU).getServiceFault());
            }
            throw this.wU;
        }
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
    }

    @Override
    public T waitForResult(long l2, TimeUnit timeUnit) throws ServiceResultException {
        try {
            this.wW.tryAcquire(l2, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceResultException(StatusCodes.Bad_Timeout, (Throwable)interruptedException);
        }
        if (this.result != null) {
            return this.result;
        }
        logger.debug("error:", this.wU);
        if (this.wU != null) {
            if (this.wU instanceof ServiceFaultException) {
                throw new ServiceFaultException(((ServiceFaultException)this.wU).getServiceFault());
            }
            throw this.wU;
        }
        throw new ServiceResultException(StatusCodes.Bad_Timeout);
    }

    private void finish() {
        this.setListener(null);
    }

    private boolean isFinished() {
        return this.result != null || this.wU != null;
    }
}

