/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.endpoint;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerSecureChannel
extends AbstractState<CloseableObjectState, ServiceResultException>
implements ServerSecureChannel {
    static Logger logger = LoggerFactory.getLogger(AbstractServerSecureChannel.class);
    private int vi;
    protected Map<Integer, SecurityToken> tokens = new ConcurrentHashMap<Integer, SecurityToken>();
    protected SecurityToken activeToken;

    protected AbstractServerSecureChannel(int n2) {
        super(CloseableObjectState.Closed);
        this.vi = n2;
    }

    @Override
    public void close() {
        if (this.getState() != CloseableObjectState.Open) {
            return;
        }
        this.setState(CloseableObjectState.Closing);
        this.setState(CloseableObjectState.Closed);
        logger.info("Channel closed: Id={}", (Object)this.getSecureChannelId());
    }

    @Override
    public AsyncResult<ServerSecureChannel> closeAsync() {
        AsyncResultImpl<ServerSecureChannel> asyncResultImpl = new AsyncResultImpl<ServerSecureChannel>();
        if (this.getState() != CloseableObjectState.Open) {
            asyncResultImpl.setResult(this);
            return asyncResultImpl;
        }
        this.setState(CloseableObjectState.Closing);
        this.setState(CloseableObjectState.Closed);
        asyncResultImpl.setResult(this);
        return asyncResultImpl;
    }

    public SecurityToken getActiveSecurityToken() {
        return this.activeToken;
    }

    public synchronized SecurityToken getLatestNonExpiredToken() {
        SecurityToken securityToken = null;
        for (SecurityToken securityToken2 : this.tokens.values()) {
            if (securityToken2.isExpired()) continue;
            if (securityToken == null) {
                securityToken = securityToken2;
            }
            if (securityToken2.getCreationTime() <= securityToken.getCreationTime()) continue;
            securityToken = securityToken2;
        }
        return securityToken;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        SecurityToken securityToken = this.getActiveSecurityToken();
        return securityToken == null ? null : securityToken.getMessageSecurityMode();
    }

    @Override
    public int getSecureChannelId() {
        return this.vi;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        SecurityToken securityToken = this.getActiveSecurityToken();
        return securityToken == null ? null : securityToken.getSecurityPolicy();
    }

    public synchronized SecurityToken getSecurityToken(int n2) {
        logger.debug("tokens({})={}", (Object)this.tokens.size(), (Object)this.tokens.values());
        return this.tokens.get(n2);
    }

    @Override
    public boolean isOpen() {
        return ((CloseableObjectState)((Object)this.getState())).isOpen();
    }

    public void setActiveSecurityToken(SecurityToken securityToken) {
        if (securityToken == null) {
            throw new IllegalArgumentException("null");
        }
        logger.debug("Switching to new security token {}", (Object)securityToken.getTokenId());
        this.activeToken = securityToken;
        this.eCo();
    }

    @Override
    public synchronized void setError(ServiceResultException serviceResultException) {
        super.setError(serviceResultException);
    }

    public String toString() {
        return String.format(Locale.ROOT, "SecureChannelId=%d State=%s URL=%s SecurityPolicy=%s RemoteAddress=%s", new Object[]{this.getSecureChannelId(), this.getState(), this.getConnectURL(), this.getSecurityPolicy(), this.getRemoteAddress()});
    }

    private void eCo() {
        if (logger.isDebugEnabled()) {
            logger.debug("pruneInvalidTokens: tokens({})={}", (Object)this.tokens.size(), (Object)this.tokens.values());
        }
        for (SecurityToken securityToken : this.tokens.values()) {
            if (securityToken.isValid()) continue;
            logger.debug("pruneInvalidTokens: remove Id={}", (Object)securityToken.getTokenId());
            this.tokens.remove(securityToken.getTokenId());
        }
    }

    protected String getRemoteAddress() {
        if (this.getConnection() == null) {
            return "(no connection)";
        }
        return "" + this.getConnection().getRemoteAddress();
    }

    @Override
    protected void onListenerException(RuntimeException runtimeException) {
        this.setError(StackUtils.toServiceResultException(runtimeException));
    }
}

