/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class TransportChannelSettings
implements Cloneable {
    EndpointDescription vd;
    EndpointConfiguration ve;
    NamespaceTable vf;
    OpcTcpSettings rj = new OpcTcpSettings();
    HttpsSettings gy = new HttpsSettings();

    public TransportChannelSettings() {
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, Cert cert, PrivKey privKey, CertificateValidator certificateValidator, NamespaceTable namespaceTable) throws RuntimeServiceResultException {
        this.ve = endpointConfiguration;
        this.vd = endpointDescription;
        this.rj.setClientCertificate(cert);
        this.rj.setCertificateValidator(certificateValidator);
        this.rj.setPrivKey(privKey);
        if (namespaceTable != null) {
            this.vf = namespaceTable;
        }
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, KeyPair keyPair, CertificateValidator certificateValidator, X509HostnameVerifier x509HostnameVerifier) throws RuntimeServiceResultException {
        this.ve = endpointConfiguration;
        this.vd = endpointDescription;
        this.gy.setKeyPair(keyPair, new Cert[0]);
        this.gy.setCertificateValidator(certificateValidator);
        this.gy.setHostnameVerifier(x509HostnameVerifier);
    }

    public TransportChannelSettings clone() {
        TransportChannelSettings transportChannelSettings;
        try {
            transportChannelSettings = (TransportChannelSettings)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("super.clone failed when it should not", cloneNotSupportedException);
        }
        if (this.vd != null) {
            transportChannelSettings.setDescription(this.vd.clone());
        }
        if (this.ve != null) {
            transportChannelSettings.setConfiguration(this.ve.clone());
        }
        if (this.rj != null) {
            transportChannelSettings.rj = this.rj.clone();
        }
        if (this.gy != null) {
            transportChannelSettings.gy = this.gy.clone();
        }
        if (this.vf != null) {
            transportChannelSettings.setNamespaceUris(this.vf);
        }
        return transportChannelSettings;
    }

    public EndpointConfiguration getConfiguration() {
        return this.ve;
    }

    public EndpointDescription getDescription() {
        return this.vd;
    }

    public HttpsSettings getHttpsSettings() {
        return this.gy;
    }

    public NamespaceTable getNamespaceUris() {
        return this.vf;
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.rj;
    }

    public Cert getServerCertificate() {
        try {
            if (this.vd != null && this.vd.getServerCertificate() != null && this.vd.getServerCertificate().getLength() > 0) {
                return new Cert(ByteString.asByteArray(this.vd.getServerCertificate()));
            }
            return null;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    public void readFrom(TransportChannelSettings transportChannelSettings) {
        if (transportChannelSettings.vd != null) {
            this.vd = transportChannelSettings.vd.clone();
        }
        if (transportChannelSettings.ve != null) {
            this.ve = transportChannelSettings.ve.clone();
        }
        if (transportChannelSettings.rj != null) {
            this.rj.readFrom(transportChannelSettings.rj);
        }
        if (transportChannelSettings.gy != null) {
            this.gy.readFrom(transportChannelSettings.gy);
        }
        if (transportChannelSettings.vf != null) {
            this.vf = transportChannelSettings.vf;
        }
    }

    public void setConfiguration(EndpointConfiguration endpointConfiguration) {
        this.ve = endpointConfiguration;
    }

    public void setDescription(EndpointDescription endpointDescription) {
        this.vd = endpointDescription;
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.gy = httpsSettings;
    }

    public void setNamespaceUris(NamespaceTable namespaceTable) {
        this.vf = namespaceTable;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.rj = opcTcpSettings;
    }

    public String toString() {
        return "TransportChannelSettings [description=" + this.vd + ", configuration=" + this.ve + ", namespaceUris=" + this.vf + ", opctcpSettings=" + this.rj + ", httpsSettings=" + this.gy + "]";
    }
}

