/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.xml;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.AbstactEncoder;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncoderMode;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.EOFException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlEncoder
extends AbstactEncoder
implements IEncoder {
    private static final String uA = "http://opcfoundation.org/UA/2008/02/Types.xsd";
    public static final String OPC_UA_TYPES_NAMESPACE = "http://opcfoundation.org/UA/2008/02/Types.xsd";
    private static final Logger logger = LoggerFactory.getLogger(XmlEncoder.class);
    private static final String tV = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String tX = "0001-01-01T00:00:00Z";
    private static final String tY = "9999-12-31T23:59:59Z";
    private static final Map<Class<?>, a<?>> sS = new HashMap();
    private static final Map<UaNodeId, a<?>> tD = new HashMap();
    private static final BijectionMap<UaNodeId, Class<?>> tE = new BijectionMap();
    private static final a<DateTime> uB;
    private static final a<ExtensionObject> uC;
    private static final a<Structure> uD;
    private static final a<DataValue> uE;
    private static final a<Variant> uF;
    private static final a<DiagnosticInfo> uG;
    private static final a<Enumeration> uH;
    private static final a<BigDecimal> uI;
    private static final a<UaOptionSet> uJ;
    private static final ExpandedNodeId tf;
    private final SimpleDateFormat uK = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ROOT);
    EncoderMode tw = EncoderMode.NonStrict;
    private boolean uL = true;
    private int uM = 4;
    private String encoding = "UTF-8";
    private boolean uN = true;
    private final Document uO;
    private final Deque<String> uP = new ArrayDeque<String>();
    private Element uQ = null;
    private Element uR = null;
    private int uS = 0;
    private int uT = 100;
    private String uU = null;
    private final boolean uV;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId != null) {
            if (tD.put(uaNodeId, a2) != null) {
                throw new Error("DataType " + uaNodeId + " already has a serializer defined");
            }
            if (tE.containsLeft(uaNodeId)) {
                throw new Error("DataType " + uaNodeId + " already mapped to a class");
            }
            if (tE.containsRight(clazz)) {
                throw new Error("Class " + clazz + " already mapped to a DataTypeId");
            }
            tE.map(uaNodeId, clazz);
        }
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        if (sS.put(clazz, a2) != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        XmlEncoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> k(Class<?> clazz) throws EncodingException {
        if (clazz == null) {
            throw new EncodingException("Cannot encode class null");
        }
        a<?> a2 = sS.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return uC;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return uD;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return uE;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return uF;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return uG;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return uH;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return uB;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return uI;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return uJ;
        }
        throw new EncodingException("Cannot encode class: " + clazz);
    }

    private static a<Object> d(UaNodeId uaNodeId, EncoderContext encoderContext, AtomicReference<Class<?>> atomicReference) throws EncodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            atomicReference.set(Object.class);
            return XmlEncoder.k(Object.class);
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            atomicReference.set(ExtensionObject.class);
            return XmlEncoder.k(ExtensionObject.class);
        }
        a<Object> a2 = tD.get(uaNodeId);
        if (a2 == null) {
            UaDataTypeSpecification uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = tD.get(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = uD;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = uJ;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = uH;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            }
        } else {
            atomicReference.set(tE.getRight(uaNodeId));
        }
        if (a2 == null) {
            throw new EncodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        if (atomicReference.get() == null) {
            throw new EncodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
        }
        return a2;
    }

    private static void a(Throwable throwable, String string, Object object) throws EncodingException {
        String string2 = String.format(Locale.ROOT, "fieldname=%s, value=%s", string, object);
        if (throwable instanceof ClosedChannelException) {
            throw new EncodingException(StatusCodes.Bad_ConnectionClosed, throwable, string2);
        }
        if (throwable instanceof EOFException) {
            throw new EncodingException(StatusCodes.Bad_EndOfStream, throwable, string2);
        }
        if (throwable instanceof ConnectException) {
            throw new EncodingException(StatusCodes.Bad_ConnectionRejected, throwable, string2);
        }
        if (throwable instanceof SocketException) {
            throw new EncodingException(StatusCodes.Bad_CommunicationError, throwable, string2);
        }
        throw new EncodingException(StatusCodes.Bad_UnexpectedError, throwable, string2);
    }

    public XmlEncoder(EncoderContext encoderContext) throws EncodingException {
        this(encoderContext, false);
    }

    public XmlEncoder(EncoderContext encoderContext, boolean bl) throws EncodingException {
        super(encoderContext);
        this.uV = bl;
        this.uK.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            this.uO = XMLFactoryCache.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new EncodingException("Unable to create DocumentBuilder", parserConfigurationException);
        }
    }

    public String getDefaultNamespace() {
        return this.uU;
    }

    public EncoderMode getEncoderType() {
        return this.tw;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getIndentAmount() {
        return this.uM;
    }

    @Override
    public List<Locale> getLocales() {
        return new ArrayList<Locale>();
    }

    public int getMaxDiagnosticInfoNestingLevel() {
        return this.uT;
    }

    public boolean isIndent() {
        return this.uL;
    }

    public boolean isOmitXmlDeclaration() {
        return this.uN;
    }

    @Override
    public void put(String string, Object object, UaNodeId uaNodeId, int n2) throws EncodingException {
        try {
            if (n2 < 0) {
                throw new EncodingException("The given dimensions cannot be negative");
            }
            this.a(string, object, null, uaNodeId, n2);
        }
        catch (Exception exception) {
            throw new EncodingException("Error while trying to encode, DataTypeId: " + uaNodeId, exception);
        }
    }

    public void putRawVariant(Variant variant, String string) throws EncodingException {
        this.a(variant, string);
    }

    public void setDefaultNamespace(String string) {
        this.uU = string;
    }

    public void setEncoderMode(EncoderMode encoderMode) {
        this.tw = encoderMode;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setIndent(boolean bl) {
        this.uL = bl;
    }

    public void setIndentAmount(int n2) {
        this.uM = n2;
    }

    public void setMaxDiagnosticInfoNestingLevel(int n2) {
        this.uT = n2;
    }

    public void setOmitXmlDeclaration(boolean bl) {
        this.uN = bl;
    }

    public void write(Writer writer) throws EncodingException {
        if (this.uQ != null) {
            if (this.uU != null) {
                this.uQ.setAttribute("xmlns", this.uU);
            }
            this.uO.appendChild(this.uQ);
        }
        try {
            Transformer transformer = XMLFactoryCache.getTransformerFactory().newTransformer();
            transformer.setOutputProperty("indent", this.isIndent() ? "yes" : "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", this.getEncoding());
            transformer.setOutputProperty("omit-xml-declaration", this.isOmitXmlDeclaration() ? "yes" : "no");
            int n2 = this.getIndentAmount() > 0 ? this.getIndentAmount() : 0;
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(n2));
            transformer.transform(new DOMSource(this.uO), new StreamResult(writer));
        }
        catch (TransformerException transformerException) {
            XmlEncoder.a(transformerException, "write", null);
        }
    }

    private void assertArrayLength(int n2) throws EncodingException {
        int n3 = this.ctx.getMaxArrayLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength " + n3 + " < " + n2);
            logger.warn("assertArrayLength: failed", encodingException);
            throw encodingException;
        }
    }

    private void endElement() {
        if (this.uR == this.uQ) {
            return;
        }
        this.uR = (Element)this.uR.getParentNode();
    }

    private boolean q(Object object) {
        if (object != null) {
            return false;
        }
        this.putNull();
        return true;
    }

    private boolean a(Object object, b b2) throws EncodingException {
        if (object != null) {
            return false;
        }
        if (this.tw == EncoderMode.Strict) {
            b2.serialize();
        } else {
            this.putNull();
        }
        return true;
    }

    private void a(String string, Object object2, Class<?> clazz, UaNodeId uaNodeId, int n2) throws EncodingException {
        int[] nArray;
        Class<?> clazz2;
        Object[] objectArray;
        if (n2 < 0) {
            throw new EncodingException("The given dimensions cannot be negative");
        }
        if (UaIds.Structure.equals(uaNodeId) && (clazz == null || !ExtensionObject.class.isAssignableFrom(MultiDimensionArrayUtils.getComponentType(clazz)))) {
            object2 = MultiDimensionArrayUtils.map(object2, Object.class, ExtensionObject.class, object -> {
                if (object instanceof ExtensionObject) {
                    return (ExtensionObject)object;
                }
                return new ExtensionObject((Structure)object);
            });
        }
        a<Object> a2 = null;
        UaNodeId uaNodeId2 = uaNodeId;
        if (uaNodeId2 == null && clazz != null) {
            uaNodeId2 = tE.getLeft(MultiDimensionArrayUtils.getComponentType(clazz));
        }
        if (uaNodeId2 != null) {
            objectArray = new AtomicReference();
            a2 = XmlEncoder.d(uaNodeId2, this.getEncoderContext(), objectArray);
            clazz2 = objectArray.get();
        } else {
            clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            a2 = XmlEncoder.k(clazz2);
        }
        if (n2 == 0) {
            a2.put(this, string, object2, uaNodeId2);
            return;
        }
        if (n2 == 1) {
            this.a(string, object2, clazz2, uaNodeId2, a2);
            return;
        }
        this.at(string);
        objectArray = null;
        if (object2 == null) {
            nArray = new int[n2];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = -1;
            }
        } else {
            nArray = MultiDimensionArrayUtils.getArrayLengths(object2);
            objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object2, nArray, clazz2);
            int n3 = objectArray.length;
            this.assertArrayLength(n3);
        }
        this.a("Dimensions", nArray);
        this.a("Elements", (Object)objectArray, clazz2, uaNodeId2, 1);
        this.endElement();
    }

    private void a(Boolean bl) throws EncodingException {
        if (this.a(bl, () -> this.a(false))) {
            return;
        }
        this.as(bl.toString());
    }

    private void a(UnsignedByte unsignedByte) throws EncodingException {
        if (this.a(unsignedByte, () -> this.a(UnsignedByte.ZERO))) {
            return;
        }
        this.as(unsignedByte.toString());
    }

    private void b(byte[] byArray) {
        if (this.q(byArray)) {
            return;
        }
        String string = CryptoUtil.base64Encode(byArray);
        this.as(string);
    }

    private void k(DataValue dataValue) throws EncodingException {
        UnsignedShort unsignedShort;
        DateTime dateTime;
        UnsignedShort unsignedShort2;
        DateTime dateTime2;
        StatusCode statusCode;
        if (this.a(dataValue, () -> this.k(new DataValue(Variant.NULL, StatusCode.GOOD, DateTime.MIN_VALUE, UnsignedShort.ZERO, DateTime.MIN_VALUE, UnsignedShort.ZERO)))) {
            return;
        }
        Variant variant = dataValue.getValue();
        if (variant != null) {
            this.putVariant("Value", variant);
        }
        if ((statusCode = dataValue.getStatusCode()) != null) {
            this.putStatusCode("StatusCode", statusCode);
        }
        if ((dateTime2 = dataValue.getSourceTimestamp()) != null) {
            this.putDateTime("SourceTimestamp", dateTime2);
        }
        if ((unsignedShort2 = dataValue.getSourcePicoseconds()) != null) {
            this.putUInt16("SourcePicoseconds", unsignedShort2);
        }
        if ((dateTime = dataValue.getServerTimestamp()) != null) {
            this.putDateTime("ServerTimestamp", dateTime);
        }
        if ((unsignedShort = dataValue.getServerPicoseconds()) != null) {
            this.putUInt16("ServerPicoseconds", unsignedShort);
        }
    }

    private void e(DateTime dateTime) throws EncodingException {
        String string;
        if (this.a(dateTime, () -> this.e(DateTime.MIN_VALUE))) {
            return;
        }
        if (dateTime.compareTo(DateTime.MIN_VALUE) <= 0) {
            string = tX;
        } else if (dateTime.compareTo(DateTime.MAX_VALUE) >= 0) {
            string = tY;
        } else {
            try {
                string = this.uK.format(dateTime.getTimeInMillis());
            }
            catch (Exception exception) {
                string = tX;
            }
        }
        this.as(string);
    }

    private void b(BigDecimal bigDecimal) throws EncodingException {
        if (this.q(bigDecimal)) {
            return;
        }
        this.putNodeId("TypeId", Identifiers.Decimal);
        this.at("Body");
        UnsignedShort unsignedShort = UnsignedShort.valueOf(bigDecimal.scale());
        this.putUInt16("Scale", unsignedShort);
        this.putString("Value", bigDecimal.unscaledValue().toString());
        this.endElement();
    }

    private void b(DiagnosticInfo diagnosticInfo) throws EncodingException {
        DiagnosticInfo diagnosticInfo2;
        StatusCode statusCode;
        String string;
        Integer n2;
        Integer n3;
        Integer n4;
        if (this.a(diagnosticInfo, () -> this.b(new DiagnosticInfo()))) {
            return;
        }
        Integer n5 = diagnosticInfo.getSymbolicId();
        if (n5 != null) {
            this.putInt32("SymbolicId", n5);
        }
        if ((n4 = diagnosticInfo.getNamespaceUri()) != null) {
            this.putInt32("NamespaceUri", n4);
        }
        if ((n3 = diagnosticInfo.getLocale()) != null) {
            this.putInt32("Locale", n3);
        }
        if ((n2 = diagnosticInfo.getLocalizedText()) != null) {
            this.putInt32("LocalizedText", n2);
        }
        if ((string = diagnosticInfo.getAdditionalInfo()) != null) {
            this.putString("AdditionalInfo", string);
        }
        if ((statusCode = diagnosticInfo.getInnerStatusCode()) != null) {
            this.putStatusCode("InnerStatusCode", statusCode);
        }
        if ((diagnosticInfo2 = diagnosticInfo.getInnerDiagnosticInfo()) != null) {
            if (this.uS >= this.uT) {
                throw new EncodingException("Max DiagnosticInfo nesting level exceeded");
            }
            ++this.uS;
            this.putDiagnosticInfo("InnerDiagnosticInfo", diagnosticInfo2);
            --this.uS;
        }
    }

    private void c(Double d2) throws EncodingException {
        if (this.a(d2, () -> this.c(0))) {
            return;
        }
        String string = d2.isInfinite() ? (d2 > 0.0 ? "INF" : "-INF") : (d2.isNaN() ? "NaN" : d2.toString());
        this.as(string);
    }

    private void a(Enumeration enumeration) throws EncodingException {
        if (this.q(enumeration)) {
            return;
        }
        String string = null;
        if (enumeration.specification() != null) {
            string = enumeration.specification().getIntToStringMappings().get(enumeration.getValue());
        } else {
            logger.warn("Encountered Enumeration for which .specification returned null, using number form for encoding as a fallback");
        }
        string = string == null ? Integer.toString(enumeration.getValue()) : string + "_" + enumeration.getValue();
        this.as(string);
    }

    private void c(ExpandedNodeId expandedNodeId) throws EncodingException {
        if (this.a(expandedNodeId, () -> this.putString("Identifier", null))) {
            return;
        }
        this.putString("Identifier", expandedNodeId.toString());
    }

    private void b(ExtensionObject extensionObject) throws EncodingException {
        NodeId nodeId;
        if (this.a(extensionObject, () -> {})) {
            return;
        }
        if (!extensionObject.isEncoded()) {
            this.b(ExtensionObject.binaryEncode((Structure)extensionObject.getObject(), this.ctx));
            return;
        }
        try {
            nodeId = this.ctx.getNamespaceTable().toNodeId(extensionObject.getTypeId());
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not convert ExpandedNodeId to NodeId, id: " + extensionObject.getTypeId() + " nst: " + this.ctx.getNamespaceTable().toString(), serviceResultException);
        }
        this.putNodeId("TypeId", nodeId);
        this.at("Body");
        Object object = extensionObject.getObject();
        if (object == null) {
            this.q(null);
        } else if (extensionObject.getEncodeType() == EncodeType.Binary) {
            this.putByteString("ByteString", (ByteString)object);
        } else if (extensionObject.getEncodeType() == EncodeType.Json) {
            String string = (String)object;
            ByteString byteString = ByteString.valueOf(string.getBytes(StandardCharsets.UTF_8));
            this.putByteString("ByteString", byteString);
        } else if (extensionObject.getEncodeType() == EncodeType.Xml) {
            XmlElement xmlElement = (XmlElement)object;
            this.a(xmlElement);
        } else {
            throw new EncodingException("Unexpected object " + (Object)((Object)extensionObject.getEncodeType()));
        }
        this.endElement();
    }

    private void a(Float f2) throws EncodingException {
        if (this.a(f2, () -> this.c(0))) {
            return;
        }
        String string = f2.isInfinite() ? (f2.floatValue() > 0.0f ? "INF" : "-INF") : (f2.isNaN() ? "NaN" : f2.toString());
        this.as(string);
    }

    private void a(UUID uUID) throws EncodingException {
        if (this.a(uUID, () -> this.a(UUID.fromString("00000000-0000-0000-0000-000000000000")))) {
            return;
        }
        this.putString("String", uUID.toString());
    }

    private void a(Short s2) throws EncodingException {
        if (this.a(s2, () -> this.a((short)0))) {
            return;
        }
        this.as(s2.toString());
    }

    private void c(Integer n2) throws EncodingException {
        if (this.a(n2, () -> this.c(0))) {
            return;
        }
        this.as(n2.toString());
    }

    private void a(String string, int[] nArray) throws EncodingException {
        if (nArray == null) {
            this.a(string, null, Integer[].class, UaIds.Int32, 1);
            return;
        }
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = nArray[i2];
        }
        this.a(string, (Object)integerArray, Integer[].class, UaIds.Int32, 1);
    }

    private void b(Long l2) throws EncodingException {
        if (this.a(l2, () -> this.b(0L))) {
            return;
        }
        this.as(l2.toString());
    }

    private void b(LocalizedText localizedText) throws EncodingException {
        if (this.a(localizedText, () -> this.b(new LocalizedText(null, (String)null)))) {
            return;
        }
        localizedText = localizedText.asSingleLocale(this.getLocales());
        String string = localizedText.getLocaleId();
        String string2 = localizedText.getText();
        if (string != null && !string.isEmpty()) {
            this.putString("Locale", string);
        }
        if (string2 != null && !string2.isEmpty()) {
            this.putString("Text", string2);
        }
    }

    private void o(NodeId nodeId) throws EncodingException {
        if (this.a(nodeId, () -> this.putString("Identifier", null))) {
            return;
        }
        this.putString("Identifier", nodeId.toString());
    }

    private void a(String string, UaOptionSet uaOptionSet) throws EncodingException {
        if (uaOptionSet == null) {
            this.a(string, () -> this.c(0));
            return;
        }
        this.put(string, uaOptionSet.getValue(), uaOptionSet.specification().getBaseTypeId(), 0);
    }

    private void d(QualifiedName qualifiedName) throws EncodingException {
        if (this.a(qualifiedName, () -> this.d(new QualifiedName(0, null)))) {
            return;
        }
        Integer n2 = qualifiedName.getNamespaceIndex();
        this.putInt32("NamespaceIndex", n2);
        this.putString("Name", qualifiedName.getName());
    }

    private void a(Byte by) throws EncodingException {
        if (this.a(by, () -> this.a((byte)0))) {
            return;
        }
        this.as(by.toString());
    }

    private void a(StatusCode statusCode) throws EncodingException {
        if (this.a(statusCode, () -> this.a(StatusCode.GOOD))) {
            return;
        }
        this.putUInt32("Code", statusCode.getValue());
    }

    private void H(String string) throws EncodingException {
        if (this.a((Object)string, () -> {})) {
            return;
        }
        this.as(string);
    }

    private void a(Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        EncoderMode encoderMode = this.tw;
        this.tw = EncoderMode.Strict;
        try {
            this.d(structure, structureSpecification);
        }
        catch (Exception exception) {
            throw new EncodingException("Could not encode Structure", exception);
        }
        finally {
            this.tw = encoderMode;
        }
    }

    private void a(UnsignedShort unsignedShort) throws EncodingException {
        if (this.a(unsignedShort, () -> this.a(UnsignedShort.ZERO))) {
            return;
        }
        this.as(unsignedShort.toString());
    }

    private void k(UnsignedInteger unsignedInteger) throws EncodingException {
        if (this.a(unsignedInteger, () -> this.k(UnsignedInteger.ZERO))) {
            return;
        }
        this.as(unsignedInteger.toString());
    }

    private void a(UnsignedLong unsignedLong) throws EncodingException {
        if (this.a(unsignedLong, () -> this.a(UnsignedLong.ZERO))) {
            return;
        }
        this.as(unsignedLong.toString());
    }

    private void a(Variant variant, String string) throws EncodingException {
        if (this.a((Object)variant, () -> this.a(Variant.NULL, string))) {
            return;
        }
        this.c("Value", string);
        this.f(variant);
        this.endElement();
    }

    private void a(XmlElement xmlElement) {
        if (this.q(xmlElement)) {
            return;
        }
        Node node = xmlElement.getNode();
        if (node instanceof Document) {
            node = node.getFirstChild();
        }
        Node node2 = this.uO.importNode(node, true);
        this.uR.appendChild(node2);
    }

    private void a(Object object, Class<?> clazz, UaNodeId uaNodeId, a<Object> a2) throws EncodingException {
        Object[] objectArray = (Object[])object;
        int n2 = objectArray.length;
        this.assertArrayLength(n2);
        if (n2 == 0) {
            return;
        }
        String string = uaNodeId != null && !UaIds.Structure.equals(uaNodeId) ? (UaIds.BaseDataType.equals(uaNodeId) ? "Variant" : this.ctx.getDataTypeSpecification(uaNodeId).getName()) : clazz.getSimpleName();
        for (Object object2 : objectArray) {
            UaNodeId uaNodeId2 = uaNodeId;
            if (object2 instanceof Structure) {
                uaNodeId2 = ((Structure)object2).specification().getTypeId();
            }
            a2.put(this, string, object2, uaNodeId2);
        }
    }

    private void a(String string, Object object, Class<?> clazz, UaNodeId uaNodeId, a<Object> a2) throws EncodingException {
        if (object == null) {
            return;
        }
        this.at(string);
        this.a(object, clazz, uaNodeId, a2);
        this.endElement();
    }

    private void a(String string, b b2) throws EncodingException {
        if (string == null) {
            b2.serialize();
            return;
        }
        this.at(string);
        b2.serialize();
        this.endElement();
    }

    private void putNull() {
        this.uR.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.uR.setAttribute("xsi:nil", "true");
    }

    private void d(Structure structure, StructureSpecification structureSpecification) throws Exception {
        if (structure == null) {
            structure = structureSpecification.toInstanceBuilder().build();
        }
        Map<FieldSpecification, Object> map = structure.toFieldsMap(structureSpecification);
        if (StructureSpecification.StructureType.UNION == structureSpecification.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == structureSpecification.getStructureType()) {
            long l2 = 0L;
            FieldSpecification fieldSpecification = null;
            Object object = null;
            for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
                ++l2;
                if (entry.getValue() == null) continue;
                fieldSpecification = entry.getKey();
                object = entry.getValue();
                break;
            }
            if (fieldSpecification == null) {
                this.putUInt32("SwitchField", UnsignedInteger.ZERO);
                return;
            }
            this.putUInt32("SwitchField", UnsignedInteger.valueOf(l2));
            int n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
            this.put(fieldSpecification.getName(), object, fieldSpecification.getDataTypeId(), n2);
            return;
        }
        if (StructureSpecification.StructureType.OPTIONAL == structureSpecification.getStructureType()) {
            int n3 = -1;
            long l3 = 0L;
            for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
                if (!entry.getKey().isOptional()) continue;
                ++n3;
                if (entry.getValue() == null) continue;
                l3 |= (long)(1 << n3);
            }
            this.putUInt64("EncodingMask", UnsignedLong.getFromBits(l3));
        }
        for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
            FieldSpecification fieldSpecification = entry.getKey();
            Object object = entry.getValue();
            if (fieldSpecification.isOptional() && object == null || object == null && fieldSpecification.getDataTypeId().equals(UaIds.BaseDataType)) continue;
            this.put(fieldSpecification.getName(), object, fieldSpecification.getEncodeTypeId(), fieldSpecification.getJavaClassDimensions());
        }
    }

    private void as(String string) {
        this.uR.appendChild(this.uO.createTextNode(string));
    }

    private void f(Variant variant) throws EncodingException {
        boolean bl;
        if (this.q(variant.getValue())) {
            return;
        }
        if (Structure.class.isAssignableFrom(variant.getCompositeClass())) {
            try {
                variant = new Variant(MultiDimensionArrayUtils.map(variant.getValue(), Structure.class, ExtensionObject.class, structure -> {
                    try {
                        return ExtensionObject.xmlEncode(structure, this.getEncoderContext(), true);
                    }
                    catch (EncodingException encodingException) {
                        throw new RuntimeException(encodingException);
                    }
                }));
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getCause() instanceof EncodingException) {
                    throw (EncodingException)runtimeException.getCause();
                }
                throw new EncodingException(runtimeException);
            }
        }
        ExtensionObject[] extensionObjectArray = variant.getValue();
        Class<Object> clazz = variant.getCompositeClass();
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            bl = true;
            clazz = ExtensionObject.class;
        } else {
            bl = false;
        }
        UaNodeId uaNodeId = tE.getLeft(clazz);
        logger.trace("class->id, {} -> {}", (Object)clazz, (Object)uaNodeId);
        String string = uaNodeId != null && !UaIds.Structure.equals(uaNodeId) ? (UaIds.BaseDataType.equals(uaNodeId) ? "Variant" : this.ctx.getDataTypeSpecification(uaNodeId).getName()) : clazz.getSimpleName();
        if (!variant.isArray()) {
            if (bl) {
                extensionObjectArray = this.a((BigDecimal)extensionObjectArray);
            }
            this.a(string, (Object)extensionObjectArray, clazz, uaNodeId, 0);
            return;
        }
        int n2 = variant.getDimension();
        if (n2 == 1) {
            if (bl) {
                extensionObjectArray = this.a((BigDecimal[])extensionObjectArray);
            }
            this.a("ListOf" + string, (Object)extensionObjectArray, clazz, uaNodeId, 1);
            return;
        }
        if (bl) {
            int[] nArray = variant.getArrayDimensions();
            int n3 = MultiDimensionArrayUtils.getLength(nArray);
            MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(variant.getValue(), nArray);
            ExtensionObject[] extensionObjectArray2 = new ExtensionObject[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                extensionObjectArray2[i2] = this.a((BigDecimal)arrayIterator.next());
            }
            extensionObjectArray = extensionObjectArray2;
        }
        this.a("Matrix", (Object)extensionObjectArray, clazz, uaNodeId, n2);
    }

    private Element at(String string) {
        return this.c(string, null);
    }

    private Element c(String string, String string2) {
        Element element = !this.uV ? this.uO.createElement(string) : (string2 != null ? this.uO.createElementNS(string2, string) : (this.uP.peek() == null ? this.uO.createElementNS("http://opcfoundation.org/UA/2008/02/Types.xsd", string) : this.uO.createElementNS(this.uP.peek(), string)));
        if (this.uQ == null) {
            this.uQ = element;
        } else if (this.uR != null) {
            this.uR.appendChild(element);
        }
        this.uR = element;
        return element;
    }

    ExtensionObject[] a(BigDecimal[] bigDecimalArray) throws EncodingException {
        if (bigDecimalArray == null) {
            return new ExtensionObject[0];
        }
        ExtensionObject[] extensionObjectArray = new ExtensionObject[bigDecimalArray.length];
        for (int i2 = 0; i2 < bigDecimalArray.length; ++i2) {
            extensionObjectArray[i2] = this.a(bigDecimalArray[i2]);
        }
        return extensionObjectArray;
    }

    ExtensionObject a(BigDecimal bigDecimal) throws EncodingException {
        XmlEncoder xmlEncoder = new XmlEncoder(this.ctx, this.uV);
        xmlEncoder.b(bigDecimal);
        Element element = this.uO.createElement("Decimal");
        NodeList nodeList = xmlEncoder.uQ.getLastChild().getChildNodes();
        element.appendChild(this.uO.importNode(nodeList.item(0), true));
        element.appendChild(this.uO.importNode(nodeList.item(1), true));
        return new ExtensionObject(tf, new XmlElement(element));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    void put(String string, Object object) throws EncodingException {
        UaNodeId uaNodeId;
        if (object == null) {
            throw new EncodingException("the put(fieldname, obj) cannot be used for null values");
        }
        Class<?> clazz = MultiDimensionArrayUtils.getComponentType(object.getClass());
        int n2 = MultiDimensionArrayUtils.getDimension(object);
        if (Enumeration.class.isAssignableFrom(clazz)) {
            if (!(object instanceof Enumeration)) throw new EncodingException("the put(fieldname, obj) cannot be used for arrays of Enumerations");
            uaNodeId = ((Enumeration)object).specification().getTypeId();
        } else if (Structure.class.isAssignableFrom(clazz)) {
            if (!(object instanceof Structure)) throw new EncodingException("the put(fieldname, obj) cannot be used for arrays of Structures");
            uaNodeId = ((Structure)object).specification().getTypeId();
        } else if (UaOptionSet.class.isAssignableFrom(clazz)) {
            if (!(object instanceof UaOptionSet)) throw new EncodingException("the put(fieldname, obj) cannot be used for arrays of UaOptionSet");
            uaNodeId = ((UaOptionSet)object).specification().getTypeId();
        } else {
            uaNodeId = Variant.class.isAssignableFrom(clazz) ? UaIds.BaseDataType : tE.getLeft(clazz);
        }
        if (uaNodeId == null) {
            throw new EncodingException("Unsupported class: " + object.getClass());
        }
        this.a(string, object, object.getClass(), uaNodeId, n2);
    }

    static {
        tf = new ExpandedNodeId("http://opcfoundation.org/UA/", Identifiers.Decimal.getValue());
        XmlEncoder.b(UaIds.Boolean, Boolean.class, (xmlEncoder, string, bl, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((Boolean)bl)));
        XmlEncoder.b(UaIds.SByte, Byte.class, (xmlEncoder, string, by, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((Byte)by)));
        XmlEncoder.b(UaIds.Byte, UnsignedByte.class, (xmlEncoder, string, unsignedByte, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((UnsignedByte)unsignedByte)));
        XmlEncoder.b(UaIds.Int16, Short.class, (xmlEncoder, string, s2, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((Short)s2)));
        XmlEncoder.b(UaIds.UInt16, UnsignedShort.class, (xmlEncoder, string, unsignedShort, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((UnsignedShort)unsignedShort)));
        XmlEncoder.b(UaIds.Int32, Integer.class, (xmlEncoder, string, n2, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.c((Integer)n2)));
        XmlEncoder.b(UaIds.UInt32, UnsignedInteger.class, (xmlEncoder, string, unsignedInteger, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.k((UnsignedInteger)unsignedInteger)));
        XmlEncoder.b(UaIds.Int64, Long.class, (xmlEncoder, string, l2, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.b((Long)l2)));
        XmlEncoder.b(UaIds.UInt64, UnsignedLong.class, (xmlEncoder, string, unsignedLong, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((UnsignedLong)unsignedLong)));
        XmlEncoder.b(UaIds.Float, Float.class, (xmlEncoder, string, f2, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((Float)f2)));
        XmlEncoder.b(UaIds.Double, Double.class, (xmlEncoder, string, d2, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.c((Double)d2)));
        XmlEncoder.b(UaIds.String, String.class, (xmlEncoder, string, string2, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.H((String)string2)));
        XmlEncoder.b(UaIds.Guid, UUID.class, (xmlEncoder, string, uUID, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((UUID)uUID)));
        XmlEncoder.b(UaIds.ByteString, ByteString.class, (xmlEncoder, string, byteString, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.b(ByteString.asByteArray(byteString))));
        XmlEncoder.b(UaIds.XmlElement, XmlElement.class, (xmlEncoder, string, xmlElement, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((XmlElement)xmlElement)));
        XmlEncoder.b(UaIds.NodeId, NodeId.class, (xmlEncoder, string, nodeId, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.o((NodeId)nodeId)));
        XmlEncoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (xmlEncoder, string, expandedNodeId, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.c((ExpandedNodeId)expandedNodeId)));
        XmlEncoder.b(UaIds.StatusCode, StatusCode.class, (xmlEncoder, string, statusCode, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((StatusCode)statusCode)));
        XmlEncoder.b(UaIds.QualifiedName, QualifiedName.class, (xmlEncoder, string, qualifiedName, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.d((QualifiedName)qualifiedName)));
        XmlEncoder.b(UaIds.LocalizedText, LocalizedText.class, (xmlEncoder, string, localizedText, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.b((LocalizedText)localizedText)));
        uB = (xmlEncoder, string, dateTime, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.e((DateTime)dateTime));
        XmlEncoder.a(UaIds.DateTime, DateTime.class, uB);
        uC = (xmlEncoder, string, extensionObject, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.b((ExtensionObject)extensionObject));
        uD = (xmlEncoder, string, structure, uaNodeId) -> {
            StructureSpecification structureSpecification = xmlEncoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new EncodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            String string2 = "http://opcfoundation.org/UA/2008/02/Types.xsd";
            if (!UaNamespace.STANDARD.equals(structureSpecification.getTypeId().getNamespace())) {
                string2 = structureSpecification.getTypeId().getNamespaceUri();
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                string2 = string2 + "Types.xsd";
            }
            xmlEncoder.uP.push(string2);
            xmlEncoder.a(string, () -> xmlEncoder.a((Structure)structure, structureSpecification));
            xmlEncoder.uP.pop();
        };
        XmlEncoder.a(UaIds.Structure, ExtensionObject.class, uC);
        uE = (xmlEncoder, string, dataValue, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.k((DataValue)dataValue));
        XmlEncoder.a(UaIds.DataValue, DataValue.class, uE);
        uF = (xmlEncoder, string, variant, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((Variant)variant, null));
        uG = (xmlEncoder, string, diagnosticInfo, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.b((DiagnosticInfo)diagnosticInfo));
        XmlEncoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, uG);
        uH = (xmlEncoder, string, enumeration, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.a((Enumeration)enumeration));
        uI = (xmlEncoder, string, bigDecimal, uaNodeId) -> xmlEncoder.a(string, () -> xmlEncoder.b((BigDecimal)bigDecimal));
        XmlEncoder.a(UaIds.Decimal, BigDecimal.class, uI);
        uJ = (xmlEncoder, string, uaOptionSet, uaNodeId) -> xmlEncoder.a(string, (UaOptionSet)uaOptionSet);
        XmlEncoder.b(null, Object.class, (xmlEncoder, string, object, uaNodeId) -> {
            if (object == null) {
                uF.put(xmlEncoder, string, null, UaIds.BaseDataType);
            } else if (object instanceof Variant) {
                uF.put(xmlEncoder, string, (Variant)object, UaIds.BaseDataType);
            } else {
                uF.put(xmlEncoder, string, new Variant(object), UaIds.BaseDataType);
            }
        });
    }

    private static interface b {
        public void serialize() throws EncodingException;
    }

    private static interface a<T> {
        public void put(XmlEncoder var1, String var2, T var3, UaNodeId var4) throws EncodingException;
    }
}

