/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.json;

import com.prosysopc.ua.InternalHasDataTypeId;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.DataSetFieldContentMask;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.AbstactEncoder;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEncoder
extends AbstactEncoder
implements IEncoder {
    private static final Logger logger = LoggerFactory.getLogger(JsonEncoder.class);
    private static final String tV = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static DateTimeFormatter tW = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ROOT).withZone(ZoneOffset.UTC);
    private static final Map<UaNodeId, a<?>> tD = new HashMap();
    private static final BijectionMap<UaNodeId, Class<?>> tE = new BijectionMap();
    private static final String tX = "0001-01-01T00:00:00Z";
    private static final String tY = "9999-12-31T23:59:59Z";
    private static final Map<Class<?>, a<?>> sS = new HashMap();
    private static final a<DateTime> tZ;
    private static final a<ExtensionObject> ua;
    private static final a<Structure> ub;
    private static final a<DataValue> uc;
    private static final a<Variant> ud;
    private static final a<DiagnosticInfo> ue;
    private static final a<Enumeration> uf;
    private static final a<BigDecimal> ug;
    private static final a<UaOptionSet> uh;
    private List<Integer> ui = new ArrayList<Integer>();
    private boolean uj = true;
    private boolean uk = true;
    private final Writer writer;
    private List<Integer> ul = new ArrayList<Integer>();
    private int um;
    private int un;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId != null) {
            if (tD.put(uaNodeId, a2) != null) {
                throw new Error("DataType " + uaNodeId + " already has a serializer defined");
            }
            if (tE.containsLeft(uaNodeId)) {
                throw new Error("DataType " + uaNodeId + " already mapped to a class");
            }
            if (tE.containsRight(clazz)) {
                throw new Error("Class " + clazz + " already mapped to a DataTypeId");
            }
            tE.map(uaNodeId, clazz);
        }
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        a<T> a3 = sS.put(clazz, a2);
        if (a3 != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        JsonEncoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> i(Class<?> clazz) throws EncodingException {
        a<?> a2 = sS.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return ua;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return ub;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return uc;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return ud;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return ue;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return uf;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return tZ;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return ug;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return uh;
        }
        throw new EncodingException("Cannot encode class: " + clazz);
    }

    private static a<Object> b(UaNodeId uaNodeId, EncoderContext encoderContext, AtomicReference<Class<?>> atomicReference) throws EncodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            atomicReference.set(Object.class);
            return JsonEncoder.i(Object.class);
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            atomicReference.set(ExtensionObject.class);
            return JsonEncoder.i(ExtensionObject.class);
        }
        a<Object> a2 = tD.get(uaNodeId);
        if (a2 == null) {
            UaDataTypeSpecification uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = tD.get(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = ub;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = uh;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = uf;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            }
        } else {
            atomicReference.set(tE.getRight(uaNodeId));
        }
        if (a2 == null) {
            throw new EncodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        if (atomicReference.get() == null) {
            throw new EncodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
        }
        return a2;
    }

    private static void a(Throwable throwable, String string, Object object) throws EncodingException {
        String string2 = String.format(Locale.ROOT, "fieldname=%s, value=%s", string, object);
        if (throwable instanceof ClosedChannelException) {
            throw new EncodingException(StatusCodes.Bad_ConnectionClosed, throwable, string2);
        }
        if (throwable instanceof EOFException) {
            throw new EncodingException(StatusCodes.Bad_EndOfStream, throwable, string2);
        }
        if (throwable instanceof ConnectException) {
            throw new EncodingException(StatusCodes.Bad_ConnectionRejected, throwable, string2);
        }
        if (throwable instanceof SocketException) {
            throw new EncodingException(StatusCodes.Bad_CommunicationError, throwable, string2);
        }
        throw new EncodingException(StatusCodes.Bad_UnexpectedError, throwable, string2);
    }

    public JsonEncoder(EncoderContext encoderContext, Writer writer) {
        super(encoderContext);
        this.writer = writer;
        this.um = -1;
        this.un = -1;
    }

    public void beginArray() throws EncodingException {
        try {
            this.writer.write("[");
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "beginArray", null);
        }
        ++this.un;
        this.ul.add(0);
    }

    public void beginArray(String string) throws EncodingException {
        this.K(string);
        this.beginArray();
    }

    public void beginObject() throws EncodingException {
        try {
            this.writer.write(123);
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "beginObject", null);
        }
        ++this.um;
        this.ui.add(0);
    }

    public void beginObject(String string) throws EncodingException {
        this.K(string);
        this.beginObject();
    }

    public void close() throws EncodingException {
        if (this.um > 0) {
            throw new EncodingException("JsonEncoder: close called without matching beginObject/endObject calls");
        }
        if (this.un > 0) {
            throw new EncodingException("JsonEncoder: close called without matching beginArray/endArray calls");
        }
        if (this.um == 0) {
            this.endObject();
        }
        if (this.un == 0) {
            this.endArray();
        }
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "close", null);
        }
    }

    public void endArray() throws EncodingException {
        if (this.ul.size() > this.un) {
            if (this.ul.size() > this.un + 1) {
                throw new EncodingException("JsonEncoder: endArray called with invalid arrayIndex list");
            }
            this.ul.remove(this.un);
        }
        if (this.un-- < 0) {
            throw new EncodingException("JsonEncoder: endArray called without beginArray");
        }
        try {
            this.writer.write("]");
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "endArray", null);
        }
    }

    public void endObject() throws EncodingException {
        if (this.ui.size() > this.um) {
            if (this.ui.size() > this.um + 1) {
                throw new EncodingException("JsonEncoder: endObject called with invalid fieldIndex list");
            }
            this.ui.remove(this.um);
        }
        if (this.um-- < 0) {
            throw new EncodingException("JsonEncoder: endObject called without beginObject");
        }
        try {
            this.writer.write(125);
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "endObject", this.um);
        }
    }

    @Override
    public List<Locale> getLocales() {
        return new ArrayList<Locale>();
    }

    public boolean getReversibleEncoding() {
        return this.uj;
    }

    public boolean isNodeIdJsonObjects() {
        return this.uk;
    }

    @Override
    public void put(String string, Object object, UaNodeId uaNodeId, int n2) throws EncodingException {
        this.a(string, object, null, uaNodeId, n2);
    }

    public void putArrayElement(Object object) throws EncodingException {
        this.eBL();
        this.o(object);
    }

    @Override
    public void putBoolean(String string, Boolean bl) throws EncodingException {
        this.putObject(string, bl);
    }

    @Override
    public void putBooleanArray(String string, Boolean[] booleanArray) throws EncodingException {
        this.a(string, booleanArray);
    }

    @Override
    public void putBooleanArray(String string, Collection<Boolean> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putByte(String string, UnsignedByte unsignedByte) throws EncodingException {
        this.putObject(string, unsignedByte);
    }

    @Override
    public void putByteArray(String string, Collection<UnsignedByte> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putByteArray(String string, UnsignedByte[] unsignedByteArray) throws EncodingException {
        this.a(string, unsignedByteArray);
    }

    @Override
    public void putByteString(String string, ByteString byteString) throws EncodingException {
        if (byteString != null) {
            this.putObject(string, byteString.getValue());
        }
    }

    @Override
    public void putByteStringArray(String string, ByteString[] byteStringArray) throws EncodingException {
        this.a(string, byteStringArray);
    }

    @Override
    public void putByteStringArray(String string, Collection<ByteString> collection) throws EncodingException {
        this.a(string, collection);
    }

    public void putComma() throws EncodingException {
        try {
            this.writer.write(",");
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "", "comma");
        }
    }

    @Override
    public void putDataValue(String string, DataValue dataValue) throws EncodingException {
        if (dataValue != null) {
            this.K(string);
            this.beginObject();
            if (dataValue.getValue().getValue() != null) {
                this.putVariant("Value", dataValue.getValue());
            }
            if (dataValue.getStatusCode() != StatusCode.GOOD) {
                this.putStatusCode("Status", dataValue.getStatusCode());
            }
            if (dataValue.getSourceTimestamp() != null) {
                this.putObject("SourceTimestamp", dataValue.getSourceTimestamp());
            }
            if (dataValue.getSourcePicoseconds() != null && dataValue.getSourcePicoseconds().intValue() != 0) {
                this.putObject("SourcePicoSeconds", dataValue.getSourcePicoseconds());
            }
            if (dataValue.getServerTimestamp() != null) {
                this.putObject("ServerTimestamp", dataValue.getServerTimestamp());
            }
            if (dataValue.getServerPicoseconds() != null && dataValue.getServerPicoseconds().intValue() != 0) {
                this.putObject("ServerPicoSeconds", dataValue.getServerPicoseconds());
            }
            this.endObject();
        }
    }

    public void putDataValue(String string, DataValue dataValue, DataSetFieldContentMask dataSetFieldContentMask) throws EncodingException {
        if (dataValue != null) {
            boolean bl;
            boolean bl2 = dataSetFieldContentMask.contains(DataSetFieldContentMask.Options.RawData);
            boolean bl3 = bl = bl2 || ((UnsignedInteger)dataSetFieldContentMask.asBuiltInType()).getValue() == 0L;
            if (bl2 || bl) {
                this.putVariant(string, dataValue.getValue());
            } else {
                this.K(string);
                this.beginObject();
                this.putVariant("Value", dataValue.getValue());
                if (dataSetFieldContentMask.contains(DataSetFieldContentMask.Options.StatusCode) && dataValue.getStatusCode() != StatusCode.GOOD) {
                    this.putStatusCode("Status", dataValue.getStatusCode());
                }
                if (dataSetFieldContentMask.contains(DataSetFieldContentMask.Options.SourceTimestamp)) {
                    this.putObject("SourceTimestamp", dataValue.getSourceTimestamp());
                    if (dataValue.getSourcePicoseconds() != null && dataValue.getSourcePicoseconds().intValue() != 0) {
                        this.putObject("SourcePicoSeconds", dataValue.getSourcePicoseconds());
                    }
                }
                if (dataSetFieldContentMask.contains(DataSetFieldContentMask.Options.ServerTimestamp)) {
                    this.putObject("ServerTimestamp", dataValue.getServerTimestamp());
                    if (dataValue.getServerPicoseconds() != null && dataValue.getServerPicoseconds().intValue() != 0) {
                        this.putObject("ServerPicoSeconds", dataValue.getServerPicoseconds());
                    }
                }
                this.endObject();
            }
        }
    }

    @Override
    public void putDataValueArray(String string, Collection<DataValue> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.assertArrayLength(collection.size());
            this.beginArray();
            for (DataValue dataValue : collection) {
                this.eBL();
                if (dataValue == null) {
                    this.putNull();
                    continue;
                }
                this.putDataValue(null, dataValue);
            }
            this.endArray();
        }
    }

    @Override
    public void putDataValueArray(String string, DataValue[] dataValueArray) throws EncodingException {
        if (dataValueArray != null) {
            this.K(string);
            this.assertArrayLength(dataValueArray.length);
            this.beginArray();
            for (DataValue dataValue : dataValueArray) {
                this.eBL();
                if (dataValue == null) {
                    this.putNull();
                    continue;
                }
                this.putDataValue(null, dataValue);
            }
            this.endArray();
        }
    }

    @Override
    public void putDateTime(String string, DateTime dateTime) throws EncodingException {
        this.putObject(string, dateTime);
    }

    @Override
    public void putDateTimeArray(String string, Collection<DateTime> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putDateTimeArray(String string, DateTime[] dateTimeArray) throws EncodingException {
        this.a(string, dateTimeArray);
    }

    @Override
    public void putDiagnosticInfo(String string, DiagnosticInfo diagnosticInfo) throws EncodingException {
        if (diagnosticInfo != null) {
            this.K(string);
            this.beginObject();
            this.putObject("SymbolicId", diagnosticInfo.getSymbolicId());
            this.putObject("NamespaceUri", diagnosticInfo.getNamespaceUri());
            this.putObject("Locale", diagnosticInfo.getLocale());
            this.putObject("LocalizedText", diagnosticInfo.getLocalizedText());
            this.putObject("Additional Info", diagnosticInfo.getAdditionalInfo());
            if (diagnosticInfo.getInnerStatusCode() != null && diagnosticInfo.getInnerStatusCode().isNotGood()) {
                if (this.uj) {
                    this.putObject("Inner StatusCode", diagnosticInfo.getInnerStatusCode().getValue());
                } else {
                    this.putStatusCode(null, diagnosticInfo.getInnerStatusCode());
                }
            }
            if (diagnosticInfo.getInnerDiagnosticInfo() != null) {
                this.putDiagnosticInfo("Inner DiagnosticInfo", diagnosticInfo.getInnerDiagnosticInfo());
            }
            this.endObject();
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, Collection<DiagnosticInfo> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.assertArrayLength(collection.size());
            this.beginArray();
            for (DiagnosticInfo diagnosticInfo : collection) {
                this.eBL();
                if (diagnosticInfo == null) {
                    this.putNull();
                    continue;
                }
                this.putDiagnosticInfo(null, diagnosticInfo);
            }
            this.endArray();
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, DiagnosticInfo[] diagnosticInfoArray) throws EncodingException {
        if (diagnosticInfoArray != null) {
            this.K(string);
            this.assertArrayLength(diagnosticInfoArray.length);
            this.beginArray();
            for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
                this.eBL();
                if (diagnosticInfo == null) {
                    this.putNull();
                    continue;
                }
                this.putDiagnosticInfo(null, diagnosticInfo);
            }
            this.endArray();
        }
    }

    @Override
    public void putDouble(String string, double d2) throws EncodingException {
        this.putObject(string, d2);
    }

    @Override
    public void putDouble(String string, Double d2) throws EncodingException {
        this.putObject(string, d2);
    }

    @Override
    public void putDoubleArray(String string, Collection<Double> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putDoubleArray(String string, Double[] doubleArray) throws EncodingException {
        this.a(string, doubleArray);
    }

    @Override
    public void putExpandedNodeId(String string, ExpandedNodeId expandedNodeId) throws EncodingException {
        if (expandedNodeId != null) {
            if (this.uk) {
                this.K(string);
                this.beginObject();
                this.r(expandedNodeId.getIdType().getValue());
                this.putObject("Id", expandedNodeId.getValue());
                if (expandedNodeId.getNamespaceUri() != null) {
                    this.a("Namespace", this.ctx.getNamespaceTable().getIndex(expandedNodeId.getNamespaceUri()));
                } else {
                    this.a("Namespace", expandedNodeId.getNamespaceIndex());
                }
                this.l(expandedNodeId.getServerIndex());
                this.endObject();
            } else {
                if (!expandedNodeId.isLocal()) {
                    throw new EncodingException("Only local ExpandedNodeIds are currently supported in this mode, id:" + expandedNodeId);
                }
                try {
                    this.putNodeId(string, this.ctx.getNamespaceTable().toNodeId(expandedNodeId));
                }
                catch (EncodingException encodingException) {
                    throw encodingException;
                }
                catch (ServiceResultException serviceResultException) {
                    throw new EncodingException("Cannot treat local ExpandedNodeId as NodeId, id: " + expandedNodeId, serviceResultException);
                }
            }
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, Collection<ExpandedNodeId> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.assertArrayLength(collection.size());
            this.beginArray();
            for (ExpandedNodeId expandedNodeId : collection) {
                this.eBL();
                if (expandedNodeId == null) {
                    this.putNull();
                    continue;
                }
                this.putExpandedNodeId(null, expandedNodeId);
            }
            this.endArray();
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, ExpandedNodeId[] expandedNodeIdArray) throws EncodingException {
        if (expandedNodeIdArray != null) {
            this.K(string);
            this.assertArrayLength(expandedNodeIdArray.length);
            this.beginArray();
            for (ExpandedNodeId expandedNodeId : expandedNodeIdArray) {
                this.eBL();
                if (expandedNodeId == null) {
                    this.putNull();
                    continue;
                }
                this.putExpandedNodeId(null, expandedNodeId);
            }
            this.endArray();
        }
    }

    @Override
    public void putExtensionObject(String string, ExtensionObject extensionObject) throws EncodingException {
        if (extensionObject != null) {
            Object object;
            UaNodeId uaNodeId;
            this.K(string);
            this.beginObject();
            if (extensionObject.getTypeId() != null && this.getReversibleEncoding()) {
                this.putExpandedNodeId("TypeId", extensionObject.getTypeId());
            } else if (this.getReversibleEncoding() && extensionObject.getObject() instanceof Structure && (uaNodeId = (object = ((Structure)extensionObject.getObject()).specification()).getJsonEncodeId()) != null) {
                this.putExpandedNodeId("TypeId", uaNodeId.asExpandedNodeId());
            }
            object = extensionObject.getObject();
            if (object != null) {
                if (object instanceof ByteString) {
                    if (this.getReversibleEncoding()) {
                        this.putObject("Encoding", 1);
                    }
                    this.putByteString("Body", (ByteString)object);
                } else if (object instanceof XmlElement) {
                    if (this.getReversibleEncoding()) {
                        this.putObject("Encoding", 2);
                    }
                    this.putXmlElement("Body", (XmlElement)object);
                } else {
                    this.putStructure("Body", (Structure)extensionObject.getObject());
                }
            }
            this.endObject();
        }
    }

    @Override
    public void putExtensionObjectArray(String string, Collection<ExtensionObject> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.assertArrayLength(collection.size());
            this.beginArray();
            for (ExtensionObject extensionObject : collection) {
                this.eBL();
                if (extensionObject == null) {
                    this.putNull();
                    continue;
                }
                this.putExtensionObject(null, extensionObject);
            }
            this.endArray();
        }
    }

    @Override
    public void putExtensionObjectArray(String string, ExtensionObject[] extensionObjectArray) throws EncodingException {
        if (extensionObjectArray != null) {
            this.K(string);
            this.assertArrayLength(extensionObjectArray.length);
            this.beginArray();
            for (ExtensionObject extensionObject : extensionObjectArray) {
                this.eBL();
                if (extensionObject == null) {
                    this.putNull();
                    continue;
                }
                this.putExtensionObject(null, extensionObject);
            }
            this.endArray();
        }
    }

    @Override
    public void putFloat(String string, float f2) throws EncodingException {
        this.putObject(string, Float.valueOf(f2));
    }

    @Override
    public void putFloat(String string, Float f2) throws EncodingException {
        this.putObject(string, f2);
    }

    @Override
    public void putFloatArray(String string, Collection<Float> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putFloatArray(String string, Float[] floatArray) throws EncodingException {
        this.a(string, floatArray);
    }

    @Override
    public void putGuid(String string, UUID uUID) throws EncodingException {
        this.putObject(string, uUID);
    }

    @Override
    public void putGuidArray(String string, Collection<UUID> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putGuidArray(String string, UUID[] uUIDArray) throws EncodingException {
        this.a(string, uUIDArray);
    }

    @Override
    public void putInt16(String string, short s2) throws EncodingException {
        this.putObject(string, s2);
    }

    @Override
    public void putInt16(String string, Short s2) throws EncodingException {
        this.putObject(string, s2);
    }

    @Override
    public void putInt16Array(String string, Collection<Short> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putInt16Array(String string, Short[] shortArray) throws EncodingException {
        this.a(string, shortArray);
    }

    @Override
    public void putInt32(String string, int n2) throws EncodingException {
        this.putObject(string, n2);
    }

    @Override
    public void putInt32(String string, Integer n2) throws EncodingException {
        this.putObject(string, n2);
    }

    @Override
    public void putInt32Array(String string, Collection<Integer> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putInt32Array(String string, int[] nArray) throws EncodingException {
        if (nArray != null) {
            this.assertArrayLength(nArray.length);
            this.K(string);
            this.beginArray();
            for (int n2 : nArray) {
                this.putArrayElement(n2);
            }
            this.endArray();
        }
    }

    @Override
    public void putInt32Array(String string, Integer[] integerArray) throws EncodingException {
        this.a(string, integerArray);
    }

    @Override
    public void putInt64(String string, long l2) throws EncodingException {
        this.putObject(string, l2);
    }

    @Override
    public void putInt64(String string, Long l2) throws EncodingException {
        this.putObject(string, l2);
    }

    @Override
    public void putInt64Array(String string, Collection<Long> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putInt64Array(String string, Long[] longArray) throws EncodingException {
        this.a(string, longArray);
    }

    @Override
    public void putLocalizedText(String string, LocalizedText localizedText) throws EncodingException {
        if (localizedText != null) {
            this.K(string);
            localizedText = localizedText.asSingleLocale(this.getLocales());
            String string2 = localizedText.getLocaleId();
            String string3 = localizedText.getText();
            if (this.uj) {
                this.beginObject();
                if (string3 != null && !string3.isEmpty()) {
                    this.putObject("Text", string3);
                }
                if (string2 != null && !string2.isEmpty()) {
                    this.putObject("Locale", string2);
                }
                this.endObject();
            } else {
                this.o(localizedText.getText());
            }
        }
    }

    @Override
    public void putLocalizedTextArray(String string, Collection<LocalizedText> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.assertArrayLength(collection.size());
            this.beginArray();
            for (LocalizedText localizedText : collection) {
                this.eBL();
                if (localizedText == null) {
                    this.putNull();
                    continue;
                }
                this.putLocalizedText(null, localizedText);
            }
            this.endArray();
        }
    }

    @Override
    public void putLocalizedTextArray(String string, LocalizedText[] localizedTextArray) throws EncodingException {
        if (localizedTextArray != null) {
            this.K(string);
            this.assertArrayLength(localizedTextArray.length);
            this.beginArray();
            for (LocalizedText localizedText : localizedTextArray) {
                this.eBL();
                if (localizedText == null) {
                    this.putNull();
                    continue;
                }
                this.putLocalizedText(null, localizedText);
            }
            this.endArray();
        }
    }

    @Override
    public void putNodeId(String string, NodeId nodeId) throws EncodingException {
        if (nodeId != null) {
            if (this.uk) {
                this.K(string);
                this.beginObject();
                this.r(nodeId.getIdType().getValue());
                this.putObject("Id", nodeId.getValue());
                this.a("Namespace", nodeId.getNamespaceIndex());
                this.endObject();
            } else if (nodeId.getNamespaceIndex() == 0) {
                this.putString(string, nodeId.toString());
            } else {
                this.putString(string, UaNodeId.fromLocal(nodeId, this.ctx.getNamespaceTable()).toString());
            }
        }
    }

    @Override
    public void putNodeIdArray(String string, Collection<NodeId> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.assertArrayLength(collection.size());
            this.beginArray();
            for (NodeId nodeId : collection) {
                if (nodeId == null) {
                    this.putNull();
                    continue;
                }
                this.putNodeId(null, nodeId);
            }
            this.endArray();
        }
    }

    @Override
    public void putNodeIdArray(String string, NodeId[] nodeIdArray) throws EncodingException {
        if (nodeIdArray != null) {
            this.K(string);
            this.assertArrayLength(nodeIdArray.length);
            this.beginArray();
            for (NodeId nodeId : nodeIdArray) {
                this.eBL();
                if (nodeId == null) {
                    this.putNull();
                    continue;
                }
                this.putNodeId(null, nodeId);
            }
            this.endArray();
        }
    }

    @Deprecated
    public void putObject(String string, Object object) throws EncodingException {
        if (object != null) {
            this.K(string);
            this.o(object);
        }
    }

    @Override
    public void putQualifiedName(String string, QualifiedName qualifiedName) throws EncodingException {
        if (qualifiedName != null) {
            if (this.uk) {
                this.K(string);
                this.beginObject();
                this.putObject("Name", qualifiedName.getName());
                this.a("Uri", qualifiedName.getNamespaceIndex());
                this.endObject();
            } else if (qualifiedName.getNamespaceIndex() == 0) {
                this.putString(string, qualifiedName.toString());
            } else {
                this.putString(string, UaQualifiedName.from(qualifiedName, this.ctx.getNamespaceTable()).toString());
            }
        }
    }

    @Override
    public void putQualifiedNameArray(String string, Collection<QualifiedName> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.assertArrayLength(collection.size());
            this.beginArray();
            for (QualifiedName qualifiedName : collection) {
                this.eBL();
                if (qualifiedName == null) {
                    this.putNull();
                    continue;
                }
                this.putQualifiedName(null, qualifiedName);
            }
            this.endArray();
        }
    }

    @Override
    public void putQualifiedNameArray(String string, QualifiedName[] qualifiedNameArray) throws EncodingException {
        if (qualifiedNameArray != null) {
            this.K(string);
            this.assertArrayLength(qualifiedNameArray.length);
            this.beginArray();
            for (QualifiedName qualifiedName : qualifiedNameArray) {
                this.eBL();
                if (qualifiedName == null) {
                    this.putNull();
                    continue;
                }
                this.putQualifiedName(null, qualifiedName);
            }
            this.endArray();
        }
    }

    @Override
    public void putSByte(String string, byte by) throws EncodingException {
        this.putObject(string, by);
    }

    @Override
    public void putSByte(String string, Byte by) throws EncodingException {
        this.putObject(string, by);
    }

    @Override
    public void putSByte(String string, int n2) throws EncodingException {
        this.putObject(string, n2);
    }

    @Override
    public void putSByteArray(String string, Byte[] byteArray) throws EncodingException {
        this.a(string, byteArray);
    }

    @Override
    public void putSByteArray(String string, Collection<Byte> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putStatusCode(String string, StatusCode statusCode) throws EncodingException {
        if (statusCode == null) {
            return;
        }
        if (StatusCode.GOOD.equals(statusCode)) {
            this.K(null);
            if (this.eBH() > 0) {
                this.putNull();
            }
            return;
        }
        this.K(string);
        if (!this.uj) {
            this.beginObject();
            this.putObject("Code", statusCode.getValue());
            this.putObject("Symbol", statusCode.getName());
            this.endObject();
        } else {
            this.o(statusCode.getValue());
        }
    }

    @Override
    public void putStatusCodeArray(String string, Collection<StatusCode> collection) throws EncodingException {
        if (collection != null) {
            this.K(string);
            this.assertArrayLength(collection.size());
            this.beginArray();
            for (StatusCode statusCode : collection) {
                this.eBL();
                if (statusCode == null || statusCode == StatusCode.GOOD) {
                    this.putNull();
                    continue;
                }
                this.putStatusCode(null, statusCode);
            }
            this.endArray();
        }
    }

    @Override
    public void putStatusCodeArray(String string, StatusCode[] statusCodeArray) throws EncodingException {
        if (statusCodeArray != null) {
            this.K(string);
            this.assertArrayLength(statusCodeArray.length);
            this.beginArray();
            for (StatusCode statusCode : statusCodeArray) {
                this.eBL();
                if (statusCode == null || statusCode.isGood()) {
                    this.putNull();
                    continue;
                }
                this.putStatusCode(null, statusCode);
            }
            this.endArray();
        }
    }

    @Override
    public void putString(String string, String string2) throws EncodingException {
        this.putObject(string, string2);
    }

    @Override
    public void putStringArray(String string, Collection<String> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putStringArray(String string, String[] stringArray) throws EncodingException {
        this.a(string, stringArray);
    }

    @Deprecated
    public void putStructure(String string, Structure structure) throws EncodingException {
        if (structure != null) {
            this.a(string, (Object)structure, structure.getClass());
        }
    }

    @Override
    public void putUInt16(String string, UnsignedShort unsignedShort) throws EncodingException {
        this.putObject(string, unsignedShort);
    }

    @Override
    public void putUInt16Array(String string, Collection<UnsignedShort> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putUInt16Array(String string, UnsignedShort[] unsignedShortArray) throws EncodingException {
        this.a(string, unsignedShortArray);
    }

    @Override
    public void putUInt32(String string, UnsignedInteger unsignedInteger) throws EncodingException {
        this.putObject(string, unsignedInteger);
    }

    @Override
    public void putUInt32Array(String string, Collection<UnsignedInteger> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putUInt32Array(String string, UnsignedInteger[] unsignedIntegerArray) throws EncodingException {
        this.a(string, unsignedIntegerArray);
    }

    @Override
    public void putUInt64(String string, UnsignedLong unsignedLong) throws EncodingException {
        this.putObject(string, unsignedLong);
    }

    @Override
    public void putUInt64Array(String string, Collection<UnsignedLong> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putUInt64Array(String string, UnsignedLong[] unsignedLongArray) throws EncodingException {
        this.a(string, unsignedLongArray);
    }

    @Override
    @Deprecated
    public void putVariant(String string, Variant variant) throws EncodingException {
        if (variant != null && !variant.isEmpty()) {
            Integer n2 = BuiltinsMap.ID_MAP.get(variant.getCompositeClass());
            if (n2 == null && Structure.class.isAssignableFrom(variant.getCompositeClass())) {
                n2 = 22;
            }
            if (n2 == null || n2 == 0) {
                return;
            }
            this.K(string);
            if (this.uj) {
                this.beginObject();
                this.putObject("Type", n2);
                this.a("Body", variant);
                int[] nArray = variant.getArrayDimensions();
                if (nArray.length > 1) {
                    this.putInt32Array("Dimensions", nArray);
                }
                this.endObject();
            } else {
                this.a(null, variant);
            }
        }
    }

    @Deprecated
    public void putVariantArray(String string, Collection<Variant> collection) throws EncodingException {
        this.assertArrayLength(collection.size());
        this.K(string);
        this.beginArray();
        for (Variant variant : collection) {
            this.eBL();
            if (variant != null && BuiltinsMap.ID_MAP.get(variant.getCompositeClass()) != 0) {
                this.putVariant(null, variant);
                continue;
            }
            this.putNull();
        }
        this.endArray();
    }

    @Override
    public void putVariantArray(String string, Variant[] variantArray) throws EncodingException {
        this.assertArrayLength(variantArray.length);
        this.K(string);
        this.beginArray();
        for (Variant variant : variantArray) {
            this.eBL();
            if (variant != null && BuiltinsMap.ID_MAP.get(variant.getCompositeClass()) != 0) {
                this.putVariant(null, variant);
                continue;
            }
            this.putNull();
        }
        this.endArray();
    }

    @Override
    public void putXmlElement(String string, XmlElement xmlElement) throws EncodingException {
        this.putObject(string, xmlElement);
    }

    @Override
    public void putXmlElementArray(String string, Collection<XmlElement> collection) throws EncodingException {
        this.a(string, collection);
    }

    @Override
    public void putXmlElementArray(String string, XmlElement[] xmlElementArray) throws EncodingException {
        this.a(string, xmlElementArray);
    }

    public void setNodeIdJsonObjects(boolean bl) {
        this.uk = bl;
    }

    public void setReversibleEncoding(boolean bl) {
        this.uj = bl;
    }

    public String toString() {
        return this.writer.toString();
    }

    private void assertArrayLength(int n2) throws EncodingException {
        int n3 = this.ctx.getMaxArrayLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength " + n3 + " < " + n2);
            logger.warn("assertArrayLength: failed", encodingException);
            throw encodingException;
        }
    }

    private void assertByteStringLength(int n2) throws EncodingException {
        int n3 = this.ctx.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
            throw encodingException;
        }
    }

    private Integer eBH() {
        if (this.un < 0) {
            return -1;
        }
        return this.ul.get(this.un);
    }

    private Integer eBI() {
        return this.ui.get(this.um);
    }

    private void a(String string, Object object2, Class<?> clazz, UaNodeId uaNodeId, int n2) throws EncodingException {
        Class<?> clazz2;
        Object[] objectArray;
        UaNodeId uaNodeId2;
        a<Object> a2 = null;
        if (UaIds.Structure.equals(uaNodeId)) {
            object2 = MultiDimensionArrayUtils.map(object2, Object.class, ExtensionObject.class, object -> {
                if (object instanceof ExtensionObject) {
                    return (ExtensionObject)object;
                }
                return new ExtensionObject((Structure)object);
            });
        }
        if ((uaNodeId2 = uaNodeId) != null || clazz != null) {
            // empty if block
        }
        if (uaNodeId2 != null) {
            objectArray = new AtomicReference();
            a2 = JsonEncoder.b(uaNodeId2, this.getEncoderContext(), objectArray);
            clazz2 = objectArray.get();
        } else {
            clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            a2 = JsonEncoder.i(clazz2);
        }
        if (n2 == 0) {
            a2.put(this, string, object2, clazz2);
            return;
        }
        if (n2 == 1) {
            if (object2 == null) {
                return;
            }
            objectArray = (Object[])object2;
            this.assertArrayLength(objectArray.length);
            if (string != null) {
                this.K(string);
                this.beginArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.a(objectArray[i2], a2, clazz2);
                }
                this.endArray();
            }
            return;
        }
        if (object2 == null) {
            objectArray = new int[n2];
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                objectArray[i3] = -1;
            }
            this.putInt32Array((String)null, (int[])objectArray);
            return;
        }
        objectArray = MultiDimensionArrayUtils.getArrayLengths(object2);
        Object[] objectArray2 = (Object[])MultiDimensionArrayUtils.muxArray(object2, (int[])objectArray, clazz2);
        int n3 = objectArray2.length;
        this.assertArrayLength(n3);
        this.putInt32Array((String)null, (int[])objectArray);
        for (Object object3 : objectArray2) {
            a2.put(this, null, object3, clazz2);
        }
    }

    private void a(String string, Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        if (structure == null) {
            return;
        }
        this.K(string);
        this.beginObject();
        this.d(structure, structureSpecification);
        this.endObject();
    }

    private void eBJ() {
        this.ul.set(this.un, this.eBH() + 1);
    }

    private void eBK() {
        this.ui.set(this.um, this.eBI() + 1);
    }

    private String J(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block9: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void a(String string, Collection<?> collection) throws EncodingException {
        if (collection != null) {
            this.assertArrayLength(collection.size());
            this.K(string);
            this.beginArray();
            for (Object obj : collection) {
                this.putArrayElement(obj);
            }
            this.endArray();
        }
    }

    private void a(String string, Object[] objectArray) throws EncodingException {
        if (objectArray != null) {
            this.assertArrayLength(objectArray.length);
            this.K(string);
            this.beginArray();
            for (Object object : objectArray) {
                if (object != null && MultiDimensionArrayUtils.getDimension(object) > 0) {
                    this.eBL();
                    this.a(null, (Object[])object);
                    continue;
                }
                this.putArrayElement(object);
            }
            this.endArray();
        }
    }

    private void eBL() throws EncodingException {
        if (this.eBH() > 0) {
            this.putComma();
        }
        this.eBJ();
    }

    private void a(Object object, a<Object> a2, Class<?> clazz) throws EncodingException {
        this.eBL();
        if (object == null) {
            this.putNull();
        } else {
            a2.put(this, null, object, clazz);
        }
    }

    private void a(String string, BigDecimal bigDecimal) throws EncodingException {
        if (bigDecimal != null) {
            this.K(string);
            this.beginObject();
            this.putObject("Scale", bigDecimal.scale());
            this.putObject("Value", bigDecimal.unscaledValue());
            this.endObject();
        }
    }

    private void K(String string) throws EncodingException {
        if (this.um == -1 && this.un == -1) {
            this.beginObject();
        }
        if (string != null) {
            if (this.eBI() > 0) {
                this.putComma();
            }
            try {
                this.writer.write(this.L(string) + ":");
            }
            catch (IOException iOException) {
                JsonEncoder.a(iOException, "fieldName", string);
            }
            this.eBK();
        }
    }

    private void r(int n2) throws EncodingException {
        if (n2 != 0) {
            this.putObject("IdType", n2);
        }
    }

    private void a(String string, int n2) throws EncodingException {
        if (n2 != 0) {
            if (n2 == 1 || this.uj) {
                this.putObject(string, n2);
            } else {
                String string2 = this.ctx.getNamespaceTable().getUri(n2);
                if (string2 == null) {
                    throw new EncodingException(new String("Unable to find matching Namespace Uri for Namespace Index: " + n2));
                }
                this.putObject(string, string2);
            }
        }
    }

    private void putNull() throws EncodingException {
        try {
            this.writer.write("null");
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "null", null);
        }
    }

    private void a(String string, UaOptionSet uaOptionSet, Class<? extends UaOptionSet> clazz) throws EncodingException {
        if (uaOptionSet != null) {
            this.put(string, uaOptionSet.getValue(), uaOptionSet.specification().getBaseTypeId(), 0);
        }
    }

    private void l(UnsignedInteger unsignedInteger) throws EncodingException {
        if (unsignedInteger.intValue() != 0) {
            if (this.uj) {
                this.putObject("ServerUri", unsignedInteger);
            } else {
                String string = this.ctx.getServerTable().getUri(unsignedInteger.intValue());
                if (string == null) {
                    throw new EncodingException(new String("Unable to find matching Server Uri for Server Index: " + unsignedInteger));
                }
                this.putObject("ServerUri", string);
            }
        }
    }

    private void d(Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        if (structure == null) {
            return;
        }
        Map<FieldSpecification, Object> map = structure.toFieldsMap(structureSpecification);
        if (StructureSpecification.StructureType.UNION == structureSpecification.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == structureSpecification.getStructureType()) {
            long l2 = 0L;
            FieldSpecification fieldSpecification = null;
            Object object = null;
            for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
                ++l2;
                if (entry.getValue() == null) continue;
                fieldSpecification = entry.getKey();
                object = entry.getValue();
                break;
            }
            if (fieldSpecification == null) {
                return;
            }
            this.putUInt32("SwitchField", UnsignedInteger.valueOf(l2));
            int n2 = fieldSpecification.getValueRank() < 0 ? 0 : fieldSpecification.getValueRank();
            this.put(fieldSpecification.getName(), object, fieldSpecification.getDataTypeId(), n2);
            return;
        }
        if (this.uj && StructureSpecification.StructureType.OPTIONAL == structureSpecification.getStructureType()) {
            int n3 = -1;
            long l3 = 0L;
            for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
                if (!entry.getKey().isOptional()) continue;
                ++n3;
                if (entry.getValue() == null) continue;
                l3 |= (long)(1 << n3);
            }
            this.putUInt64("EncodingMask", UnsignedLong.getFromBits(l3));
        }
        for (Map.Entry<FieldSpecification, Object> entry : map.entrySet()) {
            FieldSpecification fieldSpecification = entry.getKey();
            Object object = entry.getValue();
            if (fieldSpecification.isOptional() && object == null) continue;
            this.put(fieldSpecification.getName(), object, fieldSpecification.getEncodeTypeId(), fieldSpecification.getJavaClassDimensions());
        }
    }

    @Deprecated
    private void a(String string, Structure[] structureArray) throws EncodingException {
        if (structureArray != null) {
            this.K(string);
            this.assertArrayLength(structureArray.length);
            this.beginArray();
            for (Structure structure : structureArray) {
                this.eBL();
                if (structure == null) {
                    this.putNull();
                    continue;
                }
                this.putStructure(null, structure);
            }
            this.endArray();
        }
    }

    private void o(Object object) throws EncodingException {
        try {
            this.writer.write(this.p(object));
        }
        catch (IOException iOException) {
            JsonEncoder.a(iOException, "value", null);
        }
    }

    private void a(String string, Variant variant) throws EncodingException {
        if (variant != null) {
            Object object;
            Object object2;
            if (variant instanceof InternalHasDataTypeId && (object2 = ((InternalHasDataTypeId)((Object)variant)).getDataTypeId()) != null && (object = this.getEncoderContext().getEnumerationSpecification((UaNodeId)object2)) != null) {
                Object object3 = variant.asEnum((EnumerationSpecification)object);
                this.put(string, object3, ((EnumerationSpecification)object).getTypeId(), MultiDimensionArrayUtils.getDimension(object3));
                return;
            }
            if (variant.getDimension() > 0) {
                this.b(string, variant);
                return;
            }
            object2 = variant.getValue();
            object = BuiltinsMap.ID_MAP.get(variant.getCompositeClass());
            if (object == null && Structure.class.isAssignableFrom(variant.getCompositeClass())) {
                object = 22;
            }
            switch ((Integer)object) {
                case 1: {
                    this.putBoolean(string, (Boolean)object2);
                    break;
                }
                case 2: {
                    this.putSByte(string, (Byte)object2);
                    break;
                }
                case 3: {
                    this.putByte(string, (UnsignedByte)object2);
                    break;
                }
                case 4: {
                    this.putInt16(string, (Short)object2);
                    break;
                }
                case 5: {
                    this.putUInt16(string, (UnsignedShort)object2);
                    break;
                }
                case 6: {
                    this.putInt32(string, (Integer)object2);
                    break;
                }
                case 7: {
                    this.putUInt32(string, (UnsignedInteger)object2);
                    break;
                }
                case 8: {
                    this.putInt64(string, (Long)object2);
                    break;
                }
                case 9: {
                    this.putUInt64(string, (UnsignedLong)object2);
                    break;
                }
                case 10: {
                    this.putFloat(string, (Float)object2);
                    break;
                }
                case 11: {
                    this.putDouble(string, (Double)object2);
                    break;
                }
                case 12: {
                    this.putString(string, (String)object2);
                    break;
                }
                case 13: {
                    this.putDateTime(string, (DateTime)object2);
                    break;
                }
                case 14: {
                    this.putGuid(string, (UUID)object2);
                    break;
                }
                case 15: {
                    this.putByteString(string, (ByteString)object2);
                    break;
                }
                case 16: {
                    this.putXmlElement(string, (XmlElement)object2);
                    break;
                }
                case 17: {
                    this.putNodeId(string, (NodeId)object2);
                    break;
                }
                case 18: {
                    this.putExpandedNodeId(string, (ExpandedNodeId)object2);
                    break;
                }
                case 19: {
                    this.putStatusCode(string, (StatusCode)object2);
                    break;
                }
                case 20: {
                    this.putQualifiedName(string, (QualifiedName)object2);
                    break;
                }
                case 21: {
                    this.putLocalizedText(string, (LocalizedText)object2);
                    break;
                }
                case 22: {
                    if (object2 instanceof Structure) {
                        this.putExtensionObject(string, new ExtensionObject((Structure)object2));
                        break;
                    }
                    this.putExtensionObject(string, (ExtensionObject)object2);
                    break;
                }
                case 23: {
                    this.putDataValue(string, (DataValue)object2);
                    break;
                }
                case 24: {
                    this.putVariant(string, (Variant)object2);
                    break;
                }
                case 25: {
                    this.putDiagnosticInfo(string, (DiagnosticInfo)object2);
                    break;
                }
                default: {
                    throw new EncodingException("cannot encode builtin type " + object);
                }
            }
        }
    }

    private void b(String string, Variant variant) throws EncodingException {
        int[] nArray = variant.getArrayDimensions();
        Object object = variant.getValue();
        if (this.uj && nArray.length > 1) {
            Object[] objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object, nArray, variant.getCompositeClass());
            this.a(string, objectArray);
            return;
        }
        this.a(string, (Object[])object);
    }

    private String c(byte[] byArray) throws EncodingException {
        if (byArray == null) {
            return "null";
        }
        this.assertByteStringLength(byArray.length);
        return "\"" + CryptoUtil.base64Encode(byArray) + "\"";
    }

    private String f(DateTime dateTime) {
        String string;
        try {
            string = dateTime.compareTo(DateTime.MAX_VALUE) >= 0 ? tY : (dateTime.compareTo(DateTime.MIN_VALUE) <= 0 ? tX : tW.format(dateTime.toInstant()));
        }
        catch (Exception exception) {
            string = tX;
        }
        return this.L(string);
    }

    private String d(Double d2) {
        if (!d2.equals(Double.NaN)) {
            return d2.toString();
        }
        return "\"NaN\"";
    }

    private String b(Enumeration enumeration) {
        if (enumeration == null) {
            throw new IllegalStateException("Given Enumeration value shouldn't be null at this point");
        }
        String string = null;
        if (!this.uj) {
            if (enumeration.specification() != null) {
                string = enumeration.specification().getIntToStringMappings().get(enumeration.getValue());
            } else {
                logger.warn("Encountered Enumeration for which .specification returned null, using number form for encoding as a fallback");
            }
        }
        if (string == null) {
            return Integer.toString(enumeration.getValue());
        }
        return this.L(string + "_" + enumeration.getValue());
    }

    private String b(Float f2) {
        if (!f2.equals(Float.valueOf(Float.NaN))) {
            return f2.toString();
        }
        return "\"NaN\"";
    }

    private String L(String string) {
        if (string == null) {
            return "null";
        }
        if (string.startsWith("{")) {
            return string;
        }
        return "\"" + this.J(string) + "\"";
    }

    private String b(UUID uUID) {
        return this.L(uUID.toString());
    }

    private String b(XmlElement xmlElement) {
        return this.L(xmlElement.getValue());
    }

    private String p(Object object) throws EncodingException {
        if (object instanceof byte[]) {
            return this.c((byte[])object);
        }
        if (object instanceof ByteString) {
            return this.c(((ByteString)object).getValue());
        }
        if (object instanceof String || object == null) {
            return this.L((String)object);
        }
        if (object instanceof Enumeration) {
            return this.b((Enumeration)object);
        }
        if (object instanceof Float) {
            return this.b((Float)object);
        }
        if (object instanceof Double) {
            return this.d((Double)object);
        }
        if (object instanceof DateTime) {
            return this.f((DateTime)object);
        }
        if (object instanceof UUID) {
            return this.b((UUID)object);
        }
        if (object instanceof XmlElement) {
            return this.b((XmlElement)object);
        }
        if (object instanceof Long || object instanceof UnsignedLong) {
            return "\"" + object + "\"";
        }
        return object.toString();
    }

    @Deprecated
    void put(String string, Object object) throws EncodingException {
        this.a(string, object, object.getClass());
    }

    @Deprecated
    void a(String string, Object object, Class<?> clazz) throws EncodingException {
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        this.a(string, object, clazz, null, n2);
    }

    static {
        JsonEncoder.b(UaIds.Boolean, Boolean.class, (JsonEncoder jsonEncoder, String string, T bl, Class<T> clazz) -> jsonEncoder.putBoolean(string, (Boolean)bl));
        JsonEncoder.b(UaIds.SByte, Byte.class, (JsonEncoder jsonEncoder, String string, T by, Class<T> clazz) -> jsonEncoder.putSByte(string, (Byte)by));
        JsonEncoder.b(UaIds.Byte, UnsignedByte.class, (JsonEncoder jsonEncoder, String string, T unsignedByte, Class<T> clazz) -> jsonEncoder.putByte(string, (UnsignedByte)unsignedByte));
        JsonEncoder.b(UaIds.Int16, Short.class, (JsonEncoder jsonEncoder, String string, T s2, Class<T> clazz) -> jsonEncoder.putInt16(string, (Short)s2));
        JsonEncoder.b(UaIds.UInt16, UnsignedShort.class, (JsonEncoder jsonEncoder, String string, T unsignedShort, Class<T> clazz) -> jsonEncoder.putUInt16(string, (UnsignedShort)unsignedShort));
        JsonEncoder.b(UaIds.Int32, Integer.class, (JsonEncoder jsonEncoder, String string, T n2, Class<T> clazz) -> jsonEncoder.putInt32(string, (Integer)n2));
        JsonEncoder.b(UaIds.UInt32, UnsignedInteger.class, (JsonEncoder jsonEncoder, String string, T unsignedInteger, Class<T> clazz) -> jsonEncoder.putUInt32(string, (UnsignedInteger)unsignedInteger));
        JsonEncoder.b(UaIds.Int64, Long.class, (JsonEncoder jsonEncoder, String string, T l2, Class<T> clazz) -> jsonEncoder.putInt64(string, (Long)l2));
        JsonEncoder.b(UaIds.UInt64, UnsignedLong.class, (JsonEncoder jsonEncoder, String string, T unsignedLong, Class<T> clazz) -> jsonEncoder.putUInt64(string, (UnsignedLong)unsignedLong));
        JsonEncoder.b(UaIds.Float, Float.class, (JsonEncoder jsonEncoder, String string, T f2, Class<T> clazz) -> jsonEncoder.putFloat(string, (Float)f2));
        JsonEncoder.b(UaIds.Double, Double.class, (JsonEncoder jsonEncoder, String string, T d2, Class<T> clazz) -> jsonEncoder.putDouble(string, (Double)d2));
        JsonEncoder.b(UaIds.String, String.class, (JsonEncoder jsonEncoder, String string, T string2, Class<T> clazz) -> jsonEncoder.putString(string, (String)string2));
        JsonEncoder.b(UaIds.Guid, UUID.class, (JsonEncoder jsonEncoder, String string, T uUID, Class<T> clazz) -> jsonEncoder.putGuid(string, (UUID)uUID));
        JsonEncoder.b(UaIds.ByteString, ByteString.class, (JsonEncoder jsonEncoder, String string, T byteString, Class<T> clazz) -> jsonEncoder.putByteString(string, (ByteString)byteString));
        JsonEncoder.b(UaIds.XmlElement, XmlElement.class, (JsonEncoder jsonEncoder, String string, T xmlElement, Class<T> clazz) -> jsonEncoder.putXmlElement(string, (XmlElement)xmlElement));
        JsonEncoder.b(UaIds.NodeId, NodeId.class, (JsonEncoder jsonEncoder, String string, T nodeId, Class<T> clazz) -> jsonEncoder.putNodeId(string, (NodeId)nodeId));
        JsonEncoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (JsonEncoder jsonEncoder, String string, T expandedNodeId, Class<T> clazz) -> jsonEncoder.putExpandedNodeId(string, (ExpandedNodeId)expandedNodeId));
        JsonEncoder.b(UaIds.StatusCode, StatusCode.class, (JsonEncoder jsonEncoder, String string, T statusCode, Class<T> clazz) -> jsonEncoder.putStatusCode(string, (StatusCode)statusCode));
        JsonEncoder.b(UaIds.QualifiedName, QualifiedName.class, (JsonEncoder jsonEncoder, String string, T qualifiedName, Class<T> clazz) -> jsonEncoder.putQualifiedName(string, (QualifiedName)qualifiedName));
        JsonEncoder.b(UaIds.LocalizedText, LocalizedText.class, (JsonEncoder jsonEncoder, String string, T localizedText, Class<T> clazz) -> jsonEncoder.putLocalizedText(string, (LocalizedText)localizedText));
        tZ = (jsonEncoder, string, dateTime, clazz) -> jsonEncoder.putDateTime(string, (DateTime)dateTime);
        JsonEncoder.a(UaIds.DateTime, DateTime.class, tZ);
        ua = (jsonEncoder, string, extensionObject, clazz) -> jsonEncoder.putExtensionObject(string, (ExtensionObject)extensionObject);
        JsonEncoder.a(UaIds.Structure, ExtensionObject.class, ua);
        ub = (jsonEncoder, string, structure, clazz) -> {
            StructureSpecification structureSpecification = null;
            if (structure != null) {
                structureSpecification = structure.specification();
            }
            jsonEncoder.a(string, (Structure)structure, structureSpecification);
        };
        uc = (jsonEncoder, string, dataValue, clazz) -> jsonEncoder.putDataValue(string, (DataValue)dataValue);
        JsonEncoder.a(UaIds.DataValue, DataValue.class, uc);
        ud = (jsonEncoder, string, variant, clazz) -> jsonEncoder.putVariant(string, (Variant)variant);
        ue = (jsonEncoder, string, diagnosticInfo, clazz) -> jsonEncoder.putDiagnosticInfo(string, (DiagnosticInfo)diagnosticInfo);
        JsonEncoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, ue);
        uf = (jsonEncoder, string, enumeration, clazz) -> jsonEncoder.putObject(string, enumeration);
        ug = (jsonEncoder, string, bigDecimal, clazz) -> jsonEncoder.a(string, (BigDecimal)bigDecimal);
        JsonEncoder.a(UaIds.Decimal, BigDecimal.class, ug);
        uh = (jsonEncoder, string, uaOptionSet, clazz) -> jsonEncoder.a(string, (UaOptionSet)uaOptionSet, clazz);
        JsonEncoder.b(null, Object.class, (JsonEncoder jsonEncoder, String string, T object, Class<T> clazz) -> {
            if (object == null) {
                ud.put(jsonEncoder, string, null, Variant.class);
            } else if (object instanceof Variant) {
                ud.put(jsonEncoder, string, (Variant)object, Variant.class);
            } else {
                ud.put(jsonEncoder, string, new Variant(object), Variant.class);
            }
        });
    }

    private static interface a<T> {
        public void put(JsonEncoder var1, String var2, T var3, Class<? extends T> var4) throws EncodingException;
    }
}

