/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.stack.core.IdType;

public enum NodeIdEncoding {
    TwoByte(0, IdType.Numeric),
    FourByte(1, IdType.Numeric),
    Numeric(2, IdType.Numeric),
    String(3, IdType.String),
    Guid(4, IdType.Guid),
    ByteString(5, IdType.String);

    private final byte tA;
    private final IdType tB;

    public static NodeIdEncoding getNodeIdEncoding(int n2) {
        if (n2 == TwoByte.getBits()) {
            return TwoByte;
        }
        if (n2 == FourByte.getBits()) {
            return FourByte;
        }
        if (n2 == Numeric.getBits()) {
            return Numeric;
        }
        if (n2 == String.getBits()) {
            return String;
        }
        if (n2 == Guid.getBits()) {
            return Guid;
        }
        if (n2 == ByteString.getBits()) {
            return ByteString;
        }
        return null;
    }

    private NodeIdEncoding(byte by, IdType idType) {
        this.tA = by;
        this.tB = idType;
    }

    public byte getBits() {
        return this.tA;
    }

    public IdType toIdentifierType() {
        return this.tB;
    }

    public static class AsByte {
        public static final byte TwoByte = 0;
        public static final byte FourByte = 1;
        public static final byte Numeric = 2;
        public static final byte String = 3;
        public static final byte Guid = 4;
        public static final byte ByteString = 5;
    }
}

