/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.Union;
import com.prosysopc.ua.stack.encoding.AbstactEncoder;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncoderMode;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.encoding.binary.ByteUtils;
import com.prosysopc.ua.stack.encoding.binary.LittleEndianByteUtils;
import com.prosysopc.ua.stack.utils.EncodingLimitsExceededIoException;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.LittleEndianOutputStreamWriteable;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryEncoder
extends AbstactEncoder
implements IEncoder {
    private static final Logger logger = LoggerFactory.getLogger(BinaryEncoder.class);
    private static final Map<Class<?>, a<?>> sS = new HashMap();
    private static final a<?>[] tj = new a[51];
    private static final a<DateTime> tk;
    private static final a<ExtensionObject> tl;
    private static final a<Structure> tm;
    private static final a<DataValue> tn;
    private static final a<Variant> to;
    private static final a<DiagnosticInfo> tp;
    private static final a<Enumeration> tq;
    private static final a<BigDecimal> tr;
    private static final a<UaOptionSet> ts;
    private static final a<Object> tt;
    private static final ExpandedNodeId tf;
    private static final byte[] tu;
    private final List<Locale> lF = new CopyOnWriteArrayList<Locale>();
    IBinaryWriteable tv;
    EncoderMode tw = EncoderMode.NonStrict;
    private final byte[] tx = new byte[2];
    private final byte[] ty = new byte[4];
    private final byte[] tz = new byte[7];

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId == null) {
            return;
        }
        Object object = uaNodeId.getValue();
        if (!(object instanceof UnsignedInteger)) {
            throw new Error("Internal error, builtintype UaNodeId was not numeric");
        }
        int n2 = ((UnsignedInteger)object).intValue();
        if (n2 != 50 && n2 > 25) {
            throw new Error("Internal error, DataType " + uaNodeId + " higher index than expected, was: " + n2);
        }
        if (tj[n2] != null) {
            throw new Error("Internal error, DataType " + uaNodeId + " already has a serializer defined");
        }
        BinaryEncoder.tj[n2] = a2;
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        if (sS.put(clazz, a2) != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        BinaryEncoder.a(uaNodeId, clazz, a2);
    }

    private static a a(UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification) throws EncodingException {
        a<Object> a2 = BinaryEncoder.l(uaNodeId);
        if (a2 == null) {
            if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = BinaryEncoder.l(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = tm;
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = ts;
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = tq;
            }
        }
        if (a2 == null) {
            throw new EncodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        return a2;
    }

    private static UnsignedInteger b(UnsignedInteger unsignedInteger, int n2) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("mask cannot be null");
        }
        if (n2 < 0 || n2 > 31) {
            throw new IllegalArgumentException("position must be between 0-31");
        }
        int n3 = 1 << n2;
        return unsignedInteger.or(n3);
    }

    private static EncodingException b(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new EncodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new EncodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new EncodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new EncodingException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
        }
        if (iOException instanceof EncodingLimitsExceededIoException) {
            return new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, (Throwable)iOException, iOException.getMessage());
        }
        return new EncodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    private static a<?> l(UaNodeId uaNodeId) {
        int n2;
        if (!UaNamespace.STANDARD.equals(uaNodeId.getNamespace())) {
            return null;
        }
        Object object = uaNodeId.getValue();
        if (object instanceof UnsignedInteger && (n2 = ((UnsignedInteger)object).toIntBits()) > 0 && n2 < 51) {
            return tj[n2];
        }
        return null;
    }

    static ExtensionObject[] a(BigDecimal[] bigDecimalArray) throws EncodingException {
        if (bigDecimalArray == null) {
            return null;
        }
        ExtensionObject[] extensionObjectArray = new ExtensionObject[bigDecimalArray.length];
        for (int i2 = 0; i2 < bigDecimalArray.length; ++i2) {
            extensionObjectArray[i2] = BinaryEncoder.a(bigDecimalArray[i2]);
        }
        return extensionObjectArray;
    }

    static ExtensionObject a(BigDecimal bigDecimal) throws EncodingException {
        int n2 = bigDecimal.scale();
        if (n2 > Short.MAX_VALUE) {
            throw new EncodingException("Decimal scale overflow Short max value: " + n2);
        }
        if (n2 < Short.MIN_VALUE) {
            throw new EncodingException("Decimal scale underflow Short min value: " + n2);
        }
        short s2 = (short)n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort(s2);
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = ByteUtils.reverse(bigDecimal.unscaledValue().toByteArray());
        byte[] byArray3 = ByteUtils.concat(byArray, byArray2);
        return new ExtensionObject(tf, ByteString.valueOf(byArray3));
    }

    public BinaryEncoder(EncoderContext encoderContext, byte[] byArray) {
        super(encoderContext);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public BinaryEncoder(EncoderContext encoderContext, byte[] byArray, int n2, int n3) {
        super(encoderContext);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public BinaryEncoder(EncoderContext encoderContext, ByteBuffer byteBuffer) {
        super(encoderContext);
        ByteBufferWriteable byteBufferWriteable = new ByteBufferWriteable(byteBuffer);
        this.setWriteable(byteBufferWriteable);
    }

    public BinaryEncoder(EncoderContext encoderContext, IBinaryWriteable iBinaryWriteable) {
        super(encoderContext);
        this.setWriteable(iBinaryWriteable);
    }

    public BinaryEncoder(EncoderContext encoderContext, OutputStream outputStream) {
        super(encoderContext);
        this.setWriteable(new LittleEndianOutputStreamWriteable(outputStream));
    }

    public EncoderMode getEncoderType() {
        return this.tw;
    }

    @Override
    public List<Locale> getLocales() {
        return this.lF;
    }

    public IBinaryWriteable getOutput() {
        return this.tv;
    }

    public IBinaryWriteable getWriteable() {
        return this.tv;
    }

    @Override
    public void put(String string, Object object, UaNodeId uaNodeId, int n2) throws EncodingException {
        InternalArguments.checkNotNull(uaNodeId, "DataTypeId");
        if (n2 < 0) {
            throw new EncodingException("The given dimensions cannot be negative");
        }
        EncoderContext encoderContext = this.getEncoderContext();
        if (encoderContext == null) {
            throw new IllegalStateException("The EncoderContext is not set");
        }
        UaDataTypeSpecification uaDataTypeSpecification = null;
        uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification == null) {
            throw new EncodingException("Cannot find UaDataTypeSpecification, cannot encode DataType: " + uaNodeId);
        }
        try {
            this.a(object, uaNodeId, n2, uaDataTypeSpecification);
        }
        catch (Exception exception) {
            throw new EncodingException("Error while trying to encode DataTypeId: " + uaNodeId, exception);
        }
    }

    public void setEncoderMode(EncoderMode encoderMode) {
        this.tw = encoderMode;
    }

    public void setWriteable(IBinaryWriteable iBinaryWriteable) {
        if (iBinaryWriteable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Writeable must be in Little-Ending byte order");
        }
        this.tv = iBinaryWriteable;
    }

    private void assertArrayLength(int n2) throws EncodingException {
        int n3 = this.ctx.getMaxArrayLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength " + n3 + " < " + n2);
            logger.warn("assertArrayLength: failed", encodingException);
            throw encodingException;
        }
    }

    private void assertByteStringLength(int n2) throws EncodingException {
        int n3 = this.ctx.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
            logger.warn("assertByteStringLength: failed", encodingException);
            throw encodingException;
        }
    }

    private void l(Object object) throws EncodingException {
        if (object != null) {
            return;
        }
        if (this.tw == EncoderMode.Strict) {
            throw new EncodingException("Cannot encode null value");
        }
    }

    private void assertStringLength(int n2) throws EncodingException {
        int n3 = this.ctx.getMaxStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n3 + " < " + n2);
            logger.warn("assertStringLength: failed", encodingException);
            throw encodingException;
        }
    }

    private void a(Object object2, UaNodeId uaNodeId, int n2, UaDataTypeSpecification uaDataTypeSpecification) throws EncodingException {
        a a2 = null;
        if (UaIds.Structure.equals(uaNodeId)) {
            object2 = MultiDimensionArrayUtils.map(object2, Object.class, ExtensionObject.class, object -> {
                if (object instanceof ExtensionObject) {
                    return (ExtensionObject)object;
                }
                return new ExtensionObject((Structure)object);
            });
        }
        a2 = BinaryEncoder.a(uaNodeId, uaDataTypeSpecification);
        if (n2 == 0) {
            a2.put(this, null, object2, uaNodeId, uaDataTypeSpecification);
            return;
        }
        if (n2 == 1) {
            if (object2 == null) {
                this.eBr();
                return;
            }
            Object[] objectArray = (Object[])object2;
            int n3 = objectArray.length;
            this.assertArrayLength(n3);
            this.o(n3);
            for (Object object3 : objectArray) {
                a2.put(this, null, object3, uaNodeId, uaDataTypeSpecification);
            }
            return;
        }
        if (object2 == null) {
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = -1;
            }
            this.a(nArray);
            return;
        }
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(object2);
        Object[] objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object2, nArray, Object.class);
        int n4 = objectArray.length;
        this.assertArrayLength(n4);
        this.a(nArray);
        for (Object object4 : objectArray) {
            a2.put(this, null, object4, uaNodeId, uaDataTypeSpecification);
        }
    }

    private void a(Boolean bl) throws EncodingException {
        try {
            if (bl == null) {
                this.l(bl);
                this.putSByte(null, 0);
            } else {
                this.tv.put(bl != false ? (byte)1 : 0);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UnsignedByte unsignedByte) throws EncodingException {
        try {
            if (unsignedByte == null) {
                this.l(unsignedByte);
                this.p(0);
            } else {
                this.tv.put(unsignedByte.toByteBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(byte[] byArray) throws EncodingException {
        try {
            if (byArray == null) {
                this.tv.put(tu);
            } else {
                this.assertByteStringLength(byArray.length);
                this.tv.putInt(byArray.length);
                this.tv.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void e(ByteString byteString) throws EncodingException {
        try {
            if (byteString == null) {
                this.tv.put(tu);
            } else {
                int n2 = byteString.getLength();
                this.assertByteStringLength(n2);
                this.tv.putInt(n2);
                byteString.copyTo(this.tv);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void k(DataValue dataValue) throws EncodingException {
        if (dataValue == null) {
            this.p(0);
            return;
        }
        int n2 = 0;
        if (dataValue.getValue() != null) {
            n2 |= 1;
        }
        if (dataValue.getStatusCode() != null && !dataValue.getStatusCode().equals(StatusCode.GOOD)) {
            n2 |= 2;
        }
        if (dataValue.getSourceTimestamp() != null && !dataValue.getSourceTimestamp().equals(DateTime.MIN_VALUE)) {
            n2 |= 4;
        }
        if (dataValue.getServerTimestamp() != null && !dataValue.getServerTimestamp().equals(DateTime.MIN_VALUE)) {
            n2 |= 8;
        }
        if (dataValue.getSourcePicoseconds() != null && !dataValue.getSourcePicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n2 |= 0x10;
        }
        if (dataValue.getServerPicoseconds() != null && !dataValue.getServerPicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n2 |= 0x20;
        }
        this.p(n2);
        if ((n2 & 1) == 1) {
            this.e(dataValue.getValue());
        }
        if ((n2 & 2) == 2) {
            this.a(dataValue.getStatusCode());
        }
        if ((n2 & 4) == 4) {
            this.e(dataValue.getSourceTimestamp());
        }
        if ((n2 & 0x10) == 16) {
            this.a(dataValue.getSourcePicoseconds());
        }
        if ((n2 & 8) == 8) {
            this.e(dataValue.getServerTimestamp());
        }
        if ((n2 & 0x20) == 32) {
            this.a(dataValue.getServerPicoseconds());
        }
    }

    private void e(DateTime dateTime) throws EncodingException {
        try {
            if (dateTime == null) {
                this.l(dateTime);
                this.tv.putLong(0L);
            } else if (dateTime.compareTo(DateTime.MAX_VALUE) >= 0) {
                this.tv.putLong(Long.MAX_VALUE);
            } else if (dateTime.compareTo(DateTime.MIN_VALUE) <= 0) {
                this.tv.putLong(0L);
            } else {
                this.tv.putLong(dateTime.getValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(BigDecimal bigDecimal) throws EncodingException {
        ExtensionObject extensionObject = BinaryEncoder.a(bigDecimal);
        this.b(extensionObject);
    }

    private void b(DiagnosticInfo diagnosticInfo) throws EncodingException {
        if (diagnosticInfo == null) {
            this.p(0);
            return;
        }
        int n2 = 0;
        if (diagnosticInfo.getSymbolicId() != null) {
            n2 |= 1;
        }
        if (diagnosticInfo.getNamespaceUriStr() != null) {
            n2 |= 2;
        }
        if (diagnosticInfo.getLocalizedTextStr() != null) {
            n2 |= 4;
        }
        if (diagnosticInfo.getLocaleStr() != null) {
            n2 |= 8;
        }
        if (diagnosticInfo.getAdditionalInfo() != null) {
            n2 |= 0x10;
        }
        if (diagnosticInfo.getInnerStatusCode() != null) {
            n2 |= 0x20;
        }
        if (diagnosticInfo.getInnerDiagnosticInfo() != null) {
            n2 |= 0x40;
        }
        try {
            this.putSByte(null, n2);
            if ((n2 & 1) == 1) {
                this.tv.putInt(diagnosticInfo.getSymbolicId());
            }
            if ((n2 & 2) == 2) {
                this.tv.putInt(diagnosticInfo.getNamespaceUri());
            }
            if ((n2 & 8) == 8) {
                this.tv.putInt(diagnosticInfo.getLocale());
            }
            if ((n2 & 4) == 4) {
                this.tv.putInt(diagnosticInfo.getLocalizedText());
            }
            if ((n2 & 0x10) == 16) {
                this.H(diagnosticInfo.getAdditionalInfo());
            }
            if ((n2 & 0x20) == 32) {
                this.a(diagnosticInfo.getInnerStatusCode());
            }
            if ((n2 & 0x40) == 64) {
                this.b(diagnosticInfo.getInnerDiagnosticInfo());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void c(Double d2) throws EncodingException {
        try {
            if (d2 == null) {
                this.l(d2);
                this.tv.putDouble(0.0);
            } else {
                this.tv.putDouble(d2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Enumeration enumeration) throws EncodingException {
        try {
            if (enumeration == null) {
                this.tv.putInt(0);
                return;
            }
            this.tv.putInt(enumeration.getValue());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void c(ExpandedNodeId expandedNodeId) throws EncodingException {
        try {
            if (expandedNodeId == null) {
                expandedNodeId = ExpandedNodeId.NULL;
            }
            int n2 = 0;
            if (expandedNodeId.getNamespaceUri() != null) {
                n2 = (byte)(n2 | 0x80);
            }
            if (expandedNodeId.getServerIndex() != null) {
                n2 = (byte)(n2 | 0x40);
            }
            switch (expandedNodeId.getIdType()) {
                case Numeric: {
                    UnsignedInteger unsignedInteger = (UnsignedInteger)expandedNodeId.getValue();
                    if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() == 0) {
                        this.tx[0] = (byte)(0 | n2);
                        this.tx[1] = unsignedInteger.byteValue();
                        this.tv.put(this.tx);
                        break;
                    }
                    if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() < 256) {
                        this.ty[0] = (byte)(1 | n2);
                        this.ty[1] = (byte)expandedNodeId.getNamespaceIndex();
                        LittleEndianByteUtils.writeShort(unsignedInteger.shortValue(), this.ty, 2);
                        this.tv.put(this.ty);
                        break;
                    }
                    this.tz[0] = (byte)(2 | n2);
                    LittleEndianByteUtils.writeShort((short)expandedNodeId.getNamespaceIndex(), this.tz, 1);
                    LittleEndianByteUtils.writeInt(unsignedInteger.intValue(), this.tz, 3);
                    this.tv.put(this.tz);
                    break;
                }
                case String: {
                    this.p(3 | n2);
                    this.tv.putShort((short)expandedNodeId.getNamespaceIndex());
                    this.H((String)expandedNodeId.getValue());
                    break;
                }
                case Opaque: {
                    this.p(5 | n2);
                    this.tv.putShort((short)expandedNodeId.getNamespaceIndex());
                    this.e((ByteString)expandedNodeId.getValue());
                    break;
                }
                case Guid: {
                    this.p(4 | n2);
                    this.tv.putShort((short)expandedNodeId.getNamespaceIndex());
                    this.a((UUID)expandedNodeId.getValue());
                    break;
                }
                default: {
                    throw new EncodingException("Unsupported (Expanded)NodeId Encoding byte " + expandedNodeId.getIdType());
                }
            }
            if (expandedNodeId.getNamespaceUri() != null) {
                this.H(expandedNodeId.getNamespaceUri());
            }
            if (expandedNodeId.getServerIndex() != null) {
                this.tv.putInt(expandedNodeId.getServerIndex().intValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(ExtensionObject extensionObject) throws EncodingException {
        NodeId nodeId;
        if (extensionObject == null) {
            this.l(extensionObject);
            this.o(null);
            this.p(0);
            return;
        }
        if (!extensionObject.isEncoded()) {
            this.b(ExtensionObject.binaryEncode((Structure)extensionObject.getObject(), this.ctx, this.lF));
            return;
        }
        try {
            nodeId = this.ctx.getNamespaceTable().toNodeId(extensionObject.getTypeId());
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not get namespace index for given id");
        }
        this.o(nodeId);
        Object object = extensionObject.getObject();
        if (object == null) {
            this.p(0);
        } else if (extensionObject.getEncodeType() == EncodeType.Binary) {
            this.p(1);
            this.e((ByteString)object);
        } else if (extensionObject.getEncodeType() == EncodeType.Xml) {
            this.p(2);
            this.a((XmlElement)object);
        } else {
            throw new EncodingException("Unexpected object " + (Object)((Object)extensionObject.getEncodeType()));
        }
    }

    private void b(ExtensionObject[] extensionObjectArray) throws EncodingException {
        try {
            if (extensionObjectArray == null) {
                this.tv.put(tu);
                return;
            }
            this.assertArrayLength(extensionObjectArray.length);
            this.tv.putInt(extensionObjectArray.length);
            for (ExtensionObject extensionObject : extensionObjectArray) {
                this.b(extensionObject);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(Structure[] structureArray) throws EncodingException {
        try {
            if (structureArray == null) {
                this.tv.put(tu);
                return;
            }
            this.assertArrayLength(structureArray.length);
            this.tv.putInt(structureArray.length);
            for (Structure structure : structureArray) {
                this.b(new ExtensionObject(structure));
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Float f2) throws EncodingException {
        try {
            if (f2 == null) {
                this.l(f2);
                this.tv.putFloat(0.0f);
            } else {
                this.tv.putFloat(f2.floatValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UUID uUID) throws EncodingException {
        try {
            if (uUID == null) {
                this.l(uUID);
                this.tv.putLong(0L);
                this.tv.putLong(0L);
            } else {
                int n2;
                long l2 = uUID.getMostSignificantBits();
                long l3 = uUID.getLeastSignificantBits();
                byte[] byArray = new byte[16];
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray[n2] = (byte)(l2 >>> 8 * (7 - n2));
                }
                for (n2 = 8; n2 < 16; ++n2) {
                    byArray[n2] = (byte)(l3 >>> 8 * (7 - n2));
                }
                this.tv.put(byArray[3]);
                this.tv.put(byArray[2]);
                this.tv.put(byArray[1]);
                this.tv.put(byArray[0]);
                this.tv.put(byArray[5]);
                this.tv.put(byArray[4]);
                this.tv.put(byArray[7]);
                this.tv.put(byArray[6]);
                for (n2 = 8; n2 < 16; ++n2) {
                    this.tv.put(byArray[n2]);
                }
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Short s2) throws EncodingException {
        try {
            if (s2 == null) {
                this.l(s2);
                this.tv.putShort((short)0);
            } else {
                this.tv.putShort(s2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void c(Integer n2) throws EncodingException {
        try {
            if (n2 == null) {
                this.l(n2);
                this.tv.putInt(0);
            } else {
                this.tv.putInt(n2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(int[] nArray) throws EncodingException {
        if (nArray == null) {
            this.eBr();
            return;
        }
        this.assertArrayLength(nArray.length);
        this.o(nArray.length);
        for (int n2 : nArray) {
            this.o(n2);
        }
    }

    private void o(int n2) throws EncodingException {
        try {
            this.tv.putInt(n2);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(Long l2) throws EncodingException {
        try {
            if (l2 == null) {
                this.l(l2);
                this.tv.putLong(0L);
            } else {
                this.tv.putLong(l2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void b(LocalizedText localizedText) throws EncodingException {
        try {
            if (localizedText == null) {
                this.putSByte(null, 0);
                return;
            }
            localizedText = localizedText.asSingleLocale(this.getLocales());
            String string = localizedText.getLocaleId();
            String string2 = localizedText.getText();
            boolean bl = string != null && !string.isEmpty();
            boolean bl2 = string2 != null && !string2.isEmpty();
            byte by = (byte)((bl ? 1 : 0) | (bl2 ? 2 : 0));
            this.tv.put(by);
            if (bl) {
                this.H(string);
            }
            if (bl2) {
                this.H(string2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void o(NodeId nodeId) throws EncodingException {
        try {
            if (nodeId == null) {
                nodeId = NodeId.NULL;
            }
            switch (nodeId.getIdType()) {
                case Numeric: {
                    UnsignedInteger unsignedInteger = (UnsignedInteger)nodeId.getValue();
                    if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() == 0) {
                        this.tx[0] = 0;
                        this.tx[1] = unsignedInteger.byteValue();
                        this.tv.put(this.tx);
                        break;
                    }
                    if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() < 256) {
                        this.ty[0] = 1;
                        this.ty[1] = (byte)nodeId.getNamespaceIndex();
                        LittleEndianByteUtils.writeShort(unsignedInteger.shortValue(), this.ty, 2);
                        this.tv.put(this.ty);
                        break;
                    }
                    this.tz[0] = 2;
                    LittleEndianByteUtils.writeShort((short)nodeId.getNamespaceIndex(), this.tz, 1);
                    LittleEndianByteUtils.writeInt(unsignedInteger.intValue(), this.tz, 3);
                    this.tv.put(this.tz);
                    break;
                }
                case String: {
                    this.tv.put((byte)3);
                    this.tv.putShort((short)nodeId.getNamespaceIndex());
                    this.H((String)nodeId.getValue());
                    break;
                }
                case Opaque: {
                    this.tv.put((byte)5);
                    this.tv.putShort((short)nodeId.getNamespaceIndex());
                    this.e((ByteString)nodeId.getValue());
                    break;
                }
                case Guid: {
                    UUID uUID = (UUID)nodeId.getValue();
                    this.tv.put((byte)4);
                    this.tv.putShort((short)nodeId.getNamespaceIndex());
                    this.a(uUID);
                    break;
                }
                default: {
                    throw new EncodingException("Unknown IdType: " + nodeId.getIdType());
                }
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void eBr() throws EncodingException {
        try {
            this.tv.put(tu);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UaOptionSet uaOptionSet, OptionSetSpecification optionSetSpecification) throws EncodingException {
        if (uaOptionSet == null) {
            this.put(null, null, optionSetSpecification.getBaseTypeId(), 0);
        } else {
            this.put(null, uaOptionSet.getValue(), optionSetSpecification.getBaseTypeId(), 0);
        }
    }

    private void d(QualifiedName qualifiedName) throws EncodingException {
        try {
            if (qualifiedName == null) {
                this.tv.putShort((short)0);
                this.H(null);
                return;
            }
            this.tv.putShort((short)qualifiedName.getNamespaceIndex());
            this.H(qualifiedName.getName());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Byte by) throws EncodingException {
        try {
            if (by == null) {
                this.l(by);
                this.p(0);
            } else {
                this.tv.put(by);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void p(int n2) throws EncodingException {
        this.a((byte)n2);
    }

    private void a(byte by) throws EncodingException {
        try {
            this.tv.put(by);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(StatusCode statusCode) throws EncodingException {
        try {
            if (statusCode == null) {
                this.l(statusCode);
                this.tv.putInt(StatusCode.GOOD.getValueAsIntBits());
            } else {
                this.tv.putInt(statusCode.getValueAsIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void H(String string) throws EncodingException {
        try {
            if (string == null) {
                this.l(string);
                this.tv.put(tu);
            } else {
                this.assertStringLength(string.length());
                byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                this.tv.putInt(byArray.length);
                this.tv.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        try {
            if (structure == null) {
                structure = structureSpecification.toInstanceBuilder().build();
            }
            try {
                switch (structureSpecification.getStructureType()) {
                    case UNION: 
                    case UNION_SUBTYPES: {
                        this.c(structure, structureSpecification);
                        break;
                    }
                    case OPTIONAL: {
                        this.b(structure, structureSpecification);
                        break;
                    }
                    case SUBTYPES: 
                    case NORMAL: {
                        structure.forEachField(structureSpecification, (fieldSpecification, object) -> this.put(null, object, fieldSpecification.getEncodeTypeId(), fieldSpecification.getJavaClassDimensions()));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown StructureType: " + (Object)((Object)structureSpecification.getStructureType()));
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getCause() instanceof EncodingException) {
                    throw (EncodingException)runtimeException.getCause();
                }
                throw runtimeException;
            }
        }
        catch (Exception exception) {
            throw new EncodingException("Could not encode Structure", exception);
        }
    }

    private void b(Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        this.putUInt32("EncodingMask", structure.reduceFields(structureSpecification, UnsignedInteger.ZERO, (unsignedInteger, fieldSpecification, object) -> {
            if (fieldSpecification.isOptional()) {
                atomicInteger.incrementAndGet();
                if (object != null) {
                    unsignedInteger = BinaryEncoder.b(unsignedInteger, atomicInteger.get());
                }
            }
            return unsignedInteger;
        }));
        structure.forEachField(structureSpecification, (fieldSpecification, object) -> {
            if (object == null && fieldSpecification.isOptional()) {
                return;
            }
            this.put(null, object, fieldSpecification.getDataTypeId(), fieldSpecification.getJavaClassDimensions());
        });
    }

    private void c(Structure structure, StructureSpecification structureSpecification) throws EncodingException {
        Union union = (Union)structure;
        FieldSpecification fieldSpecification = union.type();
        if (fieldSpecification == null || fieldSpecification.getFieldIndex() >= structureSpecification.getFields().size()) {
            this.putUInt32("SwitchField", UnsignedInteger.ZERO);
            return;
        }
        this.putUInt32("SwitchField", UnsignedInteger.valueOf((long)fieldSpecification.getFieldIndex() + 1L));
        Object object = union.value();
        this.put(null, object, fieldSpecification.getEncodeTypeId(), fieldSpecification.getJavaClassDimensions());
    }

    private void a(UnsignedShort unsignedShort) throws EncodingException {
        try {
            if (unsignedShort == null) {
                this.l(unsignedShort);
                this.tv.putShort((short)0);
            } else {
                this.tv.putShort(unsignedShort.toShortBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void k(UnsignedInteger unsignedInteger) throws EncodingException {
        try {
            if (unsignedInteger == null) {
                this.l(unsignedInteger);
                this.tv.putInt(0);
            } else {
                this.tv.putInt(unsignedInteger.toIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(UnsignedLong unsignedLong) throws EncodingException {
        try {
            if (unsignedLong == null) {
                this.l(unsignedLong);
                this.tv.putLong(0L);
            } else {
                this.tv.putLong(unsignedLong.toLongBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(XmlElement xmlElement) throws EncodingException {
        try {
            if (xmlElement == null) {
                this.tv.put(tu);
            } else {
                this.b(xmlElement.getData());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Deprecated
    void a(int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.putBooleanArray(null, (Boolean[])object);
                break;
            }
            case 2: {
                this.putSByteArray(null, (Byte[])object);
                break;
            }
            case 3: {
                this.putByteArray(null, (UnsignedByte[])object);
                break;
            }
            case 4: {
                this.putInt16Array(null, (Short[])object);
                break;
            }
            case 5: {
                this.putUInt16Array(null, (UnsignedShort[])object);
                break;
            }
            case 6: {
                this.putInt32Array((String)null, (Integer[])object);
                break;
            }
            case 7: {
                this.putUInt32Array(null, (UnsignedInteger[])object);
                break;
            }
            case 8: {
                this.putInt64Array(null, (Long[])object);
                break;
            }
            case 9: {
                this.putUInt64Array(null, (UnsignedLong[])object);
                break;
            }
            case 10: {
                this.putFloatArray(null, (Float[])object);
                break;
            }
            case 11: {
                this.putDoubleArray(null, (Double[])object);
                break;
            }
            case 12: {
                this.putStringArray(null, (String[])object);
                break;
            }
            case 13: {
                this.putDateTimeArray(null, (DateTime[])object);
                break;
            }
            case 14: {
                this.putGuidArray(null, (UUID[])object);
                break;
            }
            case 15: {
                this.putByteStringArray(null, (ByteString[])object);
                break;
            }
            case 16: {
                this.putXmlElementArray(null, (XmlElement[])object);
                break;
            }
            case 17: {
                this.putNodeIdArray(null, (NodeId[])object);
                break;
            }
            case 18: {
                this.putExpandedNodeIdArray(null, (ExpandedNodeId[])object);
                break;
            }
            case 19: {
                this.putStatusCodeArray(null, (StatusCode[])object);
                break;
            }
            case 20: {
                this.putQualifiedNameArray(null, (QualifiedName[])object);
                break;
            }
            case 21: {
                this.putLocalizedTextArray(null, (LocalizedText[])object);
                break;
            }
            case 22: {
                if (object instanceof ExtensionObject[]) {
                    this.b((ExtensionObject[])object);
                    break;
                }
                if (object instanceof Structure[]) {
                    this.b((Structure[])object);
                    break;
                }
                throw new EncodingException("cannot encode " + object);
            }
            case 23: {
                this.putDataValueArray(null, (DataValue[])object);
                break;
            }
            case 24: {
                this.putVariantArray(null, (Variant[])object);
                break;
            }
            case 25: {
                this.putDiagnosticInfoArray(null, (DiagnosticInfo[])object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    @Deprecated
    void b(int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.a((Boolean)object);
                break;
            }
            case 2: {
                this.a((Byte)object);
                break;
            }
            case 3: {
                this.a((UnsignedByte)object);
                break;
            }
            case 4: {
                this.a((Short)object);
                break;
            }
            case 5: {
                this.a((UnsignedShort)object);
                break;
            }
            case 6: {
                this.c((Integer)object);
                break;
            }
            case 7: {
                this.k((UnsignedInteger)object);
                break;
            }
            case 8: {
                this.b((Long)object);
                break;
            }
            case 9: {
                this.a((UnsignedLong)object);
                break;
            }
            case 10: {
                this.a((Float)object);
                break;
            }
            case 11: {
                this.c((Double)object);
                break;
            }
            case 12: {
                this.H((String)object);
                break;
            }
            case 13: {
                this.e((DateTime)object);
                break;
            }
            case 14: {
                this.a((UUID)object);
                break;
            }
            case 15: {
                this.e((ByteString)object);
                break;
            }
            case 16: {
                this.a((XmlElement)object);
                break;
            }
            case 17: {
                this.o((NodeId)object);
                break;
            }
            case 18: {
                this.c((ExpandedNodeId)object);
                break;
            }
            case 19: {
                this.a((StatusCode)object);
                break;
            }
            case 20: {
                this.d((QualifiedName)object);
                break;
            }
            case 21: {
                this.b((LocalizedText)object);
                break;
            }
            case 22: {
                if (object instanceof Structure) {
                    this.b(new ExtensionObject((Structure)object));
                    break;
                }
                this.b((ExtensionObject)object);
                break;
            }
            case 23: {
                this.k((DataValue)object);
                break;
            }
            case 24: {
                this.e((Variant)object);
                break;
            }
            case 25: {
                this.b((DiagnosticInfo)object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    void e(Variant variant) throws EncodingException {
        boolean bl;
        int n2;
        if (variant == null) {
            this.l(variant);
            this.p(0);
            return;
        }
        ExtensionObject[] extensionObjectArray = variant.getValue();
        if (extensionObjectArray == null) {
            this.p(0);
            return;
        }
        Class<?> clazz = variant.getCompositeClass();
        Integer n3 = BuiltinsMap.ID_MAP.get(clazz);
        if (n3 != null) {
            n2 = n3;
            bl = false;
        } else if (Structure.class.isAssignableFrom(clazz)) {
            n2 = 22;
            bl = false;
        } else if (BigDecimal.class.isAssignableFrom(clazz)) {
            n2 = 22;
            bl = true;
        } else {
            throw new EncodingException("Non-suitable composite class for Variant: " + clazz);
        }
        if (!variant.isArray()) {
            this.p(n2);
            if (bl) {
                extensionObjectArray = BinaryEncoder.a((BigDecimal)extensionObjectArray);
            }
            this.b(n2, (Object)extensionObjectArray);
            return;
        }
        int n4 = variant.getDimension();
        if (n4 == 1) {
            this.p(n2 | 0x80);
            if (bl) {
                extensionObjectArray = BinaryEncoder.a((BigDecimal[])extensionObjectArray);
            }
            this.a(n2, (Object)extensionObjectArray);
            return;
        }
        int[] nArray = variant.getArrayDimensions();
        int n5 = MultiDimensionArrayUtils.getLength(nArray);
        MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(variant.getValue(), variant.getArrayDimensions());
        try {
            this.p(n2 | 0xC0);
            this.tv.putInt(n5);
            while (arrayIterator.hasNext()) {
                Object object = arrayIterator.next();
                if (bl) {
                    object = BinaryEncoder.a((BigDecimal)object);
                }
                this.b(n2, object);
            }
            this.a(nArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EncodingException("The dimensions of inner array elements of a multi-dimension variable must be equal in length", arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    static {
        tf = new ExpandedNodeId("http://opcfoundation.org/UA/", Identifiers.Decimal.getValue());
        BinaryEncoder.b(UaIds.Boolean, Boolean.class, (binaryEncoder, string, bl, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Boolean)bl));
        BinaryEncoder.b(UaIds.SByte, Byte.class, (binaryEncoder, string, by, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Byte)by));
        BinaryEncoder.b(UaIds.Byte, UnsignedByte.class, (binaryEncoder, string, unsignedByte, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((UnsignedByte)unsignedByte));
        BinaryEncoder.b(UaIds.Int16, Short.class, (binaryEncoder, string, s2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Short)s2));
        BinaryEncoder.b(UaIds.UInt16, UnsignedShort.class, (binaryEncoder, string, unsignedShort, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((UnsignedShort)unsignedShort));
        BinaryEncoder.b(UaIds.Int32, Integer.class, (binaryEncoder, string, n2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.c((Integer)n2));
        BinaryEncoder.b(UaIds.UInt32, UnsignedInteger.class, (binaryEncoder, string, unsignedInteger, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.k((UnsignedInteger)unsignedInteger));
        BinaryEncoder.b(UaIds.Int64, Long.class, (binaryEncoder, string, l2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((Long)l2));
        BinaryEncoder.b(UaIds.UInt64, UnsignedLong.class, (binaryEncoder, string, unsignedLong, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((UnsignedLong)unsignedLong));
        BinaryEncoder.b(UaIds.Float, Float.class, (binaryEncoder, string, f2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Float)f2));
        BinaryEncoder.b(UaIds.Double, Double.class, (binaryEncoder, string, d2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.c((Double)d2));
        BinaryEncoder.b(UaIds.String, String.class, (binaryEncoder, string, string2, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.H((String)string2));
        BinaryEncoder.b(UaIds.Guid, UUID.class, (binaryEncoder, string, uUID, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((UUID)uUID));
        BinaryEncoder.b(UaIds.ByteString, ByteString.class, (binaryEncoder, string, byteString, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.e((ByteString)byteString));
        BinaryEncoder.b(UaIds.XmlElement, XmlElement.class, (binaryEncoder, string, xmlElement, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((XmlElement)xmlElement));
        BinaryEncoder.b(UaIds.NodeId, NodeId.class, (binaryEncoder, string, nodeId, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.o((NodeId)nodeId));
        BinaryEncoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (binaryEncoder, string, expandedNodeId, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.c((ExpandedNodeId)expandedNodeId));
        BinaryEncoder.b(UaIds.StatusCode, StatusCode.class, (binaryEncoder, string, statusCode, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((StatusCode)statusCode));
        BinaryEncoder.b(UaIds.QualifiedName, QualifiedName.class, (binaryEncoder, string, qualifiedName, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.d((QualifiedName)qualifiedName));
        BinaryEncoder.b(UaIds.LocalizedText, LocalizedText.class, (binaryEncoder, string, localizedText, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((LocalizedText)localizedText));
        tk = (binaryEncoder, string, dateTime, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.e((DateTime)dateTime);
        BinaryEncoder.a(UaIds.DateTime, DateTime.class, tk);
        tl = (binaryEncoder, string, extensionObject, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((ExtensionObject)extensionObject);
        BinaryEncoder.a(UaIds.Structure, ExtensionObject.class, tl);
        tm = (binaryEncoder, string, structure, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                binaryEncoder.a((Structure)structure, (StructureSpecification)uaDataTypeSpecification);
                return;
            }
            StructureSpecification structureSpecification = binaryEncoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new EncodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            binaryEncoder.a((Structure)structure, structureSpecification);
        };
        tn = (binaryEncoder, string, dataValue, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.k((DataValue)dataValue);
        BinaryEncoder.a(UaIds.DataValue, DataValue.class, tn);
        to = (binaryEncoder, string, variant, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.e((Variant)variant);
        tp = (binaryEncoder, string, diagnosticInfo, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((DiagnosticInfo)diagnosticInfo);
        BinaryEncoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, tp);
        tq = (binaryEncoder, string, enumeration, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.a((Enumeration)enumeration);
        tr = (binaryEncoder, string, bigDecimal, uaNodeId, uaDataTypeSpecification) -> binaryEncoder.b((BigDecimal)bigDecimal);
        BinaryEncoder.a(UaIds.Decimal, BigDecimal.class, tr);
        ts = (binaryEncoder, string, uaOptionSet, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                binaryEncoder.a((UaOptionSet)uaOptionSet, (OptionSetSpecification)uaDataTypeSpecification);
                return;
            }
            OptionSetSpecification optionSetSpecification = binaryEncoder.getEncoderContext().getOptionSetSpecification(uaNodeId);
            if (optionSetSpecification == null) {
                throw new EncodingException("Cannot resolve OptionSetSpecification for: " + uaNodeId);
            }
            binaryEncoder.a((UaOptionSet)uaOptionSet, optionSetSpecification);
        };
        tt = (binaryEncoder, string, object, uaNodeId, uaDataTypeSpecification) -> {
            if (object == null) {
                to.put(binaryEncoder, string, null, UaIds.BaseDataType, uaDataTypeSpecification);
            } else if (object instanceof Variant) {
                to.put(binaryEncoder, string, (Variant)object, UaIds.BaseDataType, uaDataTypeSpecification);
            } else {
                to.put(binaryEncoder, string, new Variant(object), UaIds.BaseDataType, uaDataTypeSpecification);
            }
        };
        BinaryEncoder.b(null, Object.class, tt);
        BinaryEncoder.tj[24] = tt;
        BinaryEncoder.tj[22] = tl;
        tu = LittleEndianByteUtils.intToBytes(-1);
    }

    private static interface a<T> {
        public void put(BinaryEncoder var1, String var2, T var3, UaNodeId var4, UaDataTypeSpecification var5) throws EncodingException;
    }
}

