/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding;

import com.prosysopc.ua.CommonCodegenModel;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import com.prosysopc.ua.types.opcua.CommonInformationModel;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class EncoderContext {
    private static final EnumerationSpecification sJ;
    private NamespaceTable je;
    private ServerTable sK;
    private int maxMessageSize = 0;
    private int sL = UnsignedShort.MAX_VALUE.intValue() * 64;
    private int sM = UnsignedShort.MAX_VALUE.intValue() * 64;
    private int sN = UnsignedShort.MAX_VALUE.intValue() * 64;
    private final Map<UaNodeId, UaDataTypeSpecification> specifications = new ConcurrentHashMap<UaNodeId, UaDataTypeSpecification>();
    private volatile Function<UaNodeId, UaDataTypeSpecification> sO;

    public static EncoderContext coreNamespaceOnly() {
        return a.sQ;
    }

    @Deprecated
    public static EncoderContext getDefaultInstance() {
        return a.sP;
    }

    private static Class<?> c(Class<?> clazz, Class<?> clazz2) {
        while (!clazz.isAssignableFrom(clazz2)) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public EncoderContext(NamespaceTable namespaceTable, ServerTable serverTable) {
        this.je = namespaceTable;
        this.sK = serverTable;
        this.registerModel(CommonInformationModel.MODEL);
        this.addDataTypeSpecification(AbstractStructure.SPECIFICATION);
        this.addDataTypeSpecification(sJ);
    }

    public EncoderContext(NamespaceTable namespaceTable, ServerTable serverTable, int n2) {
        this.je = namespaceTable;
        this.sK = serverTable;
        this.maxMessageSize = n2;
        this.registerModel(CommonInformationModel.MODEL);
        this.addDataTypeSpecification(AbstractStructure.SPECIFICATION);
        this.addDataTypeSpecification(sJ);
    }

    public void addDataTypeSpecification(UaDataTypeSpecification uaDataTypeSpecification) {
        if (uaDataTypeSpecification == null) {
            throw new IllegalArgumentException("The given specification cannot be null");
        }
        this.specifications.put(uaDataTypeSpecification.getTypeId(), uaDataTypeSpecification);
        if (uaDataTypeSpecification instanceof StructureSpecification) {
            StructureSpecification structureSpecification = (StructureSpecification)uaDataTypeSpecification;
            if (structureSpecification.getBinaryEncodeId() != null) {
                this.specifications.put(structureSpecification.getBinaryEncodeId(), uaDataTypeSpecification);
            }
            if (structureSpecification.getXmlEncodeId() != null) {
                this.specifications.put(structureSpecification.getXmlEncodeId(), uaDataTypeSpecification);
            }
            if (structureSpecification.getJsonEncodeId() != null) {
                this.specifications.put(structureSpecification.getJsonEncodeId(), uaDataTypeSpecification);
            }
        }
    }

    @Deprecated
    public void addEnumerationSpecification(EnumerationSpecification enumerationSpecification) {
        this.addDataTypeSpecification(enumerationSpecification);
    }

    @Deprecated
    public void addStructureSpecification(StructureSpecification structureSpecification) {
        this.addDataTypeSpecification(structureSpecification);
    }

    public Object decode(ExtensionObject[] extensionObjectArray) throws DecodingException {
        return this.decode(extensionObjectArray, null);
    }

    public Object decode(ExtensionObject[] extensionObjectArray, NamespaceTable namespaceTable) throws DecodingException {
        Structure[] structureArray;
        int n2 = extensionObjectArray.length;
        Structure[] structureArray2 = new Structure[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            structureArray = extensionObjectArray[i2];
            if (structureArray == null) continue;
            structureArray2[i2] = (Structure)structureArray.decode(this, namespaceTable);
        }
        Object object = structureArray2;
        if (n2 > 0) {
            Class<?> clazz = null;
            for (Structure structure : structureArray2) {
                if (structure == null) continue;
                clazz = clazz == null ? structure.getClass() : EncoderContext.c(clazz, structure.getClass());
            }
            if (clazz != null) {
                structureArray = clazz;
                Object object2 = MultiDimensionArrayUtils.map(structureArray2, Structure.class, clazz, arg_0 -> EncoderContext.a((Class)structureArray, arg_0));
                object = object2;
            }
        }
        return object;
    }

    public UaDataTypeSpecification getDataTypeSpecification(UaNodeId uaNodeId) {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given id cannot be null");
        }
        UaDataTypeSpecification uaDataTypeSpecification = this.specifications.get(uaNodeId);
        if (uaDataTypeSpecification != null) {
            return uaDataTypeSpecification;
        }
        Function<UaNodeId, UaDataTypeSpecification> function = this.sO;
        if (function != null) {
            return function.apply(uaNodeId);
        }
        return null;
    }

    public Map<UaNodeId, UaDataTypeSpecification> getDataTypeSpecifications() {
        return Collections.unmodifiableMap(this.specifications);
    }

    public EnumerationSpecification getEnumerationSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification instanceof EnumerationSpecification) {
            return (EnumerationSpecification)uaDataTypeSpecification;
        }
        return null;
    }

    public int getMaxArrayLength() {
        return this.sN;
    }

    public int getMaxByteStringLength() {
        return this.sM;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMaxStringLength() {
        return this.sL;
    }

    public NamespaceTable getNamespaceTable() {
        return this.je;
    }

    public OptionSetSpecification getOptionSetSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification instanceof OptionSetSpecification) {
            return (OptionSetSpecification)uaDataTypeSpecification;
        }
        return null;
    }

    public ServerTable getServerTable() {
        return this.sK;
    }

    public SimpleTypeSpecification getSimpleTypeSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
            return (SimpleTypeSpecification)uaDataTypeSpecification;
        }
        return null;
    }

    public StructureSpecification getStructureSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification instanceof StructureSpecification) {
            return (StructureSpecification)uaDataTypeSpecification;
        }
        return null;
    }

    public void registerModel(CommonCodegenModel commonCodegenModel) {
        if (commonCodegenModel == null) {
            throw new IllegalArgumentException("The given model cannot be null");
        }
        commonCodegenModel.getSpecifications().values().forEach(this::addDataTypeSpecification);
    }

    public void removeDataTypeSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.specifications.remove(uaNodeId);
        if (uaDataTypeSpecification instanceof StructureSpecification) {
            StructureSpecification structureSpecification = (StructureSpecification)uaDataTypeSpecification;
            this.specifications.remove(structureSpecification.getTypeId());
            if (structureSpecification.getBinaryEncodeId() != null) {
                this.specifications.remove(structureSpecification.getBinaryEncodeId());
            }
            if (structureSpecification.getXmlEncodeId() != null) {
                this.specifications.remove(structureSpecification.getXmlEncodeId());
            }
            if (structureSpecification.getBinaryEncodeId() != null) {
                this.specifications.remove(structureSpecification.getJsonEncodeId());
            }
        }
    }

    public void removeDataTypeSpecifications(UaNamespace uaNamespace) {
        this.specifications.entrySet().removeIf(entry -> uaNamespace.equals(((UaNodeId)entry.getKey()).getNamespace()));
    }

    public void setDynamicDataTypeSpecificationProvider(Function<UaNodeId, UaDataTypeSpecification> function) {
        this.sO = function;
    }

    public void setMaxArrayLength(int n2) {
        this.sN = n2;
    }

    public void setMaxByteStringLength(int n2) {
        this.sM = n2;
    }

    public void setMaxMessageSize(int n2) {
        this.maxMessageSize = n2;
    }

    public void setMaxStringLength(int n2) {
        this.sL = n2;
    }

    public void setNamespaceTable(NamespaceTable namespaceTable) {
        this.je = namespaceTable;
    }

    public void setServerTable(ServerTable serverTable) {
        this.sK = serverTable;
    }

    public EncoderContext shallowCopy() {
        EncoderContext encoderContext = new EncoderContext(this.getNamespaceTable(), this.getServerTable());
        encoderContext.setMaxArrayLength(this.getMaxArrayLength());
        encoderContext.setMaxByteStringLength(this.getMaxByteStringLength());
        encoderContext.setMaxMessageSize(this.getMaxMessageSize());
        encoderContext.setMaxStringLength(this.getMaxStringLength());
        encoderContext.specifications.putAll(this.specifications);
        encoderContext.sO = this.sO;
        return encoderContext;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("   namespaceTable = " + this.je + "\n");
        stringBuilder.append("   serverTable = " + this.sK + "\n");
        stringBuilder.append("   maxMessageSize = " + this.maxMessageSize + "\n");
        stringBuilder.append("   maxStringLength = " + this.sL + "\n");
        stringBuilder.append("   maxByteStringLength = " + this.sM + "\n");
        stringBuilder.append("   maxArrayLength = " + this.sN + "\n");
        return stringBuilder.toString();
    }

    private static /* synthetic */ Object a(Class clazz, Structure structure) throws RuntimeException {
        return clazz.cast(structure);
    }

    static {
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setJavaClass(Enumeration.class);
        builder.setName("Enumeration");
        builder.setTypeId(UaIds.Enumeration);
        sJ = builder.build();
    }

    private static final class b
    extends EncoderContext {
        private boolean initialized = true;

        public b() {
            super(new NamespaceTable(), null);
        }

        @Override
        public void addDataTypeSpecification(UaDataTypeSpecification uaDataTypeSpecification) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.addDataTypeSpecification(uaDataTypeSpecification);
        }

        @Override
        public void addEnumerationSpecification(EnumerationSpecification enumerationSpecification) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.addEnumerationSpecification(enumerationSpecification);
        }

        @Override
        public void addStructureSpecification(StructureSpecification structureSpecification) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.addStructureSpecification(structureSpecification);
        }

        @Override
        public void registerModel(CommonCodegenModel commonCodegenModel) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.registerModel(commonCodegenModel);
        }

        @Override
        public void removeDataTypeSpecification(UaNodeId uaNodeId) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.removeDataTypeSpecification(uaNodeId);
        }

        @Override
        public void removeDataTypeSpecifications(UaNamespace uaNamespace) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.removeDataTypeSpecifications(uaNamespace);
        }

        @Override
        public void setDynamicDataTypeSpecificationProvider(Function<UaNodeId, UaDataTypeSpecification> function) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.setDynamicDataTypeSpecificationProvider(function);
        }

        @Override
        public void setMaxArrayLength(int n2) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.setMaxArrayLength(n2);
        }

        @Override
        public void setMaxByteStringLength(int n2) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.setMaxByteStringLength(n2);
        }

        @Override
        public void setMaxMessageSize(int n2) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.setMaxMessageSize(n2);
        }

        @Override
        public void setMaxStringLength(int n2) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.setMaxStringLength(n2);
        }

        @Override
        public void setNamespaceTable(NamespaceTable namespaceTable) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.setNamespaceTable(namespaceTable);
        }

        @Override
        public void setServerTable(ServerTable serverTable) {
            if (this.initialized) {
                throw new UnsupportedOperationException("This EncoderContext is unmodifiable");
            }
            super.setServerTable(serverTable);
        }
    }

    private static final class a {
        static final EncoderContext sP = new EncoderContext(NamespaceTable.getDefaultInstance(), null);
        static final EncoderContext sQ = new b();

        private a() {
        }
    }
}

