/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=456")
public class SignatureData
extends DynamicStructure {
    public static final StructureSpecification SPECIFICATION;

    public SignatureData() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected SignatureData(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public SignatureData(String string, ByteString byteString) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setAlgorithm(string);
        this.setSignature(byteString);
    }

    public String getAlgorithm() {
        return (String)this.indexGet(0);
    }

    public void setAlgorithm(String string) {
        this.indexSet(string, 0);
    }

    public ByteString getSignature() {
        return (ByteString)this.indexGet(1);
    }

    public void setSignature(ByteString byteString) {
        this.indexSet(byteString, 1);
    }

    @Override
    public SignatureData clone() {
        return (SignatureData)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new SignatureData());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Algorithm);
        builder.addField(Fields.Signature);
        builder.setBinaryEncodeId(UaIds.SignatureData_DefaultBinary);
        builder.setXmlEncodeId(UaIds.SignatureData_DefaultXml);
        builder.setJsonEncodeId(UaIds.SignatureData_DefaultJson);
        builder.setTypeId(UaIds.SignatureData);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("SignatureData");
        builder.setJavaClass(SignatureData.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new SignatureData((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(SignatureData.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public String getAlgorithm() {
            return (String)this.indexGet(0);
        }

        public Builder setAlgorithm(String string) {
            this.indexSet(string, 0);
            return this;
        }

        public ByteString getSignature() {
            return (ByteString)this.indexGet(1);
        }

        public Builder setSignature(ByteString byteString) {
            this.indexSet(byteString, 1);
            return this;
        }

        @Override
        public SignatureData build() {
            return (SignatureData)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Algorithm(0, "Algorithm", String.class, false, UaIds.String, -1, null, false, 0),
        Signature(1, "Signature", ByteString.class, false, UaIds.ByteString, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

