/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=389")
public class RequestHeader
extends DynamicStructure {
    public static final StructureSpecification SPECIFICATION;

    public RequestHeader() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected RequestHeader(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public RequestHeader(NodeId nodeId, DateTime dateTime, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String string, UnsignedInteger unsignedInteger3, Structure structure) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setAuthenticationToken(nodeId);
        this.setTimestamp(dateTime);
        this.setRequestHandle(unsignedInteger);
        this.setReturnDiagnostics(unsignedInteger2);
        this.setAuditEntryId(string);
        this.setTimeoutHint(unsignedInteger3);
        this.setAdditionalHeader(structure);
    }

    public NodeId getAuthenticationToken() {
        return (NodeId)this.indexGet(0);
    }

    public void setAuthenticationToken(NodeId nodeId) {
        this.indexSet(nodeId, 0);
    }

    public DateTime getTimestamp() {
        return (DateTime)this.indexGet(1);
    }

    public void setTimestamp(DateTime dateTime) {
        this.indexSet(dateTime, 1);
    }

    public UnsignedInteger getRequestHandle() {
        return (UnsignedInteger)this.indexGet(2);
    }

    public void setRequestHandle(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 2);
    }

    public UnsignedInteger getReturnDiagnostics() {
        return (UnsignedInteger)this.indexGet(3);
    }

    public void setReturnDiagnostics(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 3);
    }

    public String getAuditEntryId() {
        return (String)this.indexGet(4);
    }

    public void setAuditEntryId(String string) {
        this.indexSet(string, 4);
    }

    public UnsignedInteger getTimeoutHint() {
        return (UnsignedInteger)this.indexGet(5);
    }

    public void setTimeoutHint(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 5);
    }

    public Structure getAdditionalHeader() {
        return (Structure)this.indexGet(6);
    }

    public void setAdditionalHeader(Structure structure) {
        this.indexSet(structure, 6);
    }

    @Override
    public RequestHeader clone() {
        return (RequestHeader)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new RequestHeader());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.AuthenticationToken);
        builder.addField(Fields.Timestamp);
        builder.addField(Fields.RequestHandle);
        builder.addField(Fields.ReturnDiagnostics);
        builder.addField(Fields.AuditEntryId);
        builder.addField(Fields.TimeoutHint);
        builder.addField(Fields.AdditionalHeader);
        builder.setBinaryEncodeId(UaIds.RequestHeader_DefaultBinary);
        builder.setXmlEncodeId(UaIds.RequestHeader_DefaultXml);
        builder.setJsonEncodeId(UaIds.RequestHeader_DefaultJson);
        builder.setTypeId(UaIds.RequestHeader);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("RequestHeader");
        builder.setJavaClass(RequestHeader.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new RequestHeader((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(RequestHeader.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public NodeId getAuthenticationToken() {
            return (NodeId)this.indexGet(0);
        }

        public Builder setAuthenticationToken(NodeId nodeId) {
            this.indexSet(nodeId, 0);
            return this;
        }

        public DateTime getTimestamp() {
            return (DateTime)this.indexGet(1);
        }

        public Builder setTimestamp(DateTime dateTime) {
            this.indexSet(dateTime, 1);
            return this;
        }

        public UnsignedInteger getRequestHandle() {
            return (UnsignedInteger)this.indexGet(2);
        }

        public Builder setRequestHandle(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 2);
            return this;
        }

        public UnsignedInteger getReturnDiagnostics() {
            return (UnsignedInteger)this.indexGet(3);
        }

        public Builder setReturnDiagnostics(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 3);
            return this;
        }

        public String getAuditEntryId() {
            return (String)this.indexGet(4);
        }

        public Builder setAuditEntryId(String string) {
            this.indexSet(string, 4);
            return this;
        }

        public UnsignedInteger getTimeoutHint() {
            return (UnsignedInteger)this.indexGet(5);
        }

        public Builder setTimeoutHint(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 5);
            return this;
        }

        public Structure getAdditionalHeader() {
            return (Structure)this.indexGet(6);
        }

        public Builder setAdditionalHeader(Structure structure) {
            this.indexSet(structure, 6);
            return this;
        }

        @Override
        public RequestHeader build() {
            return (RequestHeader)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        AuthenticationToken(0, "AuthenticationToken", NodeId.class, false, UaIds.SessionAuthenticationToken, -1, null, false, 0),
        Timestamp(1, "Timestamp", DateTime.class, false, UaIds.UtcTime, -1, null, false, 0),
        RequestHandle(2, "RequestHandle", UnsignedInteger.class, false, UaIds.IntegerId, -1, null, false, 0),
        ReturnDiagnostics(3, "ReturnDiagnostics", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false, 0),
        AuditEntryId(4, "AuditEntryId", String.class, false, UaIds.String, -1, null, false, 0),
        TimeoutHint(5, "TimeoutHint", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false, 0),
        AdditionalHeader(6, "AdditionalHeader", Structure.class, false, UaIds.Structure, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

