/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=576")
public enum FilterOperator implements Enumeration
{
    Equals(0),
    IsNull(1),
    GreaterThan(2),
    LessThan(3),
    GreaterThanOrEqual(4),
    LessThanOrEqual(5),
    Like(6),
    Not(7),
    Between(8),
    InList(9),
    And(10),
    Or(11),
    Cast(12),
    InView(13),
    OfType(14),
    RelatedTo(15),
    BitwiseAnd(16),
    BitwiseOr(17);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<FilterOperator> NONE;
    public static final EnumSet<FilterOperator> ALL;
    private static final Map<Integer, FilterOperator> map;
    private final int value;

    private FilterOperator(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static FilterOperator valueOf(int n2) {
        return map.get(n2);
    }

    public static FilterOperator valueOf(Integer n2) {
        return n2 == null ? null : FilterOperator.valueOf((int)n2);
    }

    public static FilterOperator valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : FilterOperator.valueOf(unsignedInteger.intValue());
    }

    public static FilterOperator[] valueOf(int[] nArray) {
        FilterOperator[] filterOperatorArray = new FilterOperator[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            filterOperatorArray[i2] = FilterOperator.valueOf(nArray[i2]);
        }
        return filterOperatorArray;
    }

    public static FilterOperator[] valueOf(Integer[] integerArray) {
        FilterOperator[] filterOperatorArray = new FilterOperator[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            filterOperatorArray[i2] = FilterOperator.valueOf(integerArray[i2]);
        }
        return filterOperatorArray;
    }

    public static FilterOperator[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        FilterOperator[] filterOperatorArray = new FilterOperator[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            filterOperatorArray[i2] = FilterOperator.valueOf(unsignedIntegerArray[i2]);
        }
        return filterOperatorArray;
    }

    public static UnsignedInteger getMask(FilterOperator ... filterOperatorArray) {
        int n2 = 0;
        for (FilterOperator filterOperator : filterOperatorArray) {
            n2 |= filterOperator.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<FilterOperator> collection) {
        int n2 = 0;
        for (FilterOperator filterOperator : collection) {
            n2 |= filterOperator.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<FilterOperator> getSet(UnsignedInteger unsignedInteger) {
        return FilterOperator.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<FilterOperator> getSet(int n2) {
        ArrayList<FilterOperator> arrayList = new ArrayList<FilterOperator>();
        for (FilterOperator filterOperator : FilterOperator.values()) {
            if ((n2 & filterOperator.value) != filterOperator.value) continue;
            arrayList.add(filterOperator);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = FilterOperator.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(FilterOperator.class);
        ALL = EnumSet.allOf(FilterOperator.class);
        map = new HashMap<Integer, FilterOperator>();
        for (FilterOperator filterOperator : FilterOperator.values()) {
            map.put(filterOperator.value, filterOperator);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("FilterOperator");
        builder.setJavaClass(FilterOperator.class);
        builder.setTypeId(UaIds.FilterOperator);
        builder.addMapping(0, "Equals");
        builder.addMapping(1, "IsNull");
        builder.addMapping(2, "GreaterThan");
        builder.addMapping(3, "LessThan");
        builder.addMapping(4, "GreaterThanOrEqual");
        builder.addMapping(5, "LessThanOrEqual");
        builder.addMapping(6, "Like");
        builder.addMapping(7, "Not");
        builder.addMapping(8, "Between");
        builder.addMapping(9, "InList");
        builder.addMapping(10, "And");
        builder.addMapping(11, "Or");
        builder.addMapping(12, "Cast");
        builder.addMapping(13, "InView");
        builder.addMapping(14, "OfType");
        builder.addMapping(15, "RelatedTo");
        builder.addMapping(16, "BitwiseAnd");
        builder.addMapping(17, "BitwiseOr");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return FilterOperator.builder();
            }
        });
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(FilterOperator.class, SPECIFICATION);
    }

    public static class Builder
    implements Enumeration.Builder {
        private FilterOperator value;

        private Builder() {
        }

        @Override
        public FilterOperator build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = FilterOperator.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum FilterOperator int value: " + n2);
            }
            return this;
        }
    }
}

